/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;

public final class EngineConfig
implements LifecycleListener {
    private int debug = 0;
    private Engine engine = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            int n;
            this.engine = (Engine)((Object)lifecycleEvent.getLifecycle());
            if (this.engine instanceof StandardEngine && (n = ((StandardEngine)this.engine).getDebug()) > this.debug) {
                this.debug = n;
            }
        }
        catch (ClassCastException classCastException) {
            this.log(sm.getString("engineConfig.cce", lifecycleEvent.getLifecycle()), classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + string);
        } else {
            System.out.println("EngineConfig: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.engine != null) {
            logger = this.engine.getLogger();
        }
        if (logger != null) {
            logger.log("EngineConfig: " + string, throwable);
        } else {
            System.out.println("EngineConfig: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void start() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.start"));
        }
    }

    private void stop() {
        if (this.debug > 0) {
            this.log(sm.getString("engineConfig.stop"));
        }
    }
}

