/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.ssi.ServletOutputStreamWrapper;
import org.apache.catalina.util.ssi.SsiCommand;
import org.apache.catalina.util.ssi.SsiMediator;

public final class SsiInvokerServlet
extends HttpServlet {
    private int debug = 0;
    private boolean buffered = false;
    private Long expires = null;
    private boolean ignoreUnsupportedDirective = false;
    private boolean isVirtualWebappRelative = false;
    private static SsiMediator ssiMediator = null;
    private static final byte[] bStart = new byte[]{60, 33, 45, 45, 35};
    private static final byte[] bEnd = new byte[]{45, 45, 62};

    public void init() throws ServletException {
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("isVirtualWebappRelative");
            this.isVirtualWebappRelative = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("ignoreUnsupportedDirective");
            this.ignoreUnsupportedDirective = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("expires");
            this.expires = Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.expires = null;
            this.log("Invalid format for expires initParam; expected integer (seconds)");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string = this.getServletConfig().getInitParameter("buffered");
            this.buffered = Integer.parseInt(string) > 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doGet()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.doPut()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    private void requestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        String string = this.getRelativePath(httpServletRequest);
        URL uRL = servletContext.getResource(string);
        if (this.debug > 0) {
            this.log("SsiInvokerServlet.requestHandler()\nServing " + (this.buffered ? "buffered " : "unbuffered ") + "resource '" + string + "'");
        }
        if (string == null || string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(404, string);
            return;
        }
        if (uRL == null) {
            httpServletResponse.sendError(404, string);
            return;
        }
        httpServletResponse.setContentType("text/html;charset=UTF-8");
        if (this.expires != null) {
            httpServletResponse.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
        }
        ServletOutputStream servletOutputStream = null;
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(uRLConnection.getContentLength());
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        SsiCommand ssiCommand = null;
        servletOutputStream = this.buffered ? new ServletOutputStreamWrapper() : httpServletResponse.getOutputStream();
        if (ssiMediator == null) {
            ssiMediator = new SsiMediator(httpServletRequest, httpServletResponse, (OutputStream)servletOutputStream, servletContext, this.debug, string, this.isVirtualWebappRelative);
        } else {
            ssiMediator.flush(httpServletRequest, httpServletResponse, (OutputStream)servletOutputStream, servletContext, string, this.isVirtualWebappRelative);
        }
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        byArray = null;
        while (n2 < byArray2.length) {
            if (!bl) {
                if (byArray2[n2] == bStart[0] && this.byteCmp(byArray2, n2, bStart)) {
                    bl = true;
                    n2 += bStart.length;
                    stringBuffer.delete(0, stringBuffer.length());
                    continue;
                }
                servletOutputStream.write(byArray2[n2]);
                ++n2;
                continue;
            }
            if (byArray2[n2] == bEnd[0] && this.byteCmp(byArray2, n2, bEnd)) {
                String string2;
                bl = false;
                n2 += bEnd.length;
                try {
                    string2 = this.parseCmd(stringBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    servletOutputStream.write(ssiMediator.getError());
                    continue;
                }
                string2 = this.parseCmd(stringBuffer);
                String[] stringArray = this.parseParamType(stringBuffer, string2.length());
                String[] stringArray2 = this.parseParam(stringBuffer, string2.length());
                if (this.debug > 0) {
                    this.log("Serving SSI resource: " + string2);
                }
                if ((ssiCommand = ssiMediator.getCommand(string2)) != null && stringArray.length == stringArray2.length && stringArray.length > 0) {
                    if (ssiCommand.isPrintable()) {
                        servletOutputStream.write(ssiCommand.getStream(stringArray, stringArray2).getBytes());
                        continue;
                    }
                    ssiCommand.process(stringArray, stringArray2);
                    continue;
                }
                if (this.ignoreUnsupportedDirective && ssiCommand == null) continue;
                servletOutputStream.write(ssiMediator.getError());
                continue;
            }
            stringBuffer.append((char)byArray2[n2]);
            ++n2;
        }
        if (this.buffered) {
            ((ServletOutputStreamWrapper)servletOutputStream).writeTo((OutputStream)httpServletResponse.getOutputStream());
        }
        servletOutputStream = null;
    }

    private String parseCmd(StringBuffer stringBuffer) throws IndexOutOfBoundsException {
        String string = stringBuffer.toString().trim().toLowerCase();
        return string.substring(0, string.indexOf(32));
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseParamType(StringBuffer var1_1, int var2_2) {
        var3_3 = var2_2;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = false;
        var7_7 = new StringBuffer();
        while (var3_3 < var1_1.length()) {
            if (var6_6) ** GOTO lbl17
            while (var3_3 < var1_1.length() && this.isSpace(var1_1.charAt(var3_3))) {
                ++var3_3;
            }
            if (var3_3 >= var1_1.length()) break;
            var6_6 = var6_6 == false;
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7.append(var1_1.charAt(var3_3));
                ++var3_3;
lbl17:
                // 2 sources

                ** while (var3_3 < var1_1.length() && var1_1.charAt((int)var3_3) != '=')
            }
lbl18:
            // 1 sources

            var7_7.append('\"');
            var6_6 = var6_6 == false;
            var5_5 = 0;
            while (var3_3 < var1_1.length() && var5_5 != 2) {
                if (var1_1.charAt(var3_3) == '\"') {
                    ++var5_5;
                }
                ++var3_3;
            }
        }
        var8_8 = new StringTokenizer(var7_7.toString(), "\"");
        var9_9 = new String[var8_8.countTokens()];
        while (var8_8.hasMoreTokens()) {
            var9_9[var4_4++] = var8_8.nextToken().trim();
        }
        return var9_9;
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseParam(StringBuffer var1_1, int var2_2) {
        var3_3 = var2_2;
        var4_4 = 0;
        var5_5 = false;
        var6_6 = false;
        var7_7 = new StringBuffer();
        while (var3_3 < var1_1.length()) {
            block4: {
                if (var6_6) ** GOTO lbl17
                while (var3_3 < var1_1.length() && var1_1.charAt(var3_3) != '\"') {
                    ++var3_3;
                }
                if (var3_3 >= var1_1.length()) break;
                var6_6 = var6_6 == false;
                break block4;
lbl-1000:
                // 1 sources

                {
                    var7_7.append(var1_1.charAt(var3_3));
                    ++var3_3;
lbl17:
                    // 2 sources

                    ** while (var3_3 < var1_1.length() && var1_1.charAt((int)var3_3) != '\"')
                }
lbl18:
                // 1 sources

                var7_7.append('\"');
                var6_6 = var6_6 == false;
            }
            ++var3_3;
        }
        var8_8 = new StringTokenizer(var7_7.toString(), "\"");
        var9_9 = new String[var8_8.countTokens()];
        while (var8_8.hasMoreTokens()) {
            var9_9[var4_4++] = var8_8.nextToken();
        }
        return var9_9;
    }

    private boolean byteCmp(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray[n + n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private String getRelativePath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            if (string == null) {
                string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            }
            if (string == null || string.equals("")) {
                string = "/";
            }
            return string;
        }
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = httpServletRequest.getServletPath();
        }
        if (string == null || string.equals("")) {
            string = "/";
        }
        return this.normalize(string);
    }

    private String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }
}

