/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRealmUserAction;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.xml.XmlMapper;

public final class MemoryRealm
extends RealmBase {
    private Container container = null;
    protected final String info = "org.apache.catalina.realm.MemoryRealm/1.0";
    protected static final String name = "MemoryRealm";
    private String pathname = "conf/tomcat-users.xml";
    private HashMap principals = new HashMap();
    private static StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    private boolean started = false;

    public String getInfo() {
        return "org.apache.catalina.realm.MemoryRealm/1.0";
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        this.pathname = string;
    }

    public Principal authenticate(String string, String string2) {
        GenericPrincipal genericPrincipal = (GenericPrincipal)this.principals.get(string);
        boolean bl = false;
        if (genericPrincipal != null) {
            bl = this.hasMessageDigest() ? this.digest(string2).equalsIgnoreCase(genericPrincipal.getPassword()) : this.digest(string2).equals(genericPrincipal.getPassword());
        }
        if (bl) {
            if (this.debug >= 2) {
                this.log(sm.getString("memoryRealm.authenticateSuccess", string));
            }
            return genericPrincipal;
        }
        if (this.debug >= 2) {
            this.log(sm.getString("memoryRealm.authenticateFailure", string));
        }
        return null;
    }

    void addUser(String string, String string2, String string3) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        string3 = string3 + ",";
        while ((n = string3.indexOf(44)) >= 0) {
            String string4 = string3.substring(0, n).trim();
            arrayList.add(string4);
            string3 = string3.substring(n + 1);
        }
        GenericPrincipal genericPrincipal = new GenericPrincipal(this, string, string2, arrayList);
        this.principals.put(string, genericPrincipal);
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String string) {
        GenericPrincipal genericPrincipal = (GenericPrincipal)this.principals.get(string);
        if (genericPrincipal != null) {
            return genericPrincipal.getPassword();
        }
        return null;
    }

    protected Principal getPrincipal(String string) {
        return (Principal)this.principals.get(string);
    }

    public synchronized void start() throws LifecycleException {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            throw new LifecycleException(sm.getString("memoryRealm.loadExist", file.getAbsolutePath()));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("memoryRealm.loadPath", file.getAbsolutePath()));
        }
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.addRule("tomcat-users/user", new MemoryRealmUserAction());
        try {
            xmlMapper.readXml(file, (Object)this);
        }
        catch (Exception exception) {
            throw new LifecycleException("memoryRealm.readXml", exception);
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
    }
}

