/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import com.iplanet.ias.loader.JasperAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.loader.WebappContextNotifier;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;

public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
Runnable {
    private int checkInterval = 15;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private int debug = 0;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "WebappLoader";

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int n) {
        int n2 = this.checkInterval;
        this.checkInterval = n;
        this.support.firePropertyChange("checkInterval", new Integer(n2), new Integer(this.checkInterval));
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        boolean bl2 = this.delegate;
        this.delegate = bl;
        this.support.firePropertyChange("delegate", new Boolean(bl2), new Boolean(this.delegate));
    }

    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String string) {
        this.loaderClass = string;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean bl) {
        boolean bl2 = this.reloadable;
        this.reloadable = bl;
        this.support.firePropertyChange("reloadable", new Boolean(bl2), new Boolean(this.reloadable));
        if (!this.started) {
            return;
        }
        if (!bl2 && this.reloadable) {
            this.threadStart();
        } else if (bl2 && !this.reloadable) {
            this.threadStop();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addRepository(String string) {
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.addRepository", string));
        }
        int n = 0;
        while (n < this.repositories.length) {
            if (string.equals(this.repositories[n])) {
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.repositories.length + 1];
        int n2 = 0;
        while (n2 < this.repositories.length) {
            stringArray[n2] = this.repositories[n2];
            ++n2;
        }
        stringArray[this.repositories.length] = string;
        this.repositories = stringArray;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(string);
            this.setClassPath();
        }
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public boolean modified() {
        return this.classLoader.modified();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WebappLoader[");
        if (this.container != null) {
            stringBuffer.append(this.container.getName());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container.getResources() == null) {
            return;
        }
        DirContextURLStreamHandlerFactory dirContextURLStreamHandlerFactory = new DirContextURLStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory(dirContextURLStreamHandlerFactory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.classLoader = this.parentClassLoader == null ? new WebappClassLoader(this.container.getResources()) : new WebappClassLoader(this.parentClassLoader, this.container.getResources());
            this.classLoader.setDebug(this.debug);
            this.classLoader.setDelegate(this.delegate);
            int n = 0;
            while (n < this.repositories.length) {
                this.classLoader.addRepository(this.repositories[n]);
                ++n;
            }
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            if (this.classLoader instanceof Lifecycle) {
                this.classLoader.start();
            }
            DirContextURLStreamHandler.bind(this.classLoader, this.container.getResources());
        }
        catch (Throwable throwable) {
            throw new LifecycleException("start: ", throwable);
        }
        this.validatePackages();
        if (this.reloadable) {
            this.log(sm.getString("webappLoader.reloading"));
            try {
                this.threadStart();
            }
            catch (IllegalStateException illegalStateException) {
                throw new LifecycleException(illegalStateException);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.reloadable) {
            this.threadStop();
        }
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            this.classLoader.stop();
        }
        DirContextURLStreamHandler.unbind(this.classLoader);
        this.classLoader = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block3: {
            if (!(propertyChangeEvent.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)propertyChangeEvent.getSource();
            if (!propertyChangeEvent.getPropertyName().equals("reloadable")) break block3;
            try {
                this.setReloadable((Boolean)propertyChangeEvent.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("webappLoader.reloadable", propertyChangeEvent.getNewValue().toString()));
            }
        }
    }

    private void log(String string) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "]: " + string);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("WebappLoader[" + string2 + "]: " + string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "] " + string, throwable);
        } else {
            String string2 = null;
            if (this.container != null) {
                string2 = this.container.getName();
            }
            System.out.println("WebappLoader[" + string2 + "]: " + string);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void notifyContext() {
        WebappContextNotifier webappContextNotifier = new WebappContextNotifier((Context)this.container);
        new Thread(webappContextNotifier).start();
    }

    private void setPermissions() {
        block17: {
            if (System.getSecurityManager() == null) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            try {
                String string;
                File file;
                URL uRL;
                URL uRL2;
                URL uRL3 = servletContext.getResource("/");
                this.classLoader.addPermission(uRL3);
                String string2 = servletContext.getRealPath("/");
                if (string2 != null) {
                    try {
                        string2 = new File(string2).getCanonicalPath() + File.separator;
                        this.classLoader.addPermission(string2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((uRL2 = servletContext.getResource("/WEB-INF/classes/")) != null) {
                    this.classLoader.addPermission(uRL2);
                }
                if ((uRL = servletContext.getResource("/WEB-INF/lib/")) != null) {
                    this.classLoader.addPermission(uRL);
                }
                if (string2 != null) {
                    if (uRL == null) break block17;
                    File file2 = new File(string2);
                    File file3 = new File(file2, "WEB-INF/lib/");
                    String string3 = null;
                    try {
                        string3 = file3.getCanonicalPath() + File.separator;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (string3 == null) break block17;
                    this.classLoader.addPermission(string3);
                    break block17;
                }
                File file4 = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                if (file4 == null) break block17;
                if (uRL != null) {
                    file = new File(file4, "WEB-INF/lib/");
                    string = null;
                    try {
                        string = file.getCanonicalPath() + File.separator;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.classLoader.addPermission(string);
                }
                if (uRL2 == null) break block17;
                file = new File(file4, "WEB-INF/classes/");
                string = null;
                try {
                    string = file.getCanonicalPath() + File.separator;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.classLoader.addPermission(string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    private void setRepositories() {
        block20: {
            Object object;
            Object object2;
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            if (servletContext == null) {
                return;
            }
            File file = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (file == null) {
                return;
            }
            this.log(sm.getString("webappLoader.deploy", file.getAbsolutePath()));
            DirContext dirContext = this.container.getResources();
            String string = "/WEB-INF/classes";
            DirContext dirContext2 = null;
            try {
                object2 = dirContext.lookup(string);
                if (object2 instanceof DirContext) {
                    dirContext2 = (DirContext)object2;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (dirContext2 != null) {
                object2 = null;
                object = servletContext.getRealPath(string);
                if (object != null) {
                    object2 = new File((String)object);
                } else {
                    object2 = new File(file, string);
                    ((File)object2).mkdirs();
                    this.log(sm.getString("webappLoader.classDeploy", string, ((File)object2).getAbsolutePath()));
                    this.copyDir(dirContext2, (File)object2);
                }
                this.classLoader.addRepository(string + "/", (File)object2);
            }
            object2 = "/WEB-INF/lib";
            this.classLoader.setJarPath((String)object2);
            object = null;
            try {
                Object object3 = dirContext.lookup((String)object2);
                if (object3 instanceof DirContext) {
                    object = (DirContext)object3;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (object == null) break block20;
            boolean bl = false;
            String string2 = servletContext.getRealPath((String)object2);
            File file2 = null;
            if (string2 != null) {
                file2 = new File(string2);
            } else {
                bl = true;
                file2 = new File(file, (String)object2);
                file2.mkdirs();
            }
            try {
                NamingEnumeration<Binding> namingEnumeration = dirContext.listBindings((String)object2);
                while (namingEnumeration.hasMoreElements()) {
                    Binding binding = (Binding)namingEnumeration.nextElement();
                    String string3 = (String)object2 + "/" + binding.getName();
                    if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
                    File file3 = new File(file2, binding.getName());
                    this.log(sm.getString("webappLoader.jarDeploy", string3, file3.getAbsolutePath()));
                    Resource resource = (Resource)binding.getObject();
                    if (bl && !this.copy(resource.streamContent(), new FileOutputStream(file3))) continue;
                    try {
                        JarFile jarFile = new JarFile(file3);
                        this.classLoader.addJar(string3, jarFile, file3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (NamingException namingException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setClassPath() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ClassLoader classLoader = this.getClassLoader();
        int n = 0;
        int n2 = 0;
        while (n < 10 && classLoader != null) {
            URL[] uRLArray = null;
            if (classLoader instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)classLoader).getURLs();
            } else {
                if (!(classLoader instanceof JasperAdapter)) break;
                uRLArray = ((JasperAdapter)((Object)classLoader)).getURLs();
            }
            int n3 = 0;
            while (n3 < uRLArray.length) {
                block14: {
                    String string;
                    block12: {
                        block13: {
                            block11: {
                                string = uRLArray[n3].toString();
                                if (!string.startsWith("file://")) break block11;
                                string = string.substring(7);
                                break block12;
                            }
                            if (!string.startsWith("file:")) break block13;
                            string = string.substring(5);
                            break block12;
                        }
                        if (!string.startsWith("jndi:")) break block14;
                        string = servletContext.getRealPath(string.substring(5));
                    }
                    if (string != null) {
                        if (n2 > 0) {
                            stringBuffer.append(File.pathSeparator);
                        }
                        stringBuffer.append(string);
                        ++n2;
                    }
                }
                ++n3;
            }
            classLoader = classLoader.getParent();
            ++n;
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)stringBuffer.toString());
    }

    private boolean copyDir(DirContext dirContext, File file) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list("");
            while (namingEnumeration.hasMoreElements()) {
                Closeable closeable;
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                String string = nameClassPair.getName();
                Object object = dirContext.lookup(string);
                File file2 = new File(file, string);
                if (object instanceof Resource) {
                    FileOutputStream fileOutputStream;
                    closeable = ((Resource)object).streamContent();
                    if (this.copy((InputStream)closeable, fileOutputStream = new FileOutputStream(file2))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    closeable = new FileOutputStream(file2);
                    if (this.copy((InputStream)object, (OutputStream)closeable)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                file2.mkdir();
                this.copyDir((DirContext)object, file2);
            }
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean copy(InputStream inputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (!this.reloadable) {
            throw new IllegalStateException(sm.getString("webappLoader.notReloadable"));
        }
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException(sm.getString("webappLoader.notContext"));
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "WebappLoader[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    private void validatePackages() throws LifecycleException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader instanceof WebappClassLoader) {
            Extension[] extensionArray = ((WebappClassLoader)classLoader).findAvailable();
            Extension[] extensionArray2 = ((WebappClassLoader)classLoader).findRequired();
            if (this.debug >= 1) {
                this.log("Optional Packages:  available=" + extensionArray.length + ", required=" + extensionArray2.length);
            }
            int n = 0;
            while (n < extensionArray2.length) {
                if (this.debug >= 1) {
                    this.log("Checking for required package " + extensionArray2[n]);
                }
                boolean bl = false;
                int n2 = 0;
                while (n2 < extensionArray.length) {
                    if (extensionArray[n2].isCompatibleWith(extensionArray2[n])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    throw new LifecycleException("Missing optional package " + extensionArray2[n]);
                }
                ++n;
            }
        }
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        while (!this.threadDone) {
            block6: {
                this.threadSleep();
                if (!this.started) break;
                try {
                    if (!this.classLoader.modified()) {
                    }
                    break block6;
                }
                catch (Exception exception) {
                    this.log(sm.getString("webappLoader.failModifiedCheck"), exception);
                }
                continue;
            }
            if (!this.started) break;
            this.notifyContext();
            break;
        }
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }
}

