/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Extension {
    private String extensionName = null;
    private String implementationURL = null;
    private String implementationVendor = null;
    private String implementationVendorId = null;
    private String implementationVersion = null;
    private String specificationVendor = null;
    private String specificationVersion = null;

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String string) {
        this.extensionName = string;
    }

    public String getImplementationURL() {
        return this.implementationURL;
    }

    public void setImplementationURL(String string) {
        this.implementationURL = string;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public void setImplementationVendor(String string) {
        this.implementationVendor = string;
    }

    public String getImplementationVendorId() {
        return this.implementationVendorId;
    }

    public void setImplementationVendorId(String string) {
        this.implementationVendorId = string;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public void setImplementationVersion(String string) {
        this.implementationVersion = string;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public void setSpecificationVendor(String string) {
        this.specificationVendor = string;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public void setSpecificationVersion(String string) {
        this.specificationVersion = string;
    }

    public boolean isCompatibleWith(Extension extension) {
        if (this.extensionName == null) {
            return false;
        }
        if (!this.extensionName.equals(extension.getExtensionName())) {
            return false;
        }
        if (!this.isNewer(this.specificationVersion, extension.getSpecificationVersion())) {
            return false;
        }
        if (this.implementationVendorId == null) {
            return false;
        }
        if (!this.implementationVendorId.equals(extension.getImplementationVendorId())) {
            return false;
        }
        return this.isNewer(this.implementationVersion, extension.getImplementationVersion());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Extension[");
        stringBuffer.append(this.extensionName);
        if (this.implementationURL != null) {
            stringBuffer.append(", implementationURL=");
            stringBuffer.append(this.implementationURL);
        }
        if (this.implementationVendor != null) {
            stringBuffer.append(", implementationVendor=");
            stringBuffer.append(this.implementationVendor);
        }
        if (this.implementationVendorId != null) {
            stringBuffer.append(", implementationVendorId=");
            stringBuffer.append(this.implementationVendorId);
        }
        if (this.implementationVersion != null) {
            stringBuffer.append(", implementationVersion=");
            stringBuffer.append(this.implementationVersion);
        }
        if (this.specificationVendor != null) {
            stringBuffer.append(", specificationVendor=");
            stringBuffer.append(this.specificationVendor);
        }
        if (this.specificationVersion != null) {
            stringBuffer.append(", specificationVersion=");
            stringBuffer.append(this.specificationVersion);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static List getAvailable(Manifest manifest) {
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        if (manifest == null) {
            return arrayList;
        }
        Extension extension = null;
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && (extension = Extension.getAvailable(attributes)) != null) {
            arrayList.add(extension);
        }
        Map<String, Attributes> map = manifest.getEntries();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            attributes = map.get(string);
            extension = Extension.getAvailable(attributes);
            if (extension == null) continue;
            arrayList.add(extension);
        }
        return arrayList;
    }

    public static List getRequired(Manifest manifest) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null) {
            object = Extension.getRequired(attributes).iterator();
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        object = manifest.getEntries();
        Iterator iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            attributes = (Attributes)object.get(string);
            Iterator iterator2 = Extension.getRequired(attributes).iterator();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList;
    }

    private static Extension getAvailable(Attributes attributes) {
        String string = attributes.getValue("Extension-Name");
        if (string == null) {
            return null;
        }
        Extension extension = new Extension();
        extension.setExtensionName(string);
        extension.setImplementationVendor(attributes.getValue("Implementation-Vendor"));
        extension.setImplementationVendorId(attributes.getValue("Implementation-Vendor-Id"));
        extension.setImplementationVersion(attributes.getValue("Implementation-Version"));
        extension.setSpecificationVendor(attributes.getValue("Specification-Vendor"));
        extension.setSpecificationVersion(attributes.getValue("Specification-Version"));
        return extension;
    }

    private static List getRequired(Attributes attributes) {
        int n;
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        String string = attributes.getValue("Extension-List");
        if (string == null) {
            return arrayList;
        }
        string = string + " ";
        while ((n = string.indexOf(32)) >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1);
            String string3 = attributes.getValue(string2 + "-Extension-Name");
            if (string3 == null) continue;
            Extension extension = new Extension();
            extension.setExtensionName(string3);
            extension.setImplementationURL(attributes.getValue(string2 + "-Implementation-URL"));
            extension.setImplementationVendorId(attributes.getValue(string2 + "-Implementation-Vendor-Id"));
            extension.setImplementationVersion(attributes.getValue(string2 + "-Implementation-Version"));
            extension.setSpecificationVersion(attributes.getValue(string2 + "-Specification-Version"));
            arrayList.add(extension);
        }
        return arrayList;
    }

    private boolean isNewer(String string, String string2) throws NumberFormatException {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".", true);
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            if (n < (n2 = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0)) {
                return false;
            }
            if (n > n2) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return true;
    }
}

