/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import org.apache.catalina.deploy.SecurityCollection;

public final class SecurityConstraint {
    private boolean allRoles = false;
    private boolean authConstraint = false;
    private String[] authRoles = new String[0];
    private SecurityCollection[] collections = new SecurityCollection[0];
    private String displayName = null;
    private String userConstraint = "NONE";

    public boolean getAllRoles() {
        return this.allRoles;
    }

    public boolean getAuthConstraint() {
        return this.authConstraint;
    }

    public void setAuthConstraint(boolean bl) {
        this.authConstraint = bl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getUserConstraint() {
        return this.userConstraint;
    }

    public void setUserConstraint(String string) {
        if (string != null) {
            this.userConstraint = string;
        }
    }

    public void addAuthRole(String string) {
        if (string == null) {
            return;
        }
        if ("*".equals(string)) {
            this.allRoles = true;
            return;
        }
        String[] stringArray = new String[this.authRoles.length + 1];
        int n = 0;
        while (n < this.authRoles.length) {
            stringArray[n] = this.authRoles[n];
            ++n;
        }
        stringArray[this.authRoles.length] = string;
        this.authRoles = stringArray;
        this.authConstraint = true;
    }

    public void addCollection(SecurityCollection securityCollection) {
        if (securityCollection == null) {
            return;
        }
        SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length + 1];
        int n = 0;
        while (n < this.collections.length) {
            securityCollectionArray[n] = this.collections[n];
            ++n;
        }
        securityCollectionArray[this.collections.length] = securityCollection;
        this.collections = securityCollectionArray;
    }

    public boolean findAuthRole(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < this.authRoles.length) {
            if (string.equals(this.authRoles[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] findAuthRoles() {
        return this.authRoles;
    }

    public SecurityCollection findCollection(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.collections.length) {
            if (string.equals(this.collections[n].getName())) {
                return this.collections[n];
            }
            ++n;
        }
        return null;
    }

    public SecurityCollection[] findCollections() {
        return this.collections;
    }

    public boolean included(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        int n = 0;
        while (n < this.collections.length) {
            if (this.collections[n].findMethod(string2)) {
                String[] stringArray = this.collections[n].findPatterns();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (this.matchPattern(string, stringArray[n2])) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    public void removeAuthRole(String string) {
        if (string == null) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.authRoles.length) {
            if (this.authRoles[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            int n3 = 0;
            String[] stringArray = new String[this.authRoles.length - 1];
            int n4 = 0;
            while (n4 < this.authRoles.length) {
                if (n4 != n) {
                    stringArray[n3++] = this.authRoles[n4];
                }
                ++n4;
            }
            this.authRoles = stringArray;
        }
    }

    public void removeCollection(SecurityCollection securityCollection) {
        if (securityCollection == null) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.collections.length) {
            if (this.collections[n2].equals(securityCollection)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            int n3 = 0;
            SecurityCollection[] securityCollectionArray = new SecurityCollection[this.collections.length - 1];
            int n4 = 0;
            while (n4 < this.collections.length) {
                if (n4 != n) {
                    securityCollectionArray[n3++] = this.collections[n4];
                }
                ++n4;
            }
            this.collections = securityCollectionArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SecurityConstraint[");
        int n = 0;
        while (n < this.collections.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.collections[n].getName());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean matchPattern(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            if ((string2 = string2.substring(0, string2.length() - 2)).length() == 0) {
                return true;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            while (true) {
                if (string2.equals(string)) {
                    return true;
                }
                int n = string.lastIndexOf(47);
                if (n <= 0) break;
                string = string.substring(0, n);
            }
            return false;
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return n >= 0 && n2 > n && string.endsWith(string2.substring(1));
        }
        return string2.equals("/");
    }
}

