/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardService
implements Lifecycle,
Service {
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        Container container2 = this.container;
        if (container2 != null && container2 instanceof Engine) {
            ((Engine)container2).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            block11: {
                int n = 0;
                while (n < this.connectors.length) {
                    this.connectors[n].setContainer(this.container);
                    ++n;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (!this.started || container2 == null || !(container2 instanceof Lifecycle)) break block11;
                try {
                    ((Lifecycle)((Object)container2)).stop();
                }
                catch (LifecycleException lifecycleException) {}
            }
            return;
        }
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] connectorArray2 = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, connectorArray2, 0, this.connectors.length);
            connectorArray2[this.connectors.length] = connector;
            this.connectors = connectorArray2;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException lifecycleException) {
                    lifecycleException.printStackTrace(System.err);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.connectors.length) {
                if (connector == this.connectors[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.started && this.connectors[n] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[n])).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.connectors[n].setContainer(null);
            connector.setService(null);
            int n3 = 0;
            Connector[] connectorArray2 = new Connector[this.connectors.length - 1];
            int n4 = 0;
            while (n4 < this.connectors.length) {
                if (n4 != n) {
                    connectorArray2[n3++] = this.connectors[n4];
                }
                ++n4;
            }
            this.connectors = connectorArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardService[");
        stringBuffer.append(this.getName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardService.start.started"));
        }
        System.out.println(sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Container container = this.container;
        synchronized (container) {
            if (this.container != null && this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int n = 0;
            while (n < this.connectors.length) {
                if (this.connectors[n] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[n])).start();
                }
                ++n;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardService.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        System.out.println(sm.getString("standardService.stop.name", this.name));
        this.started = false;
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int n = 0;
            while (n < this.connectors.length) {
                if (this.connectors[n] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[n])).stop();
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Container container = this.container;
            synchronized (container) {
                if (this.container != null && this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).stop();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardService.initialize.initialized"));
        }
        this.initialized = true;
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int n = 0;
            while (n < this.connectors.length) {
                this.connectors[n].initialize();
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

