/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Random;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardServer
implements Lifecycle,
Server {
    private static final String info = "org.apache.catalina.core.StandardServer/1.0";
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int port = 8005;
    private Random random = null;
    private Service[] services = new Service[0];
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private boolean started = false;
    private boolean initialized = false;

    public StandardServer() {
        ServerFactory.setServer(this);
    }

    public String getInfo() {
        return info;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(String string) {
        this.shutdown = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            Service[] serviceArray2 = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, serviceArray2, 0, this.services.length);
            serviceArray2[this.services.length] = service;
            this.services = serviceArray2;
            if (this.initialized) {
                try {
                    service.initialize();
                }
                catch (LifecycleException lifecycleException) {
                    lifecycleException.printStackTrace(System.err);
                }
            }
            if (this.started && service instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)service)).start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void await() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException iOException) {
            System.err.println("StandardServer.await: create[" + this.port + "]: " + iOException);
            iOException.printStackTrace();
            System.exit(1);
        }
        while (true) {
            int n;
            Socket socket = null;
            InputStream inputStream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                inputStream = socket.getInputStream();
            }
            catch (AccessControlException accessControlException) {
                System.err.println("StandardServer.accept security exception: " + accessControlException.getMessage());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("StandardServer.await: accept: " + iOException);
                iOException.printStackTrace();
                System.exit(1);
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 1024;
            while (n2 < this.shutdown.length()) {
                if (this.random == null) {
                    this.random = new Random(System.currentTimeMillis());
                }
                n2 += this.random.nextInt() % 1024;
            }
            while (n2 > 0) {
                n = -1;
                try {
                    n = inputStream.read();
                }
                catch (IOException iOException) {
                    System.err.println("StandardServer.await: read: " + iOException);
                    iOException.printStackTrace();
                    n = -1;
                }
                if (n < 32) break;
                stringBuffer.append((char)n);
                --n2;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            n = stringBuffer.toString().equals(this.shutdown) ? 1 : 0;
            if (n != 0) break;
            System.err.println("StandardServer.await: Invalid command '" + stringBuffer.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {}
    }

    public Service[] findServices() {
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(Service service) {
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int n = -1;
            int n2 = 0;
            while (n2 < this.services.length) {
                if (service == this.services[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.services[n] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.services[n])).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            int n3 = 0;
            Service[] serviceArray2 = new Service[this.services.length - 1];
            int n4 = 0;
            while (n4 < this.services.length) {
                if (n4 != n) {
                    serviceArray2[n3++] = this.services[n4];
                }
                ++n4;
            }
            this.services = serviceArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StandardServer[");
        stringBuffer.append(this.getPort());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean isSameAddress(InetAddress inetAddress, InetAddress inetAddress2) {
        byte[] byArray;
        byte[] byArray2 = inetAddress.getAddress();
        if (byArray2.length != (byArray = inetAddress2.getAddress()).length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            if (byArray2[n2] != byArray[byArray2.length - 1 - n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardServer.start.started"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        Service[] serviceArray = this.services;
        synchronized (this.services) {
            int n = 0;
            while (n < this.services.length) {
                if (this.services[n] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.services[n])).start();
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardServer.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int n = 0;
        while (n < this.services.length) {
            if (this.services[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.services[n])).stop();
            }
            ++n;
        }
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardServer.initialize.initialized"));
        }
        this.initialized = true;
        int n = 0;
        while (n < this.services.length) {
            this.services[n].initialize();
            ++n;
        }
    }
}

