/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.HttpRequestFacade;
import org.apache.catalina.connector.RequestBase;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;

public class HttpRequestBase
extends RequestBase
implements HttpRequest,
HttpServletRequest {
    protected String authType = null;
    protected String contextPath = "";
    protected ArrayList cookies = new ArrayList();
    protected static ArrayList empty = new ArrayList();
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected HttpRequestFacade facade = new HttpRequestFacade(this);
    protected HashMap headers = new HashMap();
    protected static final String info = "org.apache.catalina.connector.HttpRequestBase/1.0";
    protected String method = null;
    protected ParameterMap parameters = null;
    protected boolean parsed = false;
    protected String pathInfo = null;
    protected String queryString = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected String requestURI = null;
    protected boolean secure = false;
    protected String servletPath = null;
    protected Session session = null;
    protected Principal userPrincipal = null;
    private boolean crossContext = false;
    private String crossContextSessionId = null;
    private Context origContext = null;
    private HashMap sessions = null;

    public String getInfo() {
        return info;
    }

    public ServletRequest getRequest() {
        return this.facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String string, String string2) {
        string = string.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList<String> arrayList = (ArrayList<String>)this.headers.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.headers.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String string, String[] stringArray) {
        ParameterMap parameterMap = this.parameters;
        synchronized (parameterMap) {
            this.parameters.put(string, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.clear();
        }
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
        if (this.parameters != null) {
            this.parameters.setLocked(false);
            this.parameters.clear();
        } else {
            this.parameters = new ParameterMap();
        }
    }

    public void recycle() {
        super.recycle();
        this.authType = null;
        this.contextPath = "";
        this.cookies.clear();
        this.headers.clear();
        this.method = null;
        if (this.parameters != null) {
            this.parameters.setLocked(false);
            this.parameters.clear();
        }
        this.parsed = false;
        this.pathInfo = null;
        this.queryString = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.requestURI = null;
        this.secure = false;
        this.servletPath = null;
        this.session = null;
        this.userPrincipal = null;
        this.crossContext = false;
        this.crossContextSessionId = null;
        this.origContext = null;
        if (this.sessions != null) {
            this.sessions.clear();
        }
    }

    public void setAuthType(String string) {
        this.authType = string;
    }

    public void setContextPath(String string) {
        this.contextPath = string == null ? "" : string;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setPathInfo(String string) {
        this.pathInfo = string;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void setRequestedSessionCookie(boolean bl) {
        this.requestedSessionCookie = bl;
    }

    public void setRequestedSessionId(String string) {
        this.requestedSessionId = string;
    }

    public void setRequestedSessionURL(boolean bl) {
        this.requestedSessionURL = bl;
    }

    public void setRequestURI(String string) {
        this.requestURI = string;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setServletPath(String string) {
        this.servletPath = string;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    protected void parseParameters() {
        int n;
        if (this.parsed) {
            return;
        }
        ParameterMap parameterMap = this.parameters;
        if (parameterMap == null) {
            parameterMap = new ParameterMap();
        }
        parameterMap.setLocked(false);
        String string = this.getCharacterEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        String string2 = this.getQueryString();
        try {
            RequestUtil.parseParameters((Map)parameterMap, string2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string3 = this.getContentType();
        if (string3 == null) {
            string3 = "";
        }
        string3 = (n = string3.indexOf(59)) >= 0 ? string3.substring(0, n).trim() : string3.trim();
        if ("POST".equals(this.getMethod()) && this.getContentLength() > 0 && this.stream == null && "application/x-www-form-urlencoded".equals(string3)) {
            try {
                int n2 = this.getContentLength();
                int n3 = 0;
                byte[] byArray = new byte[this.getContentLength()];
                ServletInputStream servletInputStream = this.getInputStream();
                while (n3 < n2) {
                    int n4 = servletInputStream.read(byArray, n3, n2 - n3);
                    if (n4 < 0) break;
                    n3 += n4;
                }
                servletInputStream.close();
                if (n3 < n2) {
                    throw new RuntimeException(RequestBase.sm.getString("httpRequestBase.contentLengthMismatch"));
                }
                RequestUtil.parseParameters((Map)parameterMap, byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                throw new RuntimeException(RequestBase.sm.getString("httpRequestBase.contentReadFail") + iOException.getMessage());
            }
        }
        parameterMap.setLocked(true);
        this.parsed = true;
        this.parameters = parameterMap;
    }

    public String getParameter(String string) {
        this.parseParameters();
        String[] stringArray = (String[])this.parameters.get(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public Map getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        this.parseParameters();
        return new Enumerator(new ArrayList(this.parameters.keySet()));
    }

    public String[] getParameterValues(String string) {
        this.parseParameters();
        String[] stringArray = (String[])this.parameters.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (this.context == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(string);
        }
        String string2 = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (string2 == null) {
            string2 = this.getServletPath();
        }
        int n = string2.lastIndexOf(47);
        String string3 = null;
        string3 = n >= 0 ? RequestUtil.normalize(string2.substring(0, n + 1) + string) : RequestUtil.normalize(string2 + string);
        return this.context.getServletContext().getRequestDispatcher(string3);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookies() {
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            if (this.cookies.size() < 1) {
                return null;
            }
            Cookie[] cookieArray = new Cookie[this.cookies.size()];
            return this.cookies.toArray(cookieArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1L;
        }
        string2 = string2 + " ";
        int n = 0;
        while (n < formats.length) {
            try {
                Date date = null;
                SimpleDateFormat simpleDateFormat = formats[n];
                synchronized (simpleDateFormat) {
                    date = formats[n].parse(string2);
                }
                return date.getTime();
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        throw new IllegalArgumentException(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeader(String string) {
        string = string.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.headers.get(string);
            if (arrayList != null) {
                return (String)arrayList.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getHeaders(String string) {
        string = string.toLowerCase();
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)this.headers.get(string);
            if (arrayList != null) {
                return new Enumerator(arrayList);
            }
            return new Enumerator(empty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getHeaderNames() {
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            return new Enumerator(new ArrayList(this.headers.keySet()));
        }
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.pathInfo);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getScheme();
        int n = this.getServerPort();
        if (n < 0) {
            n = 80;
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Context changeContext(Context context) {
        Context context2 = this.getContext();
        if (this.origContext == null) {
            this.origContext = context2;
        }
        if (context != context2) {
            if (this.sessions == null) {
                this.sessions = new HashMap();
            }
            this.crossContext = context != this.origContext;
            this.sessions.put(context2, this.session);
            if (context2 == this.origContext) {
                if (this.session != null) {
                    this.crossContextSessionId = this.session.getId();
                } else if (this.isRequestedSessionIdValid()) {
                    this.crossContextSessionId = this.requestedSessionId;
                }
            }
            this.session = (Session)this.sessions.get(context);
            this.setContext(context);
        }
        return context2;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetSession privilegedGetSession = new PrivilegedGetSession(bl);
            return (HttpSession)AccessController.doPrivileged(privilegedGetSession);
        }
        return this.doGetSession(bl);
    }

    private HttpSession doGetSession(boolean bl) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException iOException) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                return this.session.getSession();
            }
        }
        if (!bl) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(RequestBase.sm.getString("httpRequestBase.createCommitted"));
        }
        this.session = manager.createSession();
        if (this.crossContext && this.session != null) {
            if (this.crossContextSessionId != null) {
                this.session.setId(this.crossContextSessionId);
            }
        } else if (this.context.getReuseSessionID() && this.requestedSessionId != null) {
            this.session.setId(this.requestedSessionId);
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException iOException) {
            session = null;
        }
        return session != null && session.isValid();
    }

    public boolean isUserInRole(String string) {
        String string2;
        if (this.userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (string2 = this.wrapper.findSecurityReference(string)) != null && realm.hasRole(this.userPrincipal, string2)) {
            return true;
        }
        return realm.hasRole(this.userPrincipal, string);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    protected class PrivilegedGetSession
    implements PrivilegedAction {
        private boolean create;

        PrivilegedGetSession(boolean bl) {
            this.create = bl;
        }

        public Object run() {
            return HttpRequestBase.this.doGetSession(this.create);
        }
    }
}

