/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ClusterSessionBase;
import org.apache.catalina.cluster.ReplicationWrapper;

public class MulticastSender
extends ClusterSessionBase
implements ClusterSender {
    private static String senderId = null;
    private String senderName = "MulticastSender";
    private MulticastSocket multicastSocket = null;
    private InetAddress multicastAddress = null;
    private int multicastPort;

    MulticastSender(String string, MulticastSocket multicastSocket, InetAddress inetAddress, int n) {
        this.multicastAddress = inetAddress;
        this.multicastPort = n;
        this.multicastSocket = multicastSocket;
        senderId = string;
    }

    public String getName() {
        return this.senderName;
    }

    public void send(Object object) {
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.send(byArray);
        }
        catch (IOException iOException) {
            this.log(this.sm.getString("multicastSender.sendException", iOException.toString()));
        }
    }

    public void send(byte[] byArray) {
        ReplicationWrapper replicationWrapper = new ReplicationWrapper(byArray, senderId);
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            objectOutputStream.writeObject(replicationWrapper);
            objectOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            int n = byArray2.length;
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, n, this.multicastAddress, this.multicastPort);
            this.send(datagramPacket);
        }
        catch (IOException iOException) {
            this.log(this.sm.getString("multicastSender.sendException", iOException.toString()));
        }
    }

    private synchronized void send(DatagramPacket datagramPacket) {
        try {
            this.multicastSocket.send(datagramPacket);
        }
        catch (IOException iOException) {
            this.log(this.sm.getString("multicastSender.sendException", iOException.toString()));
        }
    }
}

