/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebPrincipal;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.realm.RealmBase;
import sun.security.x509.X500Name;

public class RealmAdapter
extends RealmBase {
    static Logger _logger;
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    public static final String CERT = "certificate";
    private static final boolean debug = false;
    private static int MAX_COUNT;
    private static int SLEEP_TIME;
    private RoleMapper mapper = null;
    private WebBundleDescriptor webDesc = null;
    private HashMap runAsPrincipals = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$web$security$RealmAdapter;
    static /* synthetic */ Class class$sun$security$x509$X500Name;

    public RealmAdapter(WebBundleDescriptor webBundleDescriptor) {
        this.webDesc = webBundleDescriptor;
        this.mapper = webBundleDescriptor.getApplication().getRoleMapper();
        LoginConfiguration loginConfiguration = webBundleDescriptor.getLoginConfiguration();
        this.runAsPrincipals = new HashMap();
        Iterator iterator = this.webDesc.getWebComponentDescriptorsSet().iterator();
        while (iterator.hasNext()) {
            WebComponentDescriptor webComponentDescriptor = (WebComponentDescriptor)iterator.next();
            RunAsIdentityDescriptor runAsIdentityDescriptor = webComponentDescriptor.getRunAsIdentity();
            if (runAsIdentityDescriptor == null) continue;
            String string = runAsIdentityDescriptor.getPrincipal();
            String string2 = webComponentDescriptor.getCanonicalName();
            if (string == null || string2 == null) {
                _logger.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(string2, string);
            _logger.fine("Servlet " + string2 + " will run-as: " + string);
        }
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    public boolean hasRole(Principal principal, String string) {
        return this.mapper.hasRole(principal, string);
    }

    public void logout() {
        this.setSecurityContext(null);
    }

    public Principal authenticate(String string, byte[] byArray) {
        return this.authenticate(string, new String(byArray));
    }

    public Principal authenticate(String string, String string2) {
        if (this.authenticate(string, string2, null)) {
            SecurityContext securityContext = SecurityContext.getCurrent();
            if (!$assertionsDisabled && securityContext == null) {
                throw new AssertionError();
            }
            return new WebPrincipal(string, string2, securityContext);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] x509CertificateArray) {
        if (this.authenticate(null, null, x509CertificateArray)) {
            SecurityContext securityContext = SecurityContext.getCurrent();
            if (!$assertionsDisabled && securityContext == null) {
                throw new AssertionError();
            }
            return new WebPrincipal(x509CertificateArray, securityContext);
        }
        return null;
    }

    protected boolean authenticate(String string, String string2, X509Certificate[] x509CertificateArray) {
        SecurityContext.setCurrent(null);
        try {
            if (x509CertificateArray != null) {
                Subject subject = new Subject();
                X509Certificate x509Certificate = x509CertificateArray[0];
                X500Name x500Name = (X500Name)x509Certificate.getSubjectDN();
                subject.getPublicCredentials().add(x500Name);
                LoginContextDriver.login(subject, class$sun$security$x509$X500Name == null ? (class$sun$security$x509$X500Name = RealmAdapter.class$("sun.security.x509.X500Name")) : class$sun$security$x509$X500Name);
            } else {
                LoginContextDriver.login(string, string2);
            }
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Web login failed: " + exception.getMessage());
            }
            return false;
        }
        return true;
    }

    public void preSetRunAsIdentity(ComponentInvocation componentInvocation) {
        String string = this.getServletName(componentInvocation);
        if (string == null) {
            return;
        }
        String string2 = (String)this.runAsPrincipals.get(string);
        if (string2 != null) {
            SecurityContext securityContext = this.getSecurityContext();
            componentInvocation.setOldSecurityContext(securityContext);
            this.loginForRunAs(string2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("run-as principal for " + string + " set to: " + string2);
            }
        }
    }

    private String getServletName(ComponentInvocation componentInvocation) {
        HttpServlet httpServlet;
        ServletConfig servletConfig;
        Object object = componentInvocation.getInstance();
        if (object instanceof HttpServlet && (servletConfig = (httpServlet = (HttpServlet)object).getServletConfig()) != null) {
            return httpServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation componentInvocation) {
        String string = this.getServletName(componentInvocation);
        if (string == null) {
            return;
        }
        String string2 = (String)this.runAsPrincipals.get(string);
        if (string2 != null) {
            this.setSecurityContext(componentInvocation.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String string) {
        LoginContextDriver.loginPrincipal(string);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext securityContext) {
        SecurityContext.setCurrent(securityContext);
    }

    protected String getPassword(String string) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String string) {
        throw new IllegalStateException("Should not reach here");
    }

    protected String getName() {
        return name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$web$security$RealmAdapter == null ? (class$com$sun$web$security$RealmAdapter = RealmAdapter.class$("com.sun.web.security.RealmAdapter")) : class$com$sun$web$security$RealmAdapter).desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        MAX_COUNT = 5;
        SLEEP_TIME = 5000;
    }
}

