/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.iplanet.ias.loader.EJBClassLoader;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.Vector;

public class WebTestsUtil
implements VerifierEventsListener {
    protected final String listenerClassPath = "WEB-INF/classes";
    protected final String libraryClassPath = "WEB-INF/lib";
    private final String separator = System.getProperty("file.separator");
    private static File warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
    private static WebTestsUtil util = null;
    private static ClassLoader cl = null;
    public LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public static WebTestsUtil getUtil() {
        if (util == null) {
            util = new WebTestsUtil();
            WebCheckMgrImpl.addVerifierEventsListener(util);
        }
        return util;
    }

    public File extractJarFile(File file) throws IOException {
        warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
        Archivist.extractJarFile(file, warFile);
        return warFile;
    }

    private void deleteDirectory(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    fileArray[n].delete();
                } else {
                    String string2 = file + this.separator + fileArray[n].getName();
                    File file2 = new File(string2);
                    this.deleteDirectory(file2.getAbsolutePath());
                }
                ++n;
            }
        }
        file.delete();
    }

    public void testFinished(EventObject eventObject) {
    }

    public void allTestsFinished(EventObject eventObject) {
        if (warFile.exists()) {
            this.deleteDirectory(warFile.getAbsolutePath());
        }
        warFile = null;
        util = null;
        cl = null;
        WebCheckMgrImpl.removeVerifierEventsListener(this);
    }

    private ClassLoader getClassLoader() {
        int n;
        Serializable[] serializableArray;
        if (cl != null) {
            return cl;
        }
        File file = new File(warFile, "WEB-INF/classes");
        File file2 = new File(warFile, "WEB-INF/lib");
        Vector<Serializable> vector = new Vector<Serializable>();
        if (file2.exists()) {
            serializableArray = file2.listFiles();
            n = 0;
            while (n < serializableArray.length) {
                if (((File)serializableArray[n]).getName().endsWith(".jar")) {
                    vector.add(serializableArray[n]);
                }
                ++n;
            }
        }
        serializableArray = new URL[vector.size() + 1];
        try {
            serializableArray[0] = file.toURL();
            n = 1;
            while (n <= vector.size()) {
                serializableArray[n] = ((File)vector.elementAt(n - 1)).toURL();
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Verifier.debug(malformedURLException);
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".MalformedURLException", "Unexpected Exception occured :" + malformedURLException.getMessage(), new Object[]{malformedURLException.getMessage()}));
        }
        cl = new EJBClassLoader();
        int n2 = 0;
        while (n2 < serializableArray.length) {
            ((EJBClassLoader)cl).appendURL((URL)serializableArray[n2]);
            ++n2;
        }
        return cl;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (warFile == null || !warFile.exists()) {
            throw new ClassNotFoundException();
        }
        return this.getClassLoader().loadClass(string);
    }
}

