/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultMgr;
import com.sun.enterprise.tools.verifier.ResultsRecord;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.app.AppCheckMgrImpl;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.tools.verifier.connector.ConnectorCheckMgrImpl;
import com.sun.enterprise.tools.verifier.ejb.EjbCheckMgrImpl;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultsReport {
    private JFrame frame = null;
    private int errorCount = 0;
    private int failedCount = 0;
    private int warningCount = 0;
    private ResultMgr resultMgr;
    private Document document = null;
    private Element rootNode = null;
    private boolean userSpecifiedOutputFile = false;
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private static boolean fileNotFoundException = false;
    private static final String TMPFILENAME = "verifier-tmp";
    private static final String FAILCOUNT = "failure-count";
    private static final String FAILNUMBER = "failure-number";
    private static final String WARNINGNUMBER = "warning-number";
    private static final String ERRORNUMBER = "error-number";
    private static final String WEB = "web";
    private static final String APPLICATION = "application";
    private static final String APPCLIENT = "appclient";
    private static final String EJB = "ejb";
    private static final String CONNECTOR = "connector";
    private static final String OTHER = "other";
    private static final String FAILED = "failed";
    private static final String PASSED = "passed";
    private static final String NOTAPPLICABLE = "not-applicable";
    private static final String WARNING = "warning";
    private static final String STATIC_VER = "static-verification";
    private static final String TEST = "test";
    private static final String TEST_NAME = "test-name";
    private static final String TEST_DESC = "test-description";
    private static final String TEST_ASSERTION = "test-assertion";
    private static final String ERROR = "error";
    private static final String ERROR_NAME = "error-name";
    private static final String ERROR_DESC = "error-description";
    private static final String PUBLICID = "-//Sun Microsystems, Inc.//DTD J2EE Static Verification 1.3.1//EN";
    private static final String SYSTEMID = "static-verification_1_3_1.dtd";
    private static final String XSL_DIR = "xsl";
    private static final String XSL_FILE = "textFormatForVerifierSS.xsl";
    private File TMP_DIR = null;
    private String timestamp = null;

    public ResultsReport() {
        Calendar calendar = Calendar.getInstance();
        this.timestamp = new Integer(calendar.get(11)).toString() + new Integer(calendar.get(12)).toString() + new Integer(calendar.get(14)).toString();
    }

    public File getTmpDir() {
        return this.TMP_DIR;
    }

    public void setTmpDir(File file) {
        this.TMP_DIR = file;
    }

    public boolean getUserSpecifiedOutputFile() {
        return this.userSpecifiedOutputFile;
    }

    public void setUserSpecifiedOutputFile(boolean bl) {
        this.userSpecifiedOutputFile = bl;
    }

    private File extractResultsFileToTmpDir(String string) {
        File file = null;
        try {
            if (!this.getUserSpecifiedOutputFile()) {
                file = new File(System.getProperty("java.io.tmpdir"));
                String string2 = (file = new File(file, string)).getAbsolutePath();
                if (new File(string2).getParent() != null) {
                    new File(new File(string2).getParent()).mkdirs();
                }
            } else {
                file = new File(string);
                String string3 = file.getAbsolutePath();
                if (new File(string3).getParent() != null) {
                    new File(new File(string3).getParent()).mkdirs();
                }
            }
        }
        catch (Exception exception) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(exception)}));
            this.writeToFile();
            this.debug(exception);
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException", "Cannot find output file, no such file or directory: {0} - {1}", new Object[]{string, exception.getMessage()}));
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{string}));
            return null;
        }
        return file;
    }

    public void setResultMgr(ResultMgr resultMgr) {
        this.resultMgr = resultMgr;
    }

    public boolean writeDetailsToText() throws TransformerConfigurationException, TransformerException {
        File file = null;
        File file2 = null;
        try {
            Object object;
            String string = System.getProperty("com.sun.aas.verifier.xsl");
            if (string == null) {
                object = System.getProperty("com.sun.aas.installRoot");
                if (string != null) {
                    string = (String)object + File.separator + "lib" + File.separator + "verifier";
                }
            }
            if (string == null) {
                string = System.getProperty("j2ee.appverification.home");
                if (string == null) {
                    string = System.getProperty("com.sun.enterprise.home");
                }
                string = string + "/" + XSL_DIR;
            }
            file = !this.getUserSpecifiedOutputFile() ? this.extractResultsFileToTmpDir(Verifier.outputFileStr + this.timestamp + ".txt") : this.extractResultsFileToTmpDir(Verifier.outputFileStr + ".txt");
            file2 = new File(string + File.separator + XSL_FILE);
            object = this.getDocument();
            this.generateText((Document)object, file2, file);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".LookInResultsTestAssertions", "Look in file \"{0}\" for detailed results on test assertions.", new Object[]{file.toString()}));
            return true;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerConfigurationException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerConfigurationException)}));
            this.writeToFile();
            return false;
        }
        catch (TransformerException transformerException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerException)}));
            this.writeToFile();
            return false;
        }
    }

    public void generateText(Document document, File file, File file2) throws TransformerConfigurationException, TransformerException {
        try {
            Transformer transformer;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (file != null) {
                StreamSource streamSource = new StreamSource(file);
                transformer = transformerFactory.newTransformer(streamSource);
            } else {
                transformer = transformerFactory.newTransformer();
            }
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file2);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerConfigurationException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerConfigurationException)}));
            this.writeToFile();
        }
        catch (TransformerException transformerException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerException)}));
            this.writeToFile();
        }
    }

    public void writeInvalidParseDetails(String string, String string2) {
        File file = null;
        Object var4_4 = null;
        if (Verifier.hasAlreadyWrittenInvalidParseDetails()) {
            return;
        }
        Verifier.log(string);
        Verifier.log(string2);
        try {
            file = !this.getUserSpecifiedOutputFile() ? this.extractResultsFileToTmpDir(Verifier.outputFileStr + this.timestamp + ".txt") : this.extractResultsFileToTmpDir(Verifier.outputFileStr + ".xml");
            Element element = null;
            NodeList nodeList = this.document.getElementsByTagName(ERROR);
            if (nodeList.getLength() == 0) {
                element = this.document.createElement(ERROR);
                this.rootNode.appendChild(element);
            } else {
                element = (Element)nodeList.item(0);
            }
            Element element2 = this.getTextNode(ERROR_NAME, string);
            Element element3 = this.getTextNode(ERROR_DESC, string2);
            element.appendChild(element2);
            element.appendChild(element3);
            ++this.errorCount;
        }
        catch (Exception exception) {
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}));
        }
        if (this.frame != null) {
            JOptionPane.showMessageDialog(this.frame, this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{string}));
        }
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    private Document newDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.debug(parserConfigurationException);
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{parserConfigurationException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(parserConfigurationException)}));
            this.writeToFile();
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{parserConfigurationException.toString()}));
        }
        this.document = documentBuilder.newDocument();
        return this.document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getTextNode(String string, String string2) {
        Element element = this.document.createElement(string);
        element.appendChild(this.document.createTextNode(string2));
        return element;
    }

    public void failureCount() {
        Element element = null;
        NodeList nodeList = this.document.getElementsByTagName(FAILCOUNT);
        if (nodeList.getLength() == 0) {
            element = this.document.createElement(FAILCOUNT);
            this.rootNode.appendChild(element);
        } else {
            element = (Element)nodeList.item(0);
        }
        nodeList = element.getChildNodes();
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        if (nodeList.getLength() == 0) {
            element2 = this.getTextNode(FAILNUMBER, new Integer(this.failedCount).toString());
            element.appendChild(element2);
            element3 = this.getTextNode(WARNINGNUMBER, new Integer(this.warningCount).toString());
            element.appendChild(element3);
            element4 = this.getTextNode(ERRORNUMBER, new Integer(this.errorCount).toString());
            element.appendChild(element4);
        } else {
            int n = 0;
            while (n < nodeList.getLength()) {
                if (((Element)nodeList.item(n)).getTagName().equals(FAILNUMBER)) {
                    element2 = (Element)nodeList.item(n);
                    element2.getFirstChild().setNodeValue(new Integer(this.failedCount).toString());
                }
                if (((Element)nodeList.item(n)).getTagName().equals(WARNINGNUMBER)) {
                    element3 = (Element)nodeList.item(n);
                    element3.getFirstChild().setNodeValue(new Integer(this.warningCount).toString());
                }
                if (((Element)nodeList.item(n)).getTagName().equals(ERRORNUMBER)) {
                    element4 = (Element)nodeList.item(n);
                    element4.getFirstChild().setNodeValue(new Integer(this.errorCount).toString());
                }
                ++n;
            }
            if (element2 == null) {
                element2 = this.getTextNode(FAILNUMBER, new Integer(this.failedCount).toString());
                element.appendChild(element2);
            }
            if (element3 == null) {
                element3 = this.getTextNode(WARNINGNUMBER, new Integer(this.warningCount).toString());
                element.appendChild(element3);
            }
            if (element4 == null) {
                element4 = this.getTextNode(ERRORNUMBER, new Integer(this.errorCount).toString());
                element.appendChild(element4);
            }
        }
    }

    private String getModule(JarCheck jarCheck) {
        if (jarCheck instanceof AppCheckMgrImpl) {
            return APPLICATION;
        }
        if (jarCheck instanceof AppClientCheckMgrImpl) {
            return APPCLIENT;
        }
        if (jarCheck instanceof EjbCheckMgrImpl) {
            return EJB;
        }
        if (jarCheck instanceof ConnectorCheckMgrImpl) {
            return CONNECTOR;
        }
        if (jarCheck instanceof WebCheckMgrImpl) {
            return WEB;
        }
        return null;
    }

    public void printAllFailedTestResults(Vector vector, JarCheck jarCheck) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (vector.size() == 0) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            object3 = (ResultsRecord)vector.elementAt(n2);
            object2 = ((ResultsRecord)object3).getFailedResults();
            object = ((Hashtable)object2).elements();
            if (object.hasMoreElements()) {
                bl = true;
            }
            while (object.hasMoreElements()) {
                object.nextElement();
                ++this.failedCount;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        object3 = "";
        object2 = null;
        object3 = this.getModule(jarCheck);
        if (object3 != null) {
            object = this.document.getElementsByTagName((String)object3);
            if (object.getLength() == 0) {
                object2 = this.document.createElement((String)object3);
                this.rootNode.appendChild((Node)object2);
            } else {
                object2 = (Element)object.item(0);
            }
        }
        object = object2.getChildNodes();
        Element element = null;
        if (object.getLength() == 0) {
            element = this.document.createElement(FAILED);
            object2.appendChild(element);
        } else {
            n = 0;
            while (n < object.getLength()) {
                if (((Element)object.item(n)).getTagName().equals(FAILED)) {
                    element = (Element)object.item(n);
                    break;
                }
                ++n;
            }
            if (element == null) {
                element = this.document.createElement(FAILED);
                object2.appendChild(element);
            }
        }
        n = 0;
        while (n < vector.size()) {
            ResultsRecord resultsRecord = (ResultsRecord)vector.elementAt(n);
            Hashtable hashtable = resultsRecord.getFailedResults();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Result result = (Result)enumeration.nextElement();
                if (result == null) continue;
                Element element2 = this.document.createElement(TEST);
                Element element3 = this.getTextNode(TEST_NAME, result.getTestName());
                Element element4 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                Enumeration enumeration2 = result.getErrorDetails().elements();
                String string = "";
                while (enumeration2.hasMoreElements()) {
                    string = string + (String)enumeration2.nextElement() + "\n";
                }
                Element element5 = this.getTextNode(TEST_DESC, string);
                element2.appendChild(element3);
                element2.appendChild(element4);
                element2.appendChild(element5);
                element.appendChild(element2);
            }
            ++n;
        }
    }

    public void printAllWarningTestResults(Vector vector, JarCheck jarCheck) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (vector.size() == 0) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            object3 = (ResultsRecord)vector.elementAt(n2);
            object2 = ((ResultsRecord)object3).getWarningResults();
            object = ((Hashtable)object2).elements();
            if (object.hasMoreElements()) {
                bl = true;
            }
            while (object.hasMoreElements()) {
                object.nextElement();
                ++this.warningCount;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        object3 = "";
        object2 = null;
        object3 = this.getModule(jarCheck);
        if (object3 != null) {
            object = this.document.getElementsByTagName((String)object3);
            if (object.getLength() == 0) {
                object2 = this.document.createElement((String)object3);
                this.rootNode.appendChild((Node)object2);
            } else {
                object2 = (Element)object.item(0);
            }
        }
        object = object2.getChildNodes();
        Element element = null;
        if (object.getLength() == 0) {
            element = this.document.createElement(WARNING);
            object2.appendChild(element);
        } else {
            n = 0;
            while (n < object.getLength()) {
                if (((Element)object.item(n)).getTagName().equals(WARNING)) {
                    element = (Element)object.item(n);
                    break;
                }
                ++n;
            }
            if (element == null) {
                element = this.document.createElement(WARNING);
                object2.appendChild(element);
            }
        }
        n = 0;
        while (n < vector.size()) {
            ResultsRecord resultsRecord = (ResultsRecord)vector.elementAt(n);
            Hashtable hashtable = resultsRecord.getWarningResults();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Result result = (Result)enumeration.nextElement();
                if (result == null) continue;
                Element element2 = this.document.createElement(TEST);
                Element element3 = this.getTextNode(TEST_NAME, result.getTestName());
                Element element4 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                Enumeration enumeration2 = result.getWarningDetails().elements();
                String string = "";
                while (enumeration2.hasMoreElements()) {
                    string = string + (String)enumeration2.nextElement() + "\n";
                }
                Element element5 = this.getTextNode(TEST_DESC, string);
                element2.appendChild(element3);
                element2.appendChild(element4);
                element2.appendChild(element5);
                element.appendChild(element2);
            }
            ++n;
        }
    }

    public void printAllPassedTestResults(Vector vector, JarCheck jarCheck) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (vector.size() == 0) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            object3 = (ResultsRecord)vector.elementAt(n2);
            object2 = ((ResultsRecord)object3).getPassedResults();
            object = ((Hashtable)object2).elements();
            if (object.hasMoreElements()) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        object3 = "";
        object2 = null;
        object3 = this.getModule(jarCheck);
        if (object3 != null) {
            object = this.document.getElementsByTagName((String)object3);
            if (object.getLength() == 0) {
                object2 = this.document.createElement((String)object3);
                this.rootNode.appendChild((Node)object2);
            } else {
                object2 = (Element)object.item(0);
            }
        }
        object = object2.getChildNodes();
        Element element = null;
        if (object.getLength() == 0) {
            element = this.document.createElement(PASSED);
            object2.appendChild(element);
        } else {
            n = 0;
            while (n < object.getLength()) {
                if (((Element)object.item(n)).getTagName().equals(PASSED)) {
                    element = (Element)object.item(n);
                    break;
                }
                ++n;
            }
            if (element == null) {
                element = this.document.createElement(PASSED);
                object2.appendChild(element);
            }
        }
        n = 0;
        while (n < vector.size()) {
            ResultsRecord resultsRecord = (ResultsRecord)vector.elementAt(n);
            Hashtable hashtable = resultsRecord.getPassedResults();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Result result = (Result)enumeration.nextElement();
                if (result == null) continue;
                Element element2 = this.document.createElement(TEST);
                Element element3 = this.getTextNode(TEST_NAME, result.getTestName());
                Element element4 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                Enumeration enumeration2 = result.getGoodDetails().elements();
                String string = "";
                while (enumeration2.hasMoreElements()) {
                    string = string + (String)enumeration2.nextElement() + "\n";
                }
                Element element5 = this.getTextNode(TEST_DESC, string);
                element2.appendChild(element3);
                element2.appendChild(element4);
                element2.appendChild(element5);
                element.appendChild(element2);
            }
            ++n;
        }
    }

    public void printAllNaTestResults(Vector vector, JarCheck jarCheck) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (vector.size() == 0) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            object3 = (ResultsRecord)vector.elementAt(n2);
            object2 = ((ResultsRecord)object3).getPassedResults();
            object = ((Hashtable)object2).elements();
            if (object.hasMoreElements()) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        object3 = "";
        object2 = null;
        object3 = this.getModule(jarCheck);
        if (object3 != null) {
            object = this.document.getElementsByTagName((String)object3);
            if (object.getLength() == 0) {
                object2 = this.document.createElement((String)object3);
                this.rootNode.appendChild((Node)object2);
            } else {
                object2 = (Element)object.item(0);
            }
        }
        object = object2.getChildNodes();
        Element element = null;
        if (object.getLength() == 0) {
            element = this.document.createElement(NOTAPPLICABLE);
            object2.appendChild(element);
        } else {
            n = 0;
            while (n < object.getLength()) {
                if (((Element)object.item(n)).getTagName().equals(NOTAPPLICABLE)) {
                    element = (Element)object.item(n);
                    break;
                }
                ++n;
            }
            if (element == null) {
                element = this.document.createElement(NOTAPPLICABLE);
                object2.appendChild(element);
            }
        }
        n = 0;
        while (n < vector.size()) {
            ResultsRecord resultsRecord = (ResultsRecord)vector.elementAt(n);
            Hashtable hashtable = resultsRecord.getNaResults();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Result result = (Result)enumeration.nextElement();
                if (result == null) continue;
                Element element2 = this.document.createElement(TEST);
                Element element3 = this.getTextNode(TEST_NAME, result.getTestName());
                Element element4 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                Enumeration enumeration2 = result.getNaDetails().elements();
                String string = "";
                while (enumeration2.hasMoreElements()) {
                    string = string + (String)enumeration2.nextElement() + "\n";
                }
                Element element5 = this.getTextNode(TEST_DESC, string);
                element2.appendChild(element3);
                element2.appendChild(element4);
                element2.appendChild(element5);
                element.appendChild(element2);
            }
            ++n;
        }
    }

    public void printAllResultsForOtherTests(ResultMgr resultMgr) {
        try {
            if (Verifier.getReportLevel() != 0) {
                this.printWarningResultsForOtherTests(resultMgr);
                if (Verifier.getReportLevel() == 2) {
                    this.printPassedResultsForOtherTests(resultMgr);
                    this.printNaResultsForOtherTests(resultMgr);
                }
            }
            this.printFailedResultsForOtherTests(resultMgr);
        }
        catch (IOException iOException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(iOException)}));
            this.writeToFile();
        }
    }

    public void printFailedResultsForOtherTests(ResultMgr resultMgr) throws IOException {
        Vector vector = resultMgr.getFailedResults();
        this.failedCount += vector.size();
        if (!vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                Element element = null;
                NodeList nodeList = this.document.getElementsByTagName(OTHER);
                if (nodeList.getLength() == 0) {
                    element = this.document.createElement(OTHER);
                    this.rootNode.appendChild(element);
                } else {
                    element = (Element)nodeList.item(0);
                }
                nodeList = element.getChildNodes();
                Element element2 = null;
                if (nodeList.getLength() == 0) {
                    element2 = this.document.createElement(FAILED);
                    element.appendChild(element2);
                } else {
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        if (((Element)nodeList.item(n2)).getTagName().equals(FAILED)) {
                            element2 = (Element)nodeList.item(n2);
                        }
                        ++n2;
                    }
                    if (element2 == null) {
                        element2 = this.document.createElement(FAILED);
                        element.appendChild(element2);
                    }
                }
                Result result = (Result)vector.elementAt(n);
                if (result != null) {
                    Element element3 = this.document.createElement(TEST);
                    Element element4 = this.getTextNode(TEST_NAME, result.getTestName());
                    Element element5 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                    Enumeration enumeration = result.getErrorDetails().elements();
                    String string = "";
                    while (enumeration.hasMoreElements()) {
                        string = string + (String)enumeration.nextElement() + "\n";
                    }
                    Element element6 = this.getTextNode(TEST_DESC, string);
                    element3.appendChild(element4);
                    element3.appendChild(element5);
                    element3.appendChild(element6);
                    element2.appendChild(element3);
                }
                ++n;
            }
        }
    }

    public void printPassedResultsForOtherTests(ResultMgr resultMgr) throws IOException {
        Vector vector = resultMgr.getPassedResults();
        if (!vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                Element element = null;
                NodeList nodeList = this.document.getElementsByTagName(OTHER);
                if (nodeList.getLength() == 0) {
                    element = this.document.createElement(OTHER);
                    this.rootNode.appendChild(element);
                } else {
                    element = (Element)nodeList.item(0);
                }
                nodeList = element.getChildNodes();
                Element element2 = null;
                if (nodeList.getLength() == 0) {
                    element2 = this.document.createElement(PASSED);
                    element.appendChild(element2);
                } else {
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        if (((Element)nodeList.item(n2)).getTagName().equals(PASSED)) {
                            element2 = (Element)nodeList.item(n2);
                            break;
                        }
                        ++n2;
                    }
                    if (element2 == null) {
                        element2 = this.document.createElement(PASSED);
                        element.appendChild(element2);
                    }
                }
                Result result = (Result)vector.elementAt(n);
                if (result != null) {
                    Element element3 = this.document.createElement(TEST);
                    Element element4 = this.getTextNode(TEST_NAME, result.getTestName());
                    Element element5 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                    Enumeration enumeration = result.getGoodDetails().elements();
                    String string = "";
                    while (enumeration.hasMoreElements()) {
                        string = string + (String)enumeration.nextElement() + "\n";
                    }
                    Element element6 = this.getTextNode(TEST_DESC, string);
                    element3.appendChild(element4);
                    element3.appendChild(element5);
                    element3.appendChild(element6);
                    element2.appendChild(element3);
                }
                ++n;
            }
        }
    }

    public void printNaResultsForOtherTests(ResultMgr resultMgr) throws IOException {
        Vector vector = resultMgr.getNaResults();
        if (!vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                Element element = null;
                NodeList nodeList = this.document.getElementsByTagName(OTHER);
                if (nodeList.getLength() == 0) {
                    element = this.document.createElement(OTHER);
                    this.rootNode.appendChild(element);
                } else {
                    element = (Element)nodeList.item(0);
                }
                nodeList = element.getChildNodes();
                Element element2 = null;
                if (nodeList.getLength() == 0) {
                    element2 = this.document.createElement(NOTAPPLICABLE);
                    element.appendChild(element2);
                } else {
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        if (((Element)nodeList.item(n2)).getTagName().equals(NOTAPPLICABLE)) {
                            element2 = (Element)nodeList.item(n2);
                            break;
                        }
                        ++n2;
                    }
                    if (element2 == null) {
                        element2 = this.document.createElement(NOTAPPLICABLE);
                        element.appendChild(element2);
                    }
                }
                Result result = (Result)vector.elementAt(n);
                if (result != null) {
                    Element element3 = this.document.createElement(TEST);
                    Element element4 = this.getTextNode(TEST_NAME, result.getTestName());
                    Element element5 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                    Enumeration enumeration = result.getNaDetails().elements();
                    String string = "";
                    while (enumeration.hasMoreElements()) {
                        string = string + (String)enumeration.nextElement() + "\n";
                    }
                    Element element6 = this.getTextNode(TEST_DESC, string);
                    element3.appendChild(element4);
                    element3.appendChild(element5);
                    element3.appendChild(element6);
                    element2.appendChild(element3);
                }
                ++n;
            }
        }
    }

    public void printWarningResultsForOtherTests(ResultMgr resultMgr) throws IOException {
        Vector vector = resultMgr.getNaResults();
        this.warningCount += vector.size();
        if (!vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                Element element = null;
                NodeList nodeList = this.document.getElementsByTagName(OTHER);
                if (nodeList.getLength() == 0) {
                    element = this.document.createElement(OTHER);
                    this.rootNode.appendChild(element);
                } else {
                    element = (Element)nodeList.item(0);
                }
                nodeList = element.getChildNodes();
                Element element2 = null;
                if (nodeList.getLength() == 0) {
                    element2 = this.document.createElement(WARNING);
                    element.appendChild(element2);
                } else {
                    int n2 = 0;
                    while (n2 < nodeList.getLength()) {
                        if (((Element)nodeList.item(n2)).getTagName().equals(WARNING)) {
                            element2 = (Element)nodeList.item(n2);
                            break;
                        }
                        ++n2;
                    }
                    if (element2 == null) {
                        element2 = this.document.createElement(WARNING);
                        element.appendChild(element2);
                    }
                }
                Result result = (Result)vector.elementAt(n);
                if (result != null) {
                    Element element3 = this.document.createElement(TEST);
                    Element element4 = this.getTextNode(TEST_NAME, result.getTestName());
                    Element element5 = this.getTextNode(TEST_ASSERTION, result.getAssertion());
                    Enumeration enumeration = result.getWarningDetails().elements();
                    String string = "";
                    while (enumeration.hasMoreElements()) {
                        string = string + (String)enumeration.nextElement() + "\n";
                    }
                    Element element6 = this.getTextNode(TEST_DESC, string);
                    element3.appendChild(element4);
                    element3.appendChild(element5);
                    element3.appendChild(element6);
                    element2.appendChild(element3);
                }
                ++n;
            }
        }
    }

    public void initialize() {
        this.failedCount = 0;
        this.errorCount = 0;
        this.warningCount = 0;
        this.createDOMTree();
    }

    public void createDOMTree() {
        this.document = this.newDocument();
        this.rootNode = this.document.createElement(STATIC_VER);
        this.document.appendChild(this.rootNode);
    }

    public void writeToFile() {
        File file = null;
        try {
            Object object;
            file = !this.getUserSpecifiedOutputFile() ? this.extractResultsFileToTmpDir(Verifier.outputFileStr + this.timestamp + ".xml") : this.extractResultsFileToTmpDir(Verifier.outputFileStr + ".xml");
            DOMSource dOMSource = new DOMSource(this.getDocument());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-public", PUBLICID);
            try {
                object = new File(System.getProperty("com.sun.enterprise.home"));
                object = new File((File)object, "lib");
                object = new File((File)object, "dtds");
                object = new File((File)object, SYSTEMID);
                transformer.setOutputProperty("doctype-system", ((File)object).toURL().toString());
            }
            catch (Exception exception) {
                transformer.setOutputProperty("doctype-system", "");
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            object = new FileOutputStream(file);
            transformer.transform(dOMSource, new StreamResult((OutputStream)object));
        }
        catch (TransformerException transformerException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerException)}));
            this.writeToFile();
            this.debug(transformerException);
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerException.toString()}));
            System.out.println(this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerException)}));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{fileNotFoundException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(fileNotFoundException)}));
            this.writeToFile();
            this.debug(fileNotFoundException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException", "Cannot find output file, no such file or directory: {0} - {1}", new Object[]{file.toString(), fileNotFoundException.getMessage()}));
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{file.toString()}));
            ResultsReport.fileNotFoundException = true;
        }
        catch (IOException iOException) {
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{iOException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(iOException)}));
            this.writeToFile();
            this.debug(iOException);
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".WriteDetails.IOException", "IO exception trying to access output file: {0}", new Object[]{file.toString()}));
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".WriteDetails.IOException.ErrMessage", "Unable to complete writing of output file:  {0}", new Object[]{file.toString()}));
        }
        if (!Verifier.hasAlreadyWrittenInvalidParseDetails()) {
            Verifier.log(this.smh.getLocalString(this.getClass().getName() + ".LookInResultsTestAssertions", "Look in file \"{0}\" for detailed results on test assertions.", new Object[]{file.toString()}));
        }
    }

    public boolean writeResults() {
        boolean bl = true;
        bl = this.writeDetails();
        if (bl) {
            try {
                bl = this.writeDetailsToText();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerConfigurationException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerConfigurationException)}));
                this.writeToFile();
                return false;
            }
            catch (TransformerException transformerException) {
                this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{transformerException.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(transformerException)}));
                this.writeToFile();
                return false;
            }
        }
        return bl;
    }

    public boolean writeDetails() {
        JarCheck[] jarCheckArray = JarCheckImpl.getCheckMgrs();
        try {
            int n = 0;
            while (n < jarCheckArray.length) {
                this.printAllFailedTestResults(jarCheckArray[n].getAllResults(), jarCheckArray[n]);
                ++n;
            }
            if (Verifier.getReportLevel() != 0) {
                int n2 = 0;
                while (n2 < jarCheckArray.length) {
                    this.printAllWarningTestResults(jarCheckArray[n2].getAllResults(), jarCheckArray[n2]);
                    ++n2;
                }
                if (Verifier.getReportLevel() == 2) {
                    int n3 = 0;
                    while (n3 < jarCheckArray.length) {
                        this.printAllPassedTestResults(jarCheckArray[n3].getAllResults(), jarCheckArray[n3]);
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < jarCheckArray.length) {
                        this.printAllNaTestResults(jarCheckArray[n4].getAllResults(), jarCheckArray[n4]);
                        ++n4;
                    }
                }
            }
            this.printAllResultsForOtherTests(this.resultMgr);
            this.failureCount();
            this.writeToFile();
            return true;
        }
        catch (Exception exception) {
            this.debug(exception);
            this.writeInvalidParseDetails(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{exception.toString()}), this.smh.getLocalString(this.getClass().getName() + ".Trace", " {0}", new Object[]{this.writeStackTraceToFile(exception)}));
            this.writeToFile();
            return false;
        }
    }

    public String writeStackTraceToFile(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void debug(Exception exception) {
        if (Verifier.getDebug()) {
            System.out.println(exception);
        }
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

