/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.MonitoringHelper;
import com.iplanet.ias.resource.monitor.IASResourcePoolMonitor;
import com.iplanet.ias.resource.monitor.JDBCPoolMonitorMBean;
import com.sun.enterprise.resource.IASNonSharedResourcePool;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;

public class IASResourcePoolMonitorImpl
implements IASResourcePoolMonitor {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private IASNonSharedResourcePool[] poolArray = new IASNonSharedResourcePool[2];
    private int arraySize = 0;

    public IASResourcePoolMonitorImpl(String string) {
        JDBCPoolMonitorMBean jDBCPoolMonitorMBean = new JDBCPoolMonitorMBean(this);
        try {
            MonitoringHelper.registerJdbcPoolMonitoringMBean(string, MonitoredObjectType.JDBC_CONN_POOL, jDBCPoolMonitorMBean);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            _logger.log(Level.SEVERE, "jdbc.mbean_register", mBeanRegistrationException);
        }
    }

    public int getNumConnFailedValidation() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arraySize) {
            n += this.poolArray[n2].getNumConnFailedValidation();
            ++n2;
        }
        return n;
    }

    public int getNumConnTimedOut() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arraySize) {
            n += this.poolArray[n2].getNumConnTimedOut();
            ++n2;
        }
        return n;
    }

    public int getNumThreadWaiting() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arraySize) {
            n += this.poolArray[n2].getNumThreadWaiting();
            ++n2;
        }
        return n;
    }

    public void addPool(IASNonSharedResourcePool iASNonSharedResourcePool) {
        if (this.arraySize >= 2) {
            return;
        }
        this.poolArray[this.arraySize] = iASNonSharedResourcePool;
        ++this.arraySize;
    }
}

