/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbIORConfigurationDescriptor {
    public static final String NONE = "none";
    public static final String SUPPORTED = "supported";
    public static final String REQUIRED = "required";
    public static final String USERNAME_PASSWORD = "username_password";
    public static final String DEFAULT_REALM = "default";
    private static final String SECURE_PROPERTIES = "security.properties";
    private String integrity = "supported";
    private String confidentiality = "supported";
    private String establishTrustInTarget = "supported";
    private String establishTrustInClient = "supported";
    private String authenticationMethod = "username_password";
    private String realmName = "default";
    private String callerPropagation = "supported";
    private boolean required = false;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public EjbIORConfigurationDescriptor() {
        try {
            String string;
            Properties properties = Utility.getPropertiesFromFile(SECURE_PROPERTIES);
            boolean bl = false;
            String string2 = properties.getProperty("interop.ssl.required");
            if (string2 != null && !string2.trim().equals("") && (bl = new Boolean(string2).booleanValue())) {
                this.integrity = REQUIRED;
                this.confidentiality = REQUIRED;
                this.establishTrustInClient = REQUIRED;
                this.establishTrustInTarget = SUPPORTED;
            }
            if ((string = properties.getProperty("interop.authRequired.enabled")) != null && !string.trim().equals("") && (bl = new Boolean(string).booleanValue())) {
                this.required = true;
                this.authenticationMethod = USERNAME_PASSWORD;
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
    }

    public EjbIORConfigurationDescriptor(boolean bl) {
        if (bl) {
            this.required = true;
            this.authenticationMethod = USERNAME_PASSWORD;
        }
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String string) {
        if (!(string.equals(NONE) || string.equals(SUPPORTED) || string.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for integrity:" + string);
        }
        this.integrity = string;
    }

    public String getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(String string) {
        if (!(string.equals(NONE) || string.equals(SUPPORTED) || string.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for confidentiality:" + string);
        }
        this.confidentiality = string;
    }

    public String getEstablishTrustInTarget() {
        return this.establishTrustInTarget;
    }

    public void setEstablishTrustInTarget(String string) {
        if (!string.equals(NONE) && !string.equals(SUPPORTED)) {
            throw new RuntimeException("Incorrect value for establishTrustInTarget:" + string);
        }
        this.establishTrustInTarget = string;
    }

    public String getEstablishTrustInClient() {
        return this.establishTrustInClient;
    }

    public void setEstablishTrustInClient(String string) {
        if (!(string.equals(NONE) || string.equals(SUPPORTED) || string.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for establishTrustInClient:" + string);
        }
        this.establishTrustInClient = string;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String string) {
        if (!string.equals(USERNAME_PASSWORD) && !string.equals(NONE)) {
            throw new RuntimeException("Incorrect value for authentication method:" + string);
        }
        this.authenticationMethod = string;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String string) {
        this.realmName = string;
    }

    public String getCallerPropagation() {
        return this.callerPropagation;
    }

    public void setCallerPropagation(String string) {
        if (!(string.equals(NONE) || string.equals(SUPPORTED) || string.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for callerPropagation:" + string);
        }
        this.callerPropagation = string;
    }

    public boolean isAuthMethodRequired() {
        return this.required;
    }

    public void setAuthMethodRequired(boolean bl) {
        this.required = bl;
    }

    public String toString() {
        String string = "";
        string = string + "\n integrity " + this.integrity;
        string = string + "\n confidentiality " + this.confidentiality;
        string = string + "\n establishTrustInTarget " + this.establishTrustInTarget;
        string = string + "\n establishTrustInClient " + this.establishTrustInClient;
        string = string + "\n callerPropagation " + this.callerPropagation;
        string = string + "\n realm " + this.realmName;
        string = string + "\n authenticationMethod " + this.authenticationMethod + "\n";
        return string;
    }
}

