/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.ArchiveOperationListener;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Archivist {
    public static String MANIFEST_VERSION_VALUE = "1.0";
    public static final boolean debug = false;
    private static String TMPFILENAME = "scratch";
    private static String EJB_TMP_FILENAME = "ejb_temp";
    private static String WEB_TMP_FILENAME = "web_temp";
    private static String CONNECTOR_TMP_FILENAME = "connector_temp";
    private static String APP_CLIENT_TMP_FILENAME = "app-client-temp";
    private static String LIB_TMP_FILENAME = "lib-temp";
    private String externalDescriptorArchiveUri = null;
    private String archiveUri = "";
    private String archiveCanonicalPath = "";
    protected Set manifestClasspath;
    private Vector entryNames = null;
    private Hashtable filesToBeAdded = new Hashtable();
    private Set filesToBeRemoved = new HashSet();
    private boolean archiveFileExists = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Archivist == null ? (class$com$sun$enterprise$deployment$Archivist = Archivist.class$("com.sun.enterprise.deployment.Archivist")) : class$com$sun$enterprise$deployment$Archivist);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    private static Vector archiveOperationListeners = null;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Archivist;

    protected Archivist(String string) {
        this.setHasArchive(true, string);
    }

    protected Archivist(String string, boolean bl) {
        this.setHasArchive(bl, string);
    }

    public abstract Descriptor getDescriptor();

    protected void setHasArchive(boolean bl, String string) {
        this.archiveFileExists = bl;
        this.setArchiveUri(string);
    }

    protected boolean hasArchive() {
        return this.archiveFileExists;
    }

    public void setArchiveUri(String string) {
        this.archiveUri = string;
        this.entryNames = null;
    }

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public void setArchiveCanonicalPath(String string) {
        this.archiveCanonicalPath = string;
    }

    public String getArchiveCanonicalPath() {
        return this.archiveCanonicalPath;
    }

    public boolean hasExternalDescriptor() {
        return this.externalDescriptorArchiveUri != null;
    }

    public String getExternalDescriptorArchiveUri() {
        return this.externalDescriptorArchiveUri;
    }

    public void setExternalDescriptorArchiveUri(String string) {
        this.externalDescriptorArchiveUri = string;
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        manifest.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public Set getManifestClasspaths() {
        if (this.manifestClasspath == null) {
            this.manifestClasspath = new HashSet();
        }
        return this.manifestClasspath;
    }

    public void addManfiestClasspath(String string) {
        this.getManifestClasspaths().add(string);
    }

    public void removeManifestClasspath(String string) {
        this.getManifestClasspaths().remove(string);
    }

    public void setManifestClasspaths(Manifest manifest) {
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attributes.Name name = (Attributes.Name)iterator.next();
            if (!name.equals(Attributes.Name.CLASS_PATH)) continue;
            String string = (String)attributes.get(name);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.getManifestClasspaths().add(string2);
            }
        }
    }

    public Vector getEntryNames() throws IOException {
        this.refreshEntryNames();
        Vector vector = (Vector)this.entryNames.clone();
        Enumeration enumeration = this.filesToBeAdded.keys();
        while (enumeration.hasMoreElements()) {
            vector.add((String)enumeration.nextElement());
        }
        return vector;
    }

    public Vector getClassEntryNames() throws IOException {
        Vector vector = this.getEntryNames();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string.endsWith(".class")) {
                vector2.add(string);
            }
            ++n;
        }
        return vector2;
    }

    public Vector getClassNames() throws IOException {
        Vector vector = this.getClassEntryNames();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = FileUtil.classNameFromEntryName(string);
            vector2.add(string2);
            ++n;
        }
        return vector2;
    }

    public boolean isDeletable(String string) {
        return true;
    }

    public void addFiles(Hashtable hashtable) throws IOException {
        this.updateFiles(hashtable);
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        this.refreshEntryNames();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.entryNames.contains(string)) continue;
            this.entryNames.remove(string);
            this.filesToBeRemoved.add(string);
        }
        this.filesToBeAdded.putAll(hashtable);
        this.fireAddEntriesNotification(hashtable);
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fileContentsDescriptor) throws IOException {
        return fileContentsDescriptor.getEntryNameMap();
    }

    public void removeEntry(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        this.removeEntries(vector);
    }

    public void removeEntries(Vector vector) throws IOException {
        this.refreshEntryNames();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            string = string.replace(File.separatorChar, '/');
            vector2.add(string);
            boolean bl = this.entryNames.removeElement(string);
            if (bl) {
                this.filesToBeRemoved.add(string);
            } else {
                Object v = this.filesToBeAdded.remove(string);
                if (v == null) {
                    // empty if block
                }
            }
            ++n;
        }
        this.fireRemoveEntriesNotification(vector2);
    }

    public Manifest createManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
        if (!this.getManifestClasspaths().isEmpty()) {
            String string = "";
            Iterator iterator = this.getManifestClasspaths().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string = string + string2;
                if (!iterator.hasNext()) continue;
                string = string + " ";
            }
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, string);
        }
        return manifest;
    }

    protected abstract File getArchiveFile() throws IOException;

    public String getUniqueEntryNameFor(String string) throws IOException {
        return Descriptor.createUniqueNameAmongst(string, this.getEntryNames());
    }

    protected String getUniqueEntryFilenameFor(File file, String string) throws IOException {
        return Descriptor.createUniqueFilenameAmongst(string, this.getEntryNamesFrom(file));
    }

    protected String getUniqueEntryNameFor(File file, String string) throws IOException {
        return Descriptor.createUniqueNameAmongst(string, this.getEntryNamesFrom(file));
    }

    protected Vector getEntryNamesFrom(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Vector<String> vector = new Vector<String>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            vector.addElement(zipEntry.getName());
        }
        zipFile.close();
        return vector;
    }

    protected Hashtable getFilesToBeAdded() throws IOException {
        return this.filesToBeAdded;
    }

    protected Set getFilesToBeRemoved() throws IOException {
        return this.filesToBeRemoved;
    }

    protected void writeEntriesToOutput(ZipOutputStream zipOutputStream, Vector vector) throws IOException {
        this.writeEntriesToOutput(zipOutputStream, vector, new Vector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeEntriesToOutput(ZipOutputStream zipOutputStream, Vector vector, Vector vector2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.hasArchive()) {
            this.refreshEntryNames();
            object3 = new JarFile(this.getArchiveFile());
            int n = 0;
            while (true) {
                if (n >= this.entryNames.size()) {
                    ((ZipFile)object3).close();
                    break;
                }
                object2 = (String)this.entryNames.elementAt(n);
                if (!vector.contains(object2)) {
                    Archivist.writeEntry(zipOutputStream, (JarFile)object3, (String)object2);
                }
                ++n;
            }
        }
        object3 = this.filesToBeAdded.entrySet();
        Iterator iterator = object3.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            object2 = iterator.next();
            File file = (File)object2.getValue();
            object = (String)object2.getKey();
            Archivist.writeEntry(zipOutputStream, file, (String)object);
        }
        object2 = new Vector();
        ((Vector)object2).addElement("META-INF/MANIFEST.MF");
        int n = 0;
        while (true) {
            block13: {
                Object var12_13;
                if (n >= vector2.size()) {
                    this.filesToBeAdded = new Hashtable();
                    this.filesToBeRemoved = new HashSet();
                    this.entryNames = null;
                    return;
                }
                object = (File)vector2.elementAt(n);
                JarFile jarFile = null;
                try {
                    try {
                        jarFile = new JarFile((File)object);
                        Archivist.addJarToOutput(zipOutputStream, jarFile, (Vector)object2);
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, "enterprise.deployment_cannot_expand_jar", exception);
                        var12_13 = null;
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block13;
                    }
                    var12_13 = null;
                    if (jarFile == null) break block13;
                }
                catch (Throwable throwable) {
                    var12_13 = null;
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw throwable;
                }
                jarFile.close();
            }
            ++n;
        }
    }

    private void refreshEntryNames() throws IOException {
        if (this.hasArchive()) {
            if (this.entryNames == null) {
                this.entryNames = this.getEntryNamesFrom(this.getArchiveFile());
                this.entryNames.removeAll(this.filesToBeRemoved);
            }
        } else {
            this.entryNames = new Vector();
        }
    }

    static void dump(Manifest manifest) {
        try {
            manifest.write(System.out);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void writeEntry(ZipOutputStream zipOutputStream, InputStream inputStream, ZipEntry zipEntry) throws IOException {
        try {
            zipOutputStream.putNextEntry(zipEntry);
            Archivist.copy(inputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (ZipException zipException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeEntry(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(string);
                Archivist.writeEntry(zipOutputStream, fileInputStream, zipEntry);
            }
            catch (ZipException zipException) {
                Object var6_7 = null;
                if (fileInputStream == null) return;
                ((InputStream)fileInputStream).close();
                return;
            }
            Object var6_6 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileInputStream == null) throw throwable;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeEntry(ZipOutputStream zipOutputStream, JarFile jarFile, String string) throws IOException {
        InputStream inputStream = null;
        try {
            try {
                ZipEntry zipEntry = jarFile.getEntry(string);
                inputStream = jarFile.getInputStream(zipEntry);
                ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                Archivist.writeEntry(zipOutputStream, inputStream, zipEntry2);
            }
            catch (ZipException zipException) {
                Object var7_8 = null;
                if (inputStream == null) return;
                inputStream.close();
                return;
            }
            Object var7_7 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public static void addJarToOutput(ZipOutputStream zipOutputStream, JarFile jarFile, Vector vector) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (vector.contains(zipEntry.getName())) continue;
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                Archivist.writeEntry(zipOutputStream, inputStream, new ZipEntry(zipEntry));
            }
            catch (IOException iOException) {
                _logger.log(Level.WARNING, "enterprise.deployment_cannot_add_jar", iOException);
            }
        }
        jarFile.close();
    }

    public Hashtable addFiles(Hashtable hashtable, File file) throws IOException {
        File file2 = Archivist.createTempFile(Archivist.getDirectory(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Hashtable<String, File> hashtable2 = new Hashtable<String, File>();
        Vector vector = this.getEntryNamesFrom(file);
        JarFile jarFile = new JarFile(file);
        Archivist.addJarToOutput(zipOutputStream, jarFile, new Vector());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file3 = (File)hashtable.get(string);
            String string2 = Descriptor.createUniqueNameAmongst(string, vector);
            hashtable2.put(string2, file3);
            FileInputStream fileInputStream = new FileInputStream(file3);
            zipOutputStream.putNextEntry(new JarEntry(string2));
            Archivist.copy(fileInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
        zipOutputStream.close();
        jarFile.close();
        file.delete();
        if (!file2.renameTo(file)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR {0} to {1}", new Object[]{file2, file}));
        }
        return hashtable2;
    }

    public void removeEntries(Set set, File file) throws IOException {
        Vector vector = new Vector(set);
        File file2 = Archivist.createTempFile(Archivist.getDirectory(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        JarFile jarFile = new JarFile(file);
        Archivist.addJarToOutput(zipOutputStream, jarFile, vector);
        zipOutputStream.close();
        jarFile.close();
        if (!file2.renameTo(file)) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrornamingjartofile", "Error renaming JAR {0} to {1}", new Object[]{file2, file}));
        }
    }

    public static void extractJarFile(File file, File file2) throws IOException {
        Archivist.extractJarFile(file, file2, true);
    }

    public static void extractJarFile(File file, File file2, boolean bl) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName().replace('/', File.separatorChar);
            File file3 = new File(file2, string);
            if (bl) {
                file3.deleteOnExit();
            }
            if (zipEntry.isDirectory()) {
                file3.mkdirs();
                continue;
            }
            File file4 = new File(file3.getParent());
            boolean bl2 = true;
            if (!file4.exists()) {
                bl2 = file4.mkdirs();
            }
            if (bl2) {
                InputStream inputStream = jarFile.getInputStream(new ZipEntry(zipEntry));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                Archivist.copy(inputStream, bufferedOutputStream);
                bufferedOutputStream.close();
                continue;
            }
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionunpackingarchivefailed", "Unpacking archive failed: could not make parent file for {0}", new Object[]{file3}));
        }
        jarFile.close();
    }

    public static void extractJarFile(JarInputStream jarInputStream, AbstractArchive abstractArchive) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            abstractArchive.addEntry(zipEntry.getName(), jarInputStream);
        }
        jarInputStream.close();
    }

    protected static void writeDocumentToJar(Document document, String string, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        XMLUtils.writeDocument(document, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public static void copyWithoutClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            try {
                n = inputStream.read(byArray, 0, byArray.length);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (n == -1) continue;
            outputStream.write(byArray, 0, n);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Archivist.copyWithoutClose(inputStream, outputStream);
        inputStream.close();
    }

    static File getDirectory(File file) {
        String string = file.getAbsolutePath();
        return new File(new File(string).getParent());
    }

    static File getEjbTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(EJB_TMP_FILENAME, ".jar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        return file2;
    }

    static File getApplicationClientTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(APP_CLIENT_TMP_FILENAME, ".jar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static File getRarTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(CONNECTOR_TMP_FILENAME, ".rar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static File getWebTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(WEB_TMP_FILENAME, ".war", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static File getConnectorTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(CONNECTOR_TMP_FILENAME, ".rar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static File getLibraryTemp(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(LIB_TMP_FILENAME, ".jar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static File createTempFile(File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile(TMPFILENAME, "jar", file);
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        file2.deleteOnExit();
        return file2;
    }

    static void checkExists(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionfiledoesnotexist", "{0} does not exist", new Object[]{file}));
        }
    }

    public static void validate(InputStream inputStream) throws SAXParseException {
        try {
            SAXParserFactory sAXParserFactory = XMLUtils.getSAXParserFactory();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new XMLValidationHandler());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            _logger.log(Level.WARNING, "enterprise.deployment_sax_parser_config", parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            if (sAXException instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)sAXException;
                throw sAXParseException;
            }
            _logger.log(Level.WARNING, "enterprise.deployment_sax_parser", sAXException.getMessage());
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_parser_cannot_validate", iOException);
        }
    }

    protected Vector getListOfExemptForClassLoadableFormat() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("META-INF/MANIFEST.MF");
        return vector;
    }

    protected Vector getLibraryJars(Archivist archivist) throws IOException {
        Vector<String> vector = new Vector<String>();
        Set set = this.getManifestClasspaths();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getArchiveUri().lastIndexOf("/") == -1 ? "" : this.getArchiveUri().substring(0, this.getArchiveUri().lastIndexOf("/"));
            String string3 = string2 + string;
            vector.add(string3);
        }
        return vector;
    }

    protected void makeArchiveClassLoadable(JarInputStream jarInputStream, AbstractArchive abstractArchive) throws IOException {
        ZipEntry zipEntry;
        Vector vector = this.getListOfExemptForClassLoadableFormat();
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory() || vector.contains(zipEntry.getName())) continue;
            abstractArchive.addEntry(zipEntry.getName(), jarInputStream);
        }
    }

    public static void addArchiveOperationListener(ArchiveOperationListener archiveOperationListener) {
        if (archiveOperationListeners == null) {
            archiveOperationListeners = new Vector();
        }
        if (!archiveOperationListeners.contains(archiveOperationListener)) {
            archiveOperationListeners.add(archiveOperationListener);
        }
    }

    public static void removeArchiveOperationListener(ArchiveOperationListener archiveOperationListener) {
        if (archiveOperationListeners != null) {
            archiveOperationListeners.remove(archiveOperationListener);
        }
    }

    protected void fireAddEntriesNotification(Hashtable hashtable) {
        if (archiveOperationListeners != null) {
            Iterator iterator = archiveOperationListeners.iterator();
            while (iterator.hasNext()) {
                ArchiveOperationListener archiveOperationListener = (ArchiveOperationListener)iterator.next();
                archiveOperationListener.addArchiveEntries(this, hashtable);
            }
        }
    }

    protected void fireRemoveEntriesNotification(Vector vector) {
        if (archiveOperationListeners != null) {
            Iterator iterator = archiveOperationListeners.iterator();
            while (iterator.hasNext()) {
                ArchiveOperationListener archiveOperationListener = (ArchiveOperationListener)iterator.next();
                archiveOperationListener.removeArchiveEntries(this, vector);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

