/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop.messages;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServiceContexts;
import com.sun.corba.ee.internal.iiop.AddressingDispositionException;
import com.sun.corba.ee.internal.iiop.MessageMediator;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.IORAddressingInfo;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.Message;
import com.sun.corba.ee.internal.iiop.messages.Message_1_0;
import com.sun.corba.ee.internal.iiop.messages.Message_1_1;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.TargetAddress;
import com.sun.corba.ee.internal.ior.IIOPProfile;
import com.sun.corba.ee.internal.ior.ObjectKey;
import com.sun.corba.ee.internal.ior.ObjectKeyFactory;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Principal;
import org.omg.IOP.TaggedProfile;

public abstract class MessageBase
implements Message {
    public byte[] giopHeader;

    public static Message createFromStream(ORB oRB, InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        MessageBase messageBase = null;
        boolean bl = oRB.giopDebugFlag;
        byte[] byArray = new byte[12];
        MessageBase.readFully(inputStream, byArray, 0, 12);
        if (bl) {
            ORBUtility.dprint("Message", "createFromStream: type is " + byArray[7]);
        }
        if ((n5 = (n4 = byArray[0] << 24 & 0xFF000000) | (n3 = byArray[1] << 16 & 0xFF0000) | (n2 = byArray[2] << 8 & 0xFF00) | (n = byArray[3] << 0 & 0xFF)) != 1195986768) {
            throw new INTERNAL(1398079708, CompletionStatus.COMPLETED_MAYBE);
        }
        GIOPVersion gIOPVersion = oRB.getGIOPVersion();
        if (bl) {
            ORBUtility.dprint("MessageBase", "Message GIOP version: " + byArray[4] + '.' + byArray[5]);
            ORBUtility.dprint("MessageBase", "ORB Max GIOP Version: " + gIOPVersion);
        }
        if ((byArray[4] > gIOPVersion.getMajor() || byArray[4] == gIOPVersion.getMajor() && byArray[5] > gIOPVersion.getMinor()) && byArray[7] != 6) {
            throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
        }
        MessageBase.AreFragmentsAllowed(byArray[4], byArray[5], byArray[6], byArray[7]);
        switch (byArray[7]) {
            case 0: {
                if (bl) {
                    ORBUtility.dprint("Message", "createFromStream: creating RequestMessage");
                }
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new RequestMessage_1_0(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new RequestMessage_1_1(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new RequestMessage_1_2(oRB);
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 3: {
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new LocateRequestMessage_1_0(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new LocateRequestMessage_1_1(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new LocateRequestMessage_1_2(oRB);
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new CancelRequestMessage_1_0();
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new CancelRequestMessage_1_1();
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new CancelRequestMessage_1_2();
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: {
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new ReplyMessage_1_0(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new ReplyMessage_1_1(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new ReplyMessage_1_2(oRB);
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 4: {
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new LocateReplyMessage_1_0(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new LocateReplyMessage_1_1(oRB);
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new LocateReplyMessage_1_2(oRB);
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 5: 
            case 6: {
                if (byArray[4] == 1 && byArray[5] == 0) {
                    messageBase = new Message_1_0();
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new Message_1_1();
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new Message_1_1();
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            case 7: {
                if (byArray[4] == 1 && byArray[5] == 0) break;
                if (byArray[4] == 1 && byArray[5] == 1) {
                    messageBase = new FragmentMessage_1_1();
                    break;
                }
                if (byArray[4] == 1 && byArray[5] == 2) {
                    messageBase = new FragmentMessage_1_2();
                    break;
                }
                throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (bl) {
                    ORBUtility.dprint("Message", "createFromStream: fell off end!");
                }
                throw new INTERNAL(1398079711, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (byArray[4] == 1 && byArray[5] == 0) {
            Message_1_0 message_1_0 = messageBase;
            message_1_0.magic = n5;
            message_1_0.GIOP_version = new GIOPVersion(byArray[4], byArray[5]);
            message_1_0.byte_order = byArray[6] == 1;
            message_1_0.message_type = byArray[7];
            message_1_0.message_size = MessageBase.readSize(byArray[8], byArray[9], byArray[10], byArray[11], message_1_0.isLittleEndian()) + 12;
        } else {
            Message_1_1 message_1_1 = (Message_1_1)messageBase;
            message_1_1.magic = n5;
            message_1_1.GIOP_version = new GIOPVersion(byArray[4], byArray[5]);
            message_1_1.flags = byArray[6];
            message_1_1.message_type = byArray[7];
            message_1_1.message_size = MessageBase.readSize(byArray[8], byArray[9], byArray[10], byArray[11], message_1_1.isLittleEndian()) + 12;
        }
        if (bl) {
            ORBUtility.dprint("Message", "createFromStream: message construction complete.");
            ((MessageBase)messageBase).giopHeader = byArray;
        }
        return messageBase;
    }

    private static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, int n, boolean bl, byte[] byArray, String string, ServiceContexts serviceContexts, Principal principal) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new RequestMessage_1_0(oRB, serviceContexts, n, bl, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new RequestMessage_1_1(oRB, serviceContexts, n, bl, new byte[]{0, 0, 0}, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            byte by = 3;
            by = bl ? (byte)3 : 0;
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            return new RequestMessage_1_2(oRB, n, by, new byte[]{0, 0, 0}, targetAddress, string, serviceContexts);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, int n, boolean bl, IOR iOR, short s, String string, ServiceContexts serviceContexts, Principal principal) {
        if (s == 0) {
            IIOPProfile iIOPProfile = iOR.getProfile();
            ObjectKey objectKey = iIOPProfile.getObjectKey();
            byte[] byArray = objectKey.getBytes(oRB);
            return MessageBase.createRequest(oRB, gIOPVersion, n, bl, byArray, string, serviceContexts, principal);
        }
        if (!gIOPVersion.equals(GIOPVersion.V1_2)) {
            throw new INTERNAL("GIOP version error", 1398079709, CompletionStatus.COMPLETED_NO);
        }
        byte by = 3;
        by = bl ? (byte)3 : 0;
        TargetAddress targetAddress = new TargetAddress();
        if (s == 1) {
            IIOPProfile iIOPProfile = iOR.getProfile();
            targetAddress.profile(iIOPProfile.getIOPProfile(oRB));
        } else if (s == 2) {
            IORAddressingInfo iORAddressingInfo = new IORAddressingInfo(0, iOR.getIOPIOR(oRB));
            targetAddress.ior(iORAddressingInfo);
        } else {
            throw new INTERNAL("Illegal target address disposition", 1398079717, CompletionStatus.COMPLETED_NO);
        }
        return new RequestMessage_1_2(oRB, n, by, new byte[]{0, 0, 0}, targetAddress, string, serviceContexts);
    }

    public static ReplyMessage createReply(ORB oRB, GIOPVersion gIOPVersion, int n, int n2, ServiceContexts serviceContexts, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new ReplyMessage_1_0(oRB, serviceContexts, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new ReplyMessage_1_1(oRB, serviceContexts, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new ReplyMessage_1_2(oRB, n, n2, serviceContexts, iOR);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateRequestMessage createLocateRequest(ORB oRB, GIOPVersion gIOPVersion, int n, byte[] byArray) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateRequestMessage_1_0(oRB, n, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateRequestMessage_1_1(oRB, n, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            return new LocateRequestMessage_1_2(oRB, n, targetAddress);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateReplyMessage createLocateReply(ORB oRB, GIOPVersion gIOPVersion, int n, int n2, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateReplyMessage_1_0(oRB, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateReplyMessage_1_1(oRB, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new LocateReplyMessage_1_2(oRB, n, n2, iOR);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static CancelRequestMessage createCancelRequest(GIOPVersion gIOPVersion, int n) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new CancelRequestMessage_1_0(n);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new CancelRequestMessage_1_1(n);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new CancelRequestMessage_1_2(n);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createCloseConnection(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 5, 0);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createMessageError(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 6, 0);
        }
        throw new INTERNAL(1398079709, CompletionStatus.COMPLETED_MAYBE);
    }

    public static FragmentMessage createFragmentMessage(GIOPVersion gIOPVersion) {
        return null;
    }

    public static int getRequestId(Message message) {
        switch (message.getType()) {
            case 0: {
                return ((RequestMessage)message).getRequestId();
            }
            case 1: {
                return ((ReplyMessage)message).getRequestId();
            }
            case 3: {
                return ((LocateRequestMessage)message).getRequestId();
            }
            case 4: {
                return ((LocateReplyMessage)message).getRequestId();
            }
            case 2: {
                return ((CancelRequestMessage)message).getRequestId();
            }
            case 7: {
                return ((FragmentMessage)message).getRequestId();
            }
        }
        throw new INTERNAL(1398079711, CompletionStatus.COMPLETED_MAYBE);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (true) {
                try {
                    n4 = inputStream.read(byArray, n + n3, n2 - n3);
                }
                catch (IOException iOException) {
                    if (n5++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n4 < 0) {
                throw new IOException();
            }
            n3 += n4;
        }
    }

    public static void setFlag(byte[] byArray, int n) {
        byArray[6] = (byte)(byArray[6] | n);
    }

    public static void clearFlag(byte[] byArray, int n) {
        byArray[6] = (byte)(byArray[6] & (0xFF ^ n));
    }

    private static void AreFragmentsAllowed(byte by, byte by2, byte by3, byte by4) {
        if (by == 1 && by2 == 0 && by4 == 7) {
            throw new INTERNAL(1398079712, CompletionStatus.COMPLETED_MAYBE);
        }
        if ((by3 & 2) == 2) {
            switch (by4) {
                case 2: 
                case 5: 
                case 6: {
                    throw new INTERNAL(1398079712, CompletionStatus.COMPLETED_MAYBE);
                }
                case 3: 
                case 4: {
                    if (by != 1 || by2 != 1) break;
                    throw new INTERNAL(1398079712, CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
    }

    static ObjectKey extractObjectKey(byte[] byArray, ORB oRB) {
        try {
            ObjectKey objectKey;
            if (byArray != null && (objectKey = ObjectKeyFactory.get().create(oRB, byArray)) != null) {
                return objectKey;
            }
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        throw new MARSHAL(1398079696, CompletionStatus.COMPLETED_NO);
    }

    static ObjectKey extractObjectKey(TargetAddress targetAddress, ORB oRB) {
        short s = oRB.getGIOPTargetAddressPreference();
        short s2 = targetAddress.discriminator();
        switch (s) {
            case 0: {
                if (s2 == 0) break;
                throw new AddressingDispositionException(0);
            }
            case 1: {
                if (s2 == 1) break;
                throw new AddressingDispositionException(1);
            }
            case 2: {
                if (s2 == 2) break;
                throw new AddressingDispositionException(2);
            }
            case 3: {
                break;
            }
            default: {
                throw new INTERNAL("ORB target address preference in extractObjectKey is invalid", 1398079719, CompletionStatus.COMPLETED_NO);
            }
        }
        try {
            switch (s2) {
                case 0: {
                    ObjectKey objectKey;
                    byte[] byArray = targetAddress.object_key();
                    if (byArray == null || (objectKey = ObjectKeyFactory.get().create(oRB, byArray)) == null) break;
                    return objectKey;
                }
                case 1: {
                    ObjectKey objectKey;
                    IIOPProfile iIOPProfile = null;
                    TaggedProfile taggedProfile = targetAddress.profile();
                    if (taggedProfile == null || (objectKey = (iIOPProfile = new IIOPProfile(oRB, taggedProfile)).getObjectKey()) == null) break;
                    return objectKey;
                }
                case 2: {
                    TaggedProfile taggedProfile;
                    IIOPProfile iIOPProfile;
                    ObjectKey objectKey;
                    IORAddressingInfo iORAddressingInfo = targetAddress.ior();
                    if (iORAddressingInfo == null || (objectKey = (iIOPProfile = new IIOPProfile(oRB, taggedProfile = iORAddressingInfo.ior.profiles[iORAddressingInfo.selected_profile_index])).getObjectKey()) == null) break;
                    return objectKey;
                }
            }
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        throw new MARSHAL(1398079696, CompletionStatus.COMPLETED_NO);
    }

    private static int readSize(byte by, byte by2, byte by3, byte by4, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!bl) {
            n4 = by << 24 & 0xFF000000;
            n3 = by2 << 16 & 0xFF0000;
            n2 = by3 << 8 & 0xFF00;
            n = by4 << 0 & 0xFF;
        } else {
            n4 = by4 << 24 & 0xFF000000;
            n3 = by3 << 16 & 0xFF0000;
            n2 = by2 << 8 & 0xFF00;
            n = by << 0 & 0xFF;
        }
        return n4 | n3 | n2 | n;
    }

    static void nullCheck(Object object) {
        if (object == null) {
            throw new MARSHAL(0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void callback(MessageMediator messageMediator) throws IOException {
        messageMediator.handleInput(this);
    }
}

