/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.corba;

import com.sun.corba.ee.internal.corba.EncapsInputStream;
import com.sun.corba.ee.internal.corba.TypeCodeImpl;
import com.sun.corba.ee.internal.corba.TypeCodeReader;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.InputStream;

class TypeCodeInputStream
extends EncapsInputStream
implements TypeCodeReader {
    private Map typeMap = null;
    private InputStream enclosure = null;
    private boolean isEncapsulation = false;

    public TypeCodeInputStream(ORB oRB, byte[] byArray, int n) {
        super(oRB, byArray, n);
    }

    public TypeCodeInputStream(ORB oRB, byte[] byArray, int n, boolean bl) {
        super(oRB, byArray, n, bl);
    }

    public void addTypeCodeAtPosition(TypeCodeImpl typeCodeImpl, int n) {
        if (this.typeMap == null) {
            this.typeMap = new HashMap(16);
        }
        this.typeMap.put(new Integer(n), typeCodeImpl);
    }

    public TypeCodeImpl getTypeCodeAtPosition(int n) {
        if (this.typeMap == null) {
            return null;
        }
        return (TypeCodeImpl)this.typeMap.get(new Integer(n));
    }

    public void setEnclosingInputStream(InputStream inputStream) {
        this.enclosure = inputStream;
    }

    public TypeCodeReader getTopLevelStream() {
        if (this.enclosure == null) {
            return this;
        }
        if (this.enclosure instanceof TypeCodeReader) {
            return ((TypeCodeReader)((Object)this.enclosure)).getTopLevelStream();
        }
        return this;
    }

    public int getTopLevelPosition() {
        if (this.enclosure != null && this.enclosure instanceof TypeCodeReader) {
            int n = ((TypeCodeReader)((Object)this.enclosure)).getTopLevelPosition();
            int n2 = n - this.getBufferLength() + this.getPosition();
            return n2;
        }
        return this.getPosition();
    }

    public static TypeCodeInputStream readEncapsulation(InputStream inputStream, ORB oRB) {
        int n = inputStream.read_long();
        byte[] byArray = new byte[n];
        inputStream.read_octet_array(byArray, 0, byArray.length);
        TypeCodeInputStream typeCodeInputStream = inputStream instanceof CDRInputStream ? new TypeCodeInputStream(oRB, byArray, byArray.length, ((CDRInputStream)inputStream).isLittleEndian()) : new TypeCodeInputStream(oRB, byArray, byArray.length);
        typeCodeInputStream.setEnclosingInputStream(inputStream);
        typeCodeInputStream.makeEncapsulation();
        return typeCodeInputStream;
    }

    protected void makeEncapsulation() {
        this.consumeEndian();
        this.isEncapsulation = true;
    }

    public void printTypeMap() {
        System.out.println("typeMap = {");
        Iterator iterator = this.typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            TypeCodeImpl typeCodeImpl = (TypeCodeImpl)this.typeMap.get(n);
            System.out.println("  key = " + n + ", value = " + typeCodeImpl.description());
        }
        System.out.println("}");
    }
}

