/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.Repository;
import com.sun.corba.ee.ActivationIDL.RepositoryHelper;
import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ListServers;
import com.sun.corba.ee.internal.orbutil.CorbaResourceUtil;
import java.io.PrintStream;
import java.util.logging.Level;
import org.omg.CORBA.ORB;

class ListActiveServers
implements CommandHandler {
    ListActiveServers() {
    }

    public String getCommandName() {
        return "listactive";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.listactive"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.listactive1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            Activator activator = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
            int[] nArray = activator.getActiveServers();
            printStream.println(CorbaResourceUtil.getText("servertool.list2"));
            ListServers.sortServers(nArray);
            int n = 0;
            while (n < nArray.length) {
                try {
                    ServerDef serverDef = repository.getServer(nArray[n]);
                    printStream.println("\t   " + nArray[n] + "\t\t" + serverDef.serverName + "\t\t" + serverDef.applicationName);
                }
                catch (ServerNotRegistered serverNotRegistered) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        return false;
    }
}

