/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.util.logging.IASLevel;
import com.iplanet.ias.web.CacheModule;
import com.iplanet.ias.web.WebModule;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;

final class WebModuleListener
implements LifecycleListener {
    private static Logger _logger;
    private static boolean _debugLog;

    WebModuleListener() {
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        WebModule webModule;
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
        try {
            webModule = (WebModule)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            _logger.log(Level.WARNING, "webmodule.listener.classcastException", lifecycleEvent.getLifecycle());
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.configureJspParameters(webModule);
            this.startCacheManager(webModule);
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    private void configureJspParameters(WebModule webModule) {
        SunWebApp sunWebApp = webModule.getIasWebAppConfigBean();
        String string = webModule.findServletMapping("*.jsp");
        Wrapper wrapper = (Wrapper)webModule.findChild(string);
        if (wrapper == null) {
            return;
        }
        String string2 = wrapper.getServletClass();
        if (string2 != null && (string2.equals("org.apache.jasper.servlet.JspServlet") || string2.equals("com.iplanet.ias.web.jsp.JspServlet"))) {
            if (sunWebApp != null && sunWebApp.getJspConfig() != null) {
                WebProperty[] webPropertyArray = sunWebApp.getJspConfig().getWebProperty();
                int n = 0;
                while (n < webPropertyArray.length) {
                    String string3 = webPropertyArray[n].getAttributeValue("name");
                    String string4 = webPropertyArray[n].getAttributeValue("value");
                    if (_debugLog) {
                        _logger.fine("jsp-config property for [" + webModule.getID() + "] is [" + string3 + "] = [" + string4 + "]");
                    }
                    wrapper.addInitParameter(string3, string4);
                    ++n;
                }
            }
            wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
        }
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level.equals(IASLevel.FATAL)) {
            return "fatal";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        block6: {
            SunWebApp sunWebApp = webModule.getIasWebAppConfigBean();
            if (sunWebApp == null) break block6;
            CacheManager cacheManager = null;
            try {
                cacheManager = CacheModule.configureResponseCache(webModule, sunWebApp);
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "webmodule.listener.cachemgrException", exception);
            }
            if (cacheManager != null) {
                try {
                    cacheManager.start();
                    if (_debugLog) {
                        _logger.fine("Cache Manager started");
                    }
                    ServletContext servletContext = webModule.getServletContext();
                    servletContext.setAttribute("com.sun.appserv.web.CacheManager", (Object)cacheManager);
                }
                catch (LifecycleException lifecycleException) {
                    _logger.log(Level.WARNING, lifecycleException.getMessage(), lifecycleException.getThrowable());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        block3: {
            ServletContext servletContext = webModule.getServletContext();
            CacheManager cacheManager = (CacheManager)servletContext.getAttribute("com.sun.appserv.web.CacheManager");
            if (cacheManager == null) break block3;
            try {
                cacheManager.stop();
                if (_debugLog) {
                    _logger.fine("Cache Manager stopped");
                }
                servletContext.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException lifecycleException) {
                _logger.log(Level.WARNING, lifecycleException.getMessage(), lifecycleException.getThrowable());
            }
        }
    }
}

