/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyWrapper
implements Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bTryDefaultFileOnEnvFailure = true;
    private boolean bLoaded = false;
    protected boolean bDebug = false;
    protected String properties_file_name = null;
    protected Properties props = null;

    public PropertyWrapper(String string, String string2, boolean bl) {
        try {
            if (null != string2) {
                String string3;
                SecurityManager securityManager = System.getSecurityManager();
                if (null != securityManager) {
                    securityManager.checkPropertyAccess(string2);
                }
                if (null != (string3 = System.getProperty(string2))) {
                    this.properties_file_name = string3;
                    try {
                        this.loadProperties();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (SecurityException securityException) {
            _logger.log(Level.SEVERE, "iplanet_util.security_exception", new Object[]{this.properties_file_name, securityException});
        }
        if (!this.bLoaded && bl && null != string) {
            try {
                this.properties_file_name = string;
                this.loadProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.bLoaded && this.bDebug) {
            _logger.log(Level.FINE, "PropertyWrapper using " + this.properties_file_name);
        } else if (!this.bLoaded && this.bDebug) {
            _logger.log(Level.FINE, "PropertyWrapper reports properties could not be loaded for env=" + string2 + " or filename=" + string);
        }
    }

    public PropertyWrapper(String string, String string2) {
        this(string, string2, true);
    }

    public PropertyWrapper(String string) {
        this(string, null, true);
    }

    public PropertyWrapper(Properties properties) {
        this.props = properties;
    }

    public String getPropertiesFile() {
        return this.properties_file_name;
    }

    protected void loadProperties() throws IOException {
        this.props = new Properties();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(this.properties_file_name);
        this.props.load(inputStream);
        if (!this.props.isEmpty()) {
            this.bLoaded = true;
        }
    }

    protected String getProperty(String string) {
        return this.getProperty(string, null);
    }

    protected String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    protected int getIntProperty(String string) {
        String string2 = this.getProperty(string);
        if (null == string2) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (null == string2) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (null == string2) {
            return bl;
        }
        if (string2.toLowerCase().startsWith("true")) {
            return true;
        }
        if (string2.toLowerCase().startsWith("false")) {
            return false;
        }
        return bl;
    }

    protected long getLongProperty(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    protected long getLongProperty(String string, long l) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }
}

