/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.loader.EJBClassPathUtils;
import com.iplanet.ias.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class EJBModuleLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    EJBModuleLoader(String string, ClassLoader classLoader, EjbModulesManager ejbModulesManager) {
        super(string, classLoader, ejbModulesManager);
        String[] stringArray = EJBClassPathUtils.getEjbModuleClasspath(string, ejbModulesManager);
        this.initializeLoader(stringArray);
        try {
            this.application = ejbModulesManager.getDescriptor(string, this.ejbClassLoader);
            try {
                Set set = this.getEJBClasses(this.application, this.ejbUrlClassLoader);
                ((EJBClassLoader)this.ejbClassLoader).addEjbClassNames(set);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.log(Level.WARNING, "loader.class_not_found", classNotFoundException);
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "loader.configexception", configException);
        }
    }

    boolean load() {
        return this.loadEjbs();
    }

    boolean unload() {
        boolean bl = this.unloadEjbs();
        this.done();
        return bl;
    }
}

