/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.admin.event.AdminEventListenerRegistry;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.loader.ClassLoaderUtils;
import com.iplanet.ias.server.ResourceManager;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.server.ServerContextImpl;
import com.iplanet.ias.server.logging.ServerLogManager;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ApplicationServer {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static PrintStream ostream = System.out;
    public static PrintStream estream = System.err;
    private static final String USER_TX = "java:comp/UserTransaction";
    private static final String CODEBASE_PROP = "java.rmi.server.codebase";
    static String[][] servicesByName = new String[][]{{"LicenseChecker", "com.iplanet.ias.license.LicenseLifecycle"}, {"JMSProvider", "com.iplanet.ias.jms.JmsProviderLifecycle"}, {"AdminService", "com.iplanet.ias.admin.server.core.AdminServiceLifeCycle"}, {"PersistenceManagerService", "com.iplanet.ias.persistence.internal.ejb.PersistenceManagerServiceImpl"}, {"Application Service", "com.iplanet.ias.server.ApplicationLifecycle"}, {"Servlet/JSP Service", "com.iplanet.ias.web.WebContainerLifecycle"}, {"LifecycleModuleService", "com.sun.appserv.server.LifecycleModuleService"}};
    private static ServerContext context = null;
    private ArrayList services = new ArrayList();
    private ClassLoader commonClassLoader;
    private ClassLoader connectorClassLoader;
    static /* synthetic */ Class class$com$iplanet$ias$server$ServerContext;

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        ClassLoader classLoader;
        Object object;
        context = serverContext;
        ServerLogManager.reInitializeServerLoggers();
        this.printStartupInfo();
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        InstanceEnvironment instanceEnvironment = context.getInstanceEnvironment();
        try {
            object = instanceEnvironment.getLibClassesPath();
            String string = instanceEnvironment.getLibPath();
            this.commonClassLoader = ClassLoaderUtils.getClassLoader(new File[]{new File((String)object)}, new File[]{new File(string)}, classLoader2);
            if (this.commonClassLoader == null) {
                this.commonClassLoader = classLoader2;
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "server.ioexception", iOException);
            this.commonClassLoader = classLoader2;
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "server.exception", throwable);
            this.commonClassLoader = classLoader2;
        }
        this.connectorClassLoader = ConnectorClassLoader.getInstance(this.commonClassLoader);
        if (context instanceof ServerContextImpl) {
            object = (ServerContextImpl)context;
            ((ServerContextImpl)object).setCommonClassLoader(this.commonClassLoader);
            ((ServerContextImpl)object).setSharedClassLoader(this.connectorClassLoader);
            ((ServerContextImpl)object).setLifecycleParentClassLoader(this.connectorClassLoader);
        }
        object = this.commonClassLoader;
        AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object){
            private final /* synthetic */ ClassLoader val$commonCL;
            {
                this.val$commonCL = classLoader;
            }

            public Object run() {
                Thread.currentThread().setContextClassLoader(this.val$commonCL);
                return null;
            }
        });
        this.instantiateRuntimeServices();
        int n = 0;
        while (n < this.services.size()) {
            classLoader = this.services.get(n);
            if (classLoader instanceof ServerLifecycle) {
                ((ServerLifecycle)((Object)classLoader)).onInitialization(serverContext);
            }
            ++n;
        }
        J2EEServer.main(serverContext);
        classLoader = this.connectorClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    private void instantiateRuntimeServices() {
        int n = 0;
        while (n < servicesByName.length) {
            try {
                String[] stringArray = servicesByName[n];
                Class<?> clazz = Class.forName(stringArray[1]);
                Object obj = clazz.newInstance();
                this.services.add(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public void onStartup() throws ServerLifecycleException {
        int n = 0;
        while (n < this.services.size()) {
            Object e = this.services.get(n);
            if (e instanceof ServerLifecycle) {
                ((ServerLifecycle)e).onStartup(context);
            }
            ++n;
        }
    }

    public void onReady() throws ServerLifecycleException {
        Class<Object> clazz;
        try {
            AdminEventListenerRegistry.addResourceDeployEventListener(new ResourceManager(context));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ApplicationServer.this.commonClassLoader);
                    return null;
                }
            });
            String string = null;
            string = System.getProperty("com.iplanet.ias.server.startupHook");
            if (string != null) {
                try {
                    clazz = Class.forName(string);
                    Method method = clazz.getMethod("main", class$com$iplanet$ias$server$ServerContext == null ? (class$com$iplanet$ias$server$ServerContext = ApplicationServer.class$("com.iplanet.ias.server.ServerContext")) : class$com$iplanet$ias$server$ServerContext);
                    method.invoke(null, context);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            throw new ServerLifecycleException(exception);
        }
        int n = 0;
        while (n < this.services.size()) {
            clazz = this.services.get(n);
            if (clazz instanceof ServerLifecycle) {
                ((ServerLifecycle)((Object)clazz)).onReady(context);
            }
            ++n;
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        int n = this.services.size();
        while (n > 0) {
            Object e = this.services.get(n - 1);
            if (e instanceof ServerLifecycle) {
                ((ServerLifecycle)e).onShutdown();
            }
            --n;
        }
    }

    public void onTermination() throws ServerLifecycleException {
        int n = this.services.size();
        while (n > 0) {
            Object e = this.services.get(n - 1);
            if (e instanceof ServerLifecycle) {
                ((ServerLifecycle)e).onTermination();
            }
            --n;
        }
        this.services = null;
    }

    public static ServerContext getServerContext() {
        return context;
    }

    private void printStartupInfo() {
        _logger.log(Level.INFO, "j2eerunner.printstartinfo", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

