/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security.util;

import com.iplanet.ias.security.util.IASSecurityException;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Password {
    private static final int ROUNDS = 1000;
    private static final int SALT_SIZE = 8;
    private static final String PBE_ALGORITHM = "PBEWithMD5AndDES";
    private static final String B64_ALGORITHM = "Base64";
    private static final String SEPARATOR = ":";
    private static String currentKey = null;
    private static StringManager sm = StringManager.getManager("com.iplanet.ias.security.util");

    public static void setKey(String string) {
        currentKey = string;
    }

    public static boolean isKeySet() {
        return currentKey != null;
    }

    public static void resetKey() {
        currentKey = null;
    }

    public static String encrypt(String string) throws NoSuchAlgorithmException, IASSecurityException {
        if (string == null) {
            return null;
        }
        if (currentKey != null) {
            return Password.doEncrypt(string, currentKey);
        }
        return string;
    }

    public static String decrypt(String string) throws NoSuchAlgorithmException, IASSecurityException {
        if (string == null) {
            return null;
        }
        if (currentKey != null) {
            if (!string.startsWith(PBE_ALGORITHM)) {
                return string;
            }
            return Password.doDecrypt(string, currentKey);
        }
        return string;
    }

    private static String doDecrypt(String string, String string2) throws NoSuchAlgorithmException, IASSecurityException {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        String string4 = stringTokenizer.nextToken();
        if (!PBE_ALGORITHM.equals(string4)) {
            String string5 = sm.getString("password.badalgorithm", string4);
            throw new IASSecurityException(string5);
        }
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        if (string6 == null || string7 == null) {
            String string8 = sm.getString("password.badformat", string);
            throw new IASSecurityException(string8);
        }
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(string6);
            byte[] byArray2 = bASE64Decoder.decodeBuffer(string7);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_ALGORITHM);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 1000);
            Cipher cipher = Cipher.getInstance(PBE_ALGORITHM);
            cipher.init(2, (Key)secretKey, pBEParameterSpec);
            byte[] byArray3 = cipher.doFinal(byArray2);
            string3 = new String(byArray3);
        }
        catch (IOException iOException) {
            throw new IASSecurityException(iOException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IASSecurityException(invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IASSecurityException(illegalBlockSizeException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IASSecurityException(invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IASSecurityException(noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IASSecurityException(invalidAlgorithmParameterException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IASSecurityException(badPaddingException);
        }
        return string3;
    }

    private static String doEncrypt(String string, String string2) throws NoSuchAlgorithmException, IASSecurityException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        String string3 = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBE_ALGORITHM);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 1000);
            Cipher cipher = Cipher.getInstance(PBE_ALGORITHM);
            cipher.init(1, (Key)secretKey, pBEParameterSpec);
            byte[] byArray2 = cipher.doFinal(string.getBytes());
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            String string4 = bASE64Encoder.encode(byArray2);
            String string5 = bASE64Encoder.encode(byArray);
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append(PBE_ALGORITHM);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(string5);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(string4);
            string3 = stringBuffer.toString();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IASSecurityException(invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IASSecurityException(illegalBlockSizeException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IASSecurityException(invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new IASSecurityException(noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IASSecurityException(invalidAlgorithmParameterException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IASSecurityException(badPaddingException);
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        block11: {
            if (stringArray.length == 0) {
                Password.help();
            }
            try {
                if ("-e".equals(stringArray[0])) {
                    if (stringArray.length != 3) {
                        Password.help();
                    }
                    Password.setKey(stringArray[2]);
                    System.out.println(Password.encrypt(stringArray[1]));
                    break block11;
                }
                if ("-d".equals(stringArray[0])) {
                    if (stringArray.length != 3) {
                        Password.help();
                    }
                    Password.setKey(stringArray[2]);
                    System.out.println(Password.decrypt(stringArray[1]));
                    break block11;
                }
                if ("-b".equals(stringArray[0])) {
                    if (stringArray.length != 2) {
                        Password.help();
                    }
                    BASE64Encoder bASE64Encoder = new BASE64Encoder();
                    System.out.println(bASE64Encoder.encode(stringArray[1].getBytes()));
                    break block11;
                }
                if ("-u".equals(stringArray[0])) {
                    if (stringArray.length != 2) {
                        Password.help();
                    }
                    BASE64Decoder bASE64Decoder = new BASE64Decoder();
                    String string = new String(bASE64Decoder.decodeBuffer(stringArray[1]));
                    System.out.println(string);
                    break block11;
                }
                Password.help();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    private static void help() {
        System.out.println("args: -e plaintext key\n      -d ciphertext key\n      -b plaintext\n      -u b64encoded");
        System.exit(1);
    }
}

