/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.config.serverbeans.WebModule;
import com.iplanet.ias.deployment.WebBundleXmlReader;
import com.iplanet.ias.deployment.WebModuleConfigEnv;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.deployment.backend.ModuleInfo;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.instance.ModulesManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class WebModulesManager
extends ModulesManager {
    public WebModulesManager(InstanceEnvironment instanceEnvironment) throws ConfigException {
        super(instanceEnvironment, true);
    }

    public WebModulesManager(InstanceEnvironment instanceEnvironment, boolean bl) throws ConfigException {
        super(instanceEnvironment, bl);
        WebModule[] webModuleArray = ((Applications)this.configBean).getWebModule();
        if (webModuleArray != null) {
            int n = 0;
            while (n < webModuleArray.length) {
                webModuleArray[n].setConfigContext(this.configContext);
                webModuleArray[n].setXPath(ServerXPathHelper.getWebModuleIdXpathExpression(webModuleArray[n].getName()));
                ++n;
            }
        }
    }

    private WebModule getWebModule(String string) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(string);
        if (webModule == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_SUCH_WEB_MOD));
        }
        return webModule;
    }

    public WebModule[] listWebModules() throws ConfigException {
        return ((Applications)this.configBean).getWebModule();
    }

    public List listIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WebModule[] webModuleArray = ((Applications)this.configBean).getWebModule();
        if (webModuleArray == null) {
            return arrayList;
        }
        int n = 0;
        while (n < webModuleArray.length) {
            WebModule webModule = webModuleArray[n];
            arrayList.add(webModule.getName());
            ++n;
        }
        return arrayList;
    }

    public void remove(String string) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(string);
        ((Applications)this.configBean).removeWebModule(webModule);
    }

    protected boolean isRegistered(String string, ConfigBean configBean) {
        WebModule webModule = null;
        try {
            webModule = ((Applications)configBean).getWebModuleByName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webModule != null;
    }

    public boolean isEnabled(String string) throws ConfigException {
        return this.getWebModule(string).isEnabled();
    }

    public void setEnable(String string, boolean bl) throws ConfigException {
        this.getWebModule(string).setEnabled(bl);
    }

    public void setOptionalAttributes(String string, Properties properties) throws ConfigException {
        if (properties != null) {
            WebModule webModule = this.getWebModule(string);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                webModule.setAttributeValue(string2, string3);
            }
        }
    }

    public String getLocation(String string) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(string);
        String string2 = null;
        if (webModule != null) {
            string2 = webModule.getLocation();
        }
        return string2;
    }

    public void setLocation(String string, String string2) throws ConfigException {
        WebModule webModule = ((Applications)this.configBean).getWebModuleByName(string);
        if (webModule != null) {
            webModule.setLocation(string2);
        }
    }

    public String getJSPLocation(String string) {
        ModuleEnvironment moduleEnvironment = this.instanceEnvironment.getModuleEnvironment(string, DeployableObjectType.WEB);
        return moduleEnvironment.getModuleJSPPath();
    }

    public void register(DeployableObjectInfo deployableObjectInfo) throws ConfigException {
        if (!(deployableObjectInfo instanceof ModuleInfo)) {
            throw new ConfigException(Localizer.getValue(ExceptionType.BAD_WEB_MOD_INFO));
        }
        ModuleInfo moduleInfo = (ModuleInfo)deployableObjectInfo;
        this.regMod(moduleInfo, this.configContext, this.configBean);
    }

    private void regMod(ModuleInfo moduleInfo, ConfigContext configContext, ConfigBean configBean) throws ConfigException {
        if (moduleInfo == null || !moduleInfo.isWeb()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.WRONG_MOD_INFO));
        }
        WebModule webModule = new WebModule();
        webModule.setName(moduleInfo.getName());
        webModule.setLocation(moduleInfo.getRootPath().getAbsolutePath());
        boolean bl = this.isRegistered(moduleInfo.getName(), configBean);
        if (bl) {
            WebModule webModule2 = ((Applications)configBean).getWebModuleByName(moduleInfo.getName());
            ((Applications)configBean).removeWebModule(webModule2);
        }
        ((Applications)configBean).addWebModule(webModule);
        webModule.setConfigContext(this.configContext);
        webModule.setXPath(ServerXPathHelper.getWebModuleIdXpathExpression(webModule.getName()));
    }

    public String getDescription(String string) throws ConfigException {
        return this.getWebModule(string).getDescription();
    }

    public void setDescription(String string, String string2) throws ConfigException {
        this.getWebModule(string).setDescription(string2);
    }

    public String getVirtualServers(String string) throws ConfigException {
        return this.getWebModule(string).getVirtualServers();
    }

    public void setVirtualServers(String string, String string2) throws ConfigException {
        this.getWebModule(string).setVirtualServers(string2);
    }

    public String getContextRoot(String string) throws ConfigException {
        return this.getWebModule(string).getContextRoot();
    }

    public void setContextRoot(String string, String string2) throws ConfigException {
        this.getWebModule(string).setContextRoot(string2);
    }

    public WebBundleDescriptor getDescriptor(String string) throws ConfigException {
        return WebModulesManager.getDescriptor(string, this.getLocation(string));
    }

    public static WebBundleDescriptor getDescriptor(String string, String string2) throws ConfigException {
        return WebModulesManager.getDescriptor(string, string2, false, false);
    }

    public static WebBundleDescriptor getDescriptor(String string, String string2, boolean bl, boolean bl2) throws ConfigException {
        try {
            Set set;
            WebModuleConfigEnv webModuleConfigEnv = new WebModuleConfigEnv(new File(string2), string, bl);
            webModuleConfigEnv.setVerifying(bl2);
            Application application = WebBundleXmlReader.loadStdAloneModule(webModuleConfigEnv);
            WebBundleDescriptor webBundleDescriptor = null;
            if (application != null && (set = application.getWebBundleDescriptors()) != null && set.size() > 0) {
                webBundleDescriptor = (WebBundleDescriptor)set.iterator().next();
            }
            return webBundleDescriptor;
        }
        catch (IOException iOException) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, string), iOException);
        }
        catch (Throwable throwable) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, string), throwable);
        }
    }
}

