/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.ConnectorModule;
import com.iplanet.ias.config.serverbeans.JavaConfig;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.deployment.backend.DeployableObjectInfo;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseManager {
    protected ConfigContext configContext;
    protected ConfigBean configBean;
    protected InstanceEnvironment instanceEnvironment;
    protected boolean useBackupServerXml = true;
    private static Logger _logger;
    private static final String DEBUG_OPTION = "-g";
    private static final String OPTIMIZE_OPTION = "-O";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$instance$BaseManager;

    public BaseManager(InstanceEnvironment instanceEnvironment, boolean bl) throws ConfigException {
        this.instanceEnvironment = instanceEnvironment;
        try {
            this.useBackupServerXml = bl;
            String string = bl ? this.instanceEnvironment.getBackupConfigFilePath() : this.instanceEnvironment.getConfigFilePath();
            this.configContext = ConfigFactory.createConfigContext(string);
            this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
        }
        catch (Exception exception) {
            throw new ConfigException(Localizer.getValue(ExceptionType.MISSING_SERVER_NODE), exception);
        }
    }

    public boolean isByteCodePreprocessingEnabled() throws ConfigException {
        JavaConfig javaConfig;
        boolean bl = false;
        ConfigBean configBean = this.configContext.getRootConfigBean();
        if (configBean instanceof Server && (javaConfig = ((Server)configBean).getJavaConfig()) != null && javaConfig.getBytecodePreprocessors() != null) {
            bl = true;
        }
        return bl;
    }

    public String[] getBytecodeProcessorClassNames() throws ConfigException {
        JavaConfig javaConfig;
        String[] stringArray = null;
        ConfigBean configBean = this.configContext.getRootConfigBean();
        if (configBean instanceof Server && (javaConfig = ((Server)configBean).getJavaConfig()) != null) {
            String string = javaConfig.getBytecodePreprocessors();
            _logger.log(Level.INFO, "core.preprocessor_class_name", string);
            stringArray = string.split(",");
        }
        return stringArray;
    }

    public boolean isDynamicReloadEnabled() {
        return ((Applications)this.configBean).isDynamicReloadEnabled();
    }

    public long getReloadPollIntervalInMillis() {
        long l;
        String string = ((Applications)this.configBean).getDynamicReloadPollIntervalInSeconds();
        try {
            l = Long.parseLong(string) * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            Applications cfr_ignored_0 = (Applications)this.configBean;
            string = Applications.getDefaultDynamicReloadPollIntervalInSeconds();
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException2) {
                l = 2000L;
            }
        }
        return l;
    }

    public List getSystemCPathPrefixNSuffix() throws ConfigException {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String string = javaConfig.getClasspathPrefix();
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = javaConfig.getClasspathSuffix()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public List getSystemClasspath() throws ConfigException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String string = javaConfig.getClasspathPrefix();
        if (string != null) {
            object2 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object2).nextToken());
            }
        }
        if ((object2 = javaConfig.getServerClasspath()) != null) {
            object = new StringTokenizer((String)object2, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = javaConfig.getClasspathSuffix()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public List getSharedClasspath() throws ConfigException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ConnectorModule[] connectorModuleArray = ((Applications)this.configBean).getConnectorModule();
        if (connectorModuleArray != null) {
            int n = 0;
            while (n < connectorModuleArray.length) {
                arrayList.add(connectorModuleArray[n].getLocation());
                ++n;
            }
        }
        return arrayList;
    }

    public List getRmicOptions() throws ConfigException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String string = javaConfig.getRmicOptions();
        if (string == null) {
            string = javaConfig.getDefaultRmicOptions();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
            _logger.log(Level.FINE, "Detected Rmic option: " + string2);
        }
        return arrayList;
    }

    public List getJavacOptions() throws ConfigException {
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        String string = javaConfig.getJavacOptions();
        if (string == null) {
            string = javaConfig.getDefaultJavacOptions();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(DEBUG_OPTION) || string2.startsWith(OPTIMIZE_OPTION)) {
                arrayList.add(string2);
                continue;
            }
            _logger.log(Level.WARNING, "core.unsupported_javac_option", string2);
        }
        return arrayList;
    }

    public boolean isEnvClasspathIgnored() throws ConfigException {
        JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_JAVACONFIG);
        return javaConfig.isEnvClasspathIgnored();
    }

    public final boolean isIASOwned(String string) {
        if (!$assertionsDisabled && this.instanceEnvironment == null) {
            throw new AssertionError();
        }
        try {
            return this.instanceEnvironment.isIASOwned(this.getLocation(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void refreshConfigContext(ConfigContext configContext) throws ConfigException {
        this.configContext = configContext;
        this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
    }

    public void refreshConfigContext() throws ConfigException {
        this.configContext.refresh(true);
        this.configBean = ConfigBeansFactory.getConfigBeanByXPath(this.configContext, ServerXPathHelper.XPATH_APPLICATIONS);
    }

    public InstanceEnvironment getInstanceEnvironment() {
        return this.instanceEnvironment;
    }

    public boolean isShared(String string) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "isShared()"));
    }

    public void setShared(String string, boolean bl) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "setShared()"));
    }

    public String getStubLocation(String string) {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "getStubLocation()"));
    }

    public boolean isRegistered(String string) {
        return this.isRegistered(string, this.configBean);
    }

    public void saveConfigContext() throws ConfigException {
        if (!this.useBackupServerXml) {
            throw new ConfigException(Localizer.getValue(ExceptionType.CANT_APPLY));
        }
        this.configContext.flush();
    }

    public void applyServerXmlChanges() throws ConfigException {
        if (!this.useBackupServerXml) {
            throw new ConfigException(Localizer.getValue(ExceptionType.CANT_APPLY));
        }
        this.configContext.flush();
        this.instanceEnvironment.applyServerXmlChanges(false);
    }

    public String getContextRoot(String string) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "getContextRoot()"));
    }

    public void setContextRoot(String string, String string2) throws ConfigException {
        throw new UnsupportedOperationException(Localizer.getValue(ExceptionType.UNSUPPORTED, "setContextRoot()"));
    }

    public abstract String getLocation(String var1) throws ConfigException;

    public abstract void setLocation(String var1, String var2) throws ConfigException;

    public abstract boolean isEnabled(String var1) throws ConfigException;

    public abstract void setEnable(String var1, boolean var2) throws ConfigException;

    public abstract void setOptionalAttributes(String var1, Properties var2) throws ConfigException;

    public abstract String getDescription(String var1) throws ConfigException;

    public abstract void setDescription(String var1, String var2) throws ConfigException;

    protected abstract boolean isRegistered(String var1, ConfigBean var2);

    public abstract void remove(String var1) throws ConfigException;

    public abstract void register(DeployableObjectInfo var1) throws ConfigException;

    public abstract List listIds() throws ConfigException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$instance$BaseManager == null ? (class$com$iplanet$ias$instance$BaseManager = BaseManager.class$("com.iplanet.ias.instance.BaseManager")) : class$com$iplanet$ias$instance$BaseManager).desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

