/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.installer.dialogs;

import com.iplanet.install.panels.common.DirectorySelectionPanelBase;
import com.iplanet.install.panels.common.SetupSDKPanelBase;
import com.iplanet.install.util.QandA;
import com.iplanet.install.util.wbResource;
import com.sun.wizards.awt.ColumnLayout;
import com.sun.wizards.awt.FlowLabel;
import com.sun.wizards.awt.HeaderPanel;
import com.sun.wizards.awt.VerticalLayout;
import com.sun.wizards.core.ArchiveReader;
import com.sun.wizards.core.Msg;
import com.sun.wizards.core.Route;
import com.sun.wizards.core.TTYDisplay;
import com.sun.wizards.core.WizardLeaf;
import com.sun.wizards.core.WizardState;
import com.sun.wizards.core.WizardTreeManager;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class VarDirectorySelectionPanel
extends DirectorySelectionPanelBase {
    protected Panel textPanel = null;
    protected Msg headerText = null;
    protected Msg descriptionText = null;
    protected Msg labelText = null;
    protected Button browseButton = null;
    protected FlowLabel dirSelectionLabel = null;
    protected transient String dirSelection = null;
    protected JFileChooser fc = null;
    protected JTextField baseDirectoryField = null;

    public VarDirectorySelectionPanel() {
    }

    public VarDirectorySelectionPanel(WizardState wizardState, String string) {
        super(wizardState, string);
        this.setKeyValues(wizardState);
    }

    public VarDirectorySelectionPanel(String string, Route route, WizardTreeManager wizardTreeManager) {
        super(string, route, wizardTreeManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseButton) {
            this.browseButtonPressed();
        }
    }

    public void addCriticalStateKeys(Vector vector) {
        super.addCriticalStateKeys(vector);
        vector.addElement(this.defaultKey);
        vector.addElement(this.currentKey);
        vector.addElement("DOMAINS_DIR");
    }

    public void addDescriptionText(Msg msg) {
        this.descriptionText = msg;
    }

    public void addHeaderText(Msg msg) {
        this.headerText = msg;
    }

    public void addLabelText(Msg msg) {
        this.labelText = msg;
    }

    public void addRuntimeResources(Vector vector) {
        super.addRuntimeResources(vector);
        vector.addElement("com.iplanet.ias.installer.dialogs.VarDirectorySelectionPanel");
        vector.addElement("com.iplanet.install.panels.common.DirectorySelectionPanelBase");
    }

    protected void browseButtonPressed() {
        String string = null;
        try {
            String string2;
            string = this.baseDirectoryField.getText();
            if (string != null && string.length() > 0) {
                while (!this.fileExists(string)) {
                    string = this.getParentDirectory(string);
                    if (!System.getProperty("os.name").startsWith("Windows") || this.fileExists(string) || !this.getParentDirectory(string).equals(string)) continue;
                    string2 = ArchiveReader.systemInterface.getStandardInstallDirectory();
                    while (!string2.equals(this.getParentDirectory(string2))) {
                        string2 = this.getParentDirectory(string2);
                    }
                    string = string2;
                }
            }
            this.initDirBrowser(string);
            string2 = this.showDirBrowser();
            if (string2 != null && !string2.equals(this.baseDirectoryField.getText())) {
                this.baseDirectoryField.setText(string2);
            }
        }
        catch (Exception exception) {
            String string3 = "Unable to browse filesystem \"" + string + "\"";
            ((SetupSDKPanelBase)this).debug.error(string3);
            this.logEvent(string3);
        }
    }

    public void consoleInteraction() {
        Object[] objectArray = new Object[]{this.getProductName()};
        TTYDisplay.showNewline();
        TTYDisplay.showText((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction"), (Object[])objectArray));
        TTYDisplay.showNewline();
        TTYDisplay.setNavEnabled((boolean)true);
        String string = ((String)this.getData(this.currentKey)).trim();
        this.dirSelection = TTYDisplay.queryValue((String)wbResource.getString((String)(String.valueOf(this.getName()) + "-ConsoleInteraction-DirectorySelectionQuestion"), (Object[])objectArray), (String)string, null);
        if (this.dirSelection != null && this.dirSelection.equals(TTYDisplay.backOption)) {
            this.dirSelection = null;
            this.getTreeManager().backButtonPressed();
            return;
        }
        if (this.dirSelection != null) {
            this.dirSelection = this.dirSelection.trim();
        }
    }

    public void createUI() {
        super.createUI();
        if (!this.isGUIInstall()) {
            return;
        }
        HeaderPanel headerPanel = this.getHeaderPanel();
        if (headerPanel != null) {
            if (this.headerText != null) {
                headerPanel.setText(this.headerText.getString());
            } else {
                headerPanel.setText(wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-HeaderText")));
            }
            headerPanel.setInsets(new Insets(12, 10, 12, 10));
        }
        this.setTextPanel();
        ((Container)((Object)this)).add(this.textPanel, "Center");
    }

    protected void deserialize(DataInput dataInput) {
        super.deserialize(dataInput);
        try {
            this.defaultKey = dataInput.readUTF();
            this.currentKey = dataInput.readUTF();
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)((Object)dataInput));
            this.descriptionText = (Msg)objectInputStream.readObject();
            this.labelText = (Msg)objectInputStream.readObject();
            this.headerText = (Msg)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            ((SetupSDKPanelBase)this).debug.error("deserialize: Error deserializing panel: " + iOException.toString());
            this.exit_serialization();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((SetupSDKPanelBase)this).debug.error("deserialize: Error deserializing DirectorySelectionPanel: " + classNotFoundException.toString());
            this.exit_serialization();
        }
    }

    public int getButtonMask() {
        return WizardLeaf.BACK_BUTTON | WizardLeaf.NEXT_BUTTON | WizardLeaf.EXIT_BUTTON;
    }

    protected void initDirBrowser(String string) {
        String string2 = wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-HeaderText"));
        this.fc = new JFileChooser(string);
        this.fc.setFileSelectionMode(1);
        this.fc.setMultiSelectionEnabled(false);
    }

    public boolean isDisplayComplete() {
        int n;
        String string;
        String string2;
        block15: {
            if (this.isGUIInstall()) {
                this.dirSelection = this.baseDirectoryField.getText().trim();
            }
            string2 = String.valueOf(this.dirSelection) + "/domains";
            if (System.getProperty("wizard.statefile") == null) {
                this.setData(this.currentKey, this.dirSelection);
                this.setData("DOMAINS_DIR", string2);
            }
            if (!super.isDisplayComplete()) {
                return false;
            }
            if (System.getProperty("wizard.statefile") != null) {
                return true;
            }
            if (this.dirSelection == null || this.dirSelection.trim().equals("")) {
                return false;
            }
            string = this.getAbsolutePath(this.dirSelection);
            Object[] objectArray = new Object[]{this.dirSelection};
            try {
                n = this.fileExists(this.dirSelection);
                if (n == 0) {
                    int n2;
                    if (((SetupSDKPanelBase)this).debug.validate() && ((n2 = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA1-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA1-Message"), (Object[])new Object[]{string}), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA1-CreateDirectoryButton")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA1-ChooseNewButton")))) == -1 || n2 == 2)) {
                        return false;
                    }
                    this.createDirectory(this.dirSelection);
                    if (!this.fileExists(this.dirSelection)) {
                        this.logEvent("Could not create directory: \"" + this.dirSelection + "\"");
                        if (((SetupSDKPanelBase)this).debug.validate() && ((n2 = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-Message"), (Object[])new Object[]{string}), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-ChooseNewButton")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-AcceptButton")))) == -1 || n2 == 1)) {
                            return false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.logEvent("Could not create directory: \"" + this.dirSelection + "\"");
                if (!((SetupSDKPanelBase)this).debug.validate() || (n = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-Message"), (Object[])new Object[]{string}), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-ChooseNewButton")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA2-AcceptButton")))) != -1 && n != 1) break block15;
                return false;
            }
        }
        if (!this.isWritable(this.dirSelection)) {
            this.logEvent("Could not gain write access to directory: \"" + this.dirSelection + "\"");
            if (((SetupSDKPanelBase)this).debug.validate() && ((n = QandA.twoButtons((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-Title")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-Message"), (Object[])new Object[]{string}), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-ChooseNewButton")), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA3-AcceptButton")))) == -1 || n == 1)) {
                return false;
            }
        }
        if (this.checkOldComponentInfo(this.dirSelection)) {
            String string3 = (String)this.getWizardState().getData("oldProductName");
            String string4 = (String)this.getWizardState().getData("oldProductVersion");
            String string5 = (String)this.getWizardState().getData("oldComponentsDesc");
            String string6 = null;
            string6 = this.isGUIInstall() ? wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA4-Message2")) : wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA4-Message2-ConsoleInteraction"));
            this.logEvent("Previously installed iPlanet product in installation directory");
            if (((SetupSDKPanelBase)this).debug.validate()) {
                QandA.oneButton((WizardTreeManager)this.getTreeManager(), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA4-Title")), (String)(String.valueOf(wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA4-Message1"))) + "\n" + "Name: " + string3 + "\n" + "Version: " + string4 + "\n" + string5 + "\n\n" + string6), (String)wbResource.getString((String)(String.valueOf(this.getName()) + "-QandA4-AcceptButton")));
            }
        }
        this.setData(this.currentKey, string);
        this.setData("DOMAINS_DIR", string2);
        return true;
    }

    public void reset(Object object) {
        String string = ((String)this.getData(this.defaultKey)).trim();
        this.setData(this.currentKey, string);
        this.setDirectory();
    }

    protected void serialize(DataOutput dataOutput) {
        super.serialize(dataOutput);
        try {
            dataOutput.writeUTF(this.defaultKey);
            dataOutput.writeUTF(this.currentKey);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)((Object)dataOutput));
            objectOutputStream.writeObject(this.descriptionText);
            objectOutputStream.writeObject(this.labelText);
            objectOutputStream.writeObject(this.headerText);
        }
        catch (IOException iOException) {
            ((SetupSDKPanelBase)this).debug.error(String.valueOf(((Object)((Object)this)).getClass().getName()) + "::serialize: Error serializing panel: " + iOException.toString());
            this.exit_serialization();
        }
    }

    public String setDirectory() {
        WizardTreeManager wizardTreeManager = this.getTreeManager();
        if (this.baseDirectoryField != null) {
            String string = ((String)this.getData(this.currentKey)).trim();
            if (string == null || string.length() == 0 || string.startsWith("null")) {
                return null;
            }
            Object object = this.getData("separatorCharacter");
            char c = '/';
            if (object != null && object instanceof Character) {
                c = ((Character)object).charValue();
            }
            string = string.replace('/', c);
            int n = -1;
            while ((n = string.indexOf(new String(new char[]{c, c}))) != -1) {
                string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
            }
            if (string.length() > File.separator.length() && string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - File.separator.length());
            }
            if (this.baseDirectoryField != null) {
                this.baseDirectoryField.setText(string);
            }
            return string;
        }
        return null;
    }

    protected void setKeyValues(WizardState wizardState) {
        this.defaultKey = "AS_INSTALL_DEFAULT_VAR_DIR";
        this.currentKey = "AS_INSTALL_VAR_DIR";
    }

    protected void setTextPanel() {
        Object[] objectArray = new Object[]{this.getProductName()};
        this.textPanel = new Panel((LayoutManager)new VerticalLayout());
        FlowLabel flowLabel = new FlowLabel(wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-IntroText")));
        Panel panel = new Panel((LayoutManager)new ColumnLayout());
        panel.add((Component)flowLabel);
        this.dirSelectionLabel = new FlowLabel(this.labelText != null ? this.labelText.getString() : wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-DirectorySelectionLabel"), (Object[])objectArray));
        panel.add((Component)this.dirSelectionLabel);
        Panel panel2 = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.baseDirectoryField = new JTextField("", 30);
        panel2.add((Component)this.baseDirectoryField, gridBagConstraints);
        String string = this.setDirectory();
        this.browseButton = new Button(wbResource.getString((String)(String.valueOf(this.getName()) + "-Gui-BrowseButton")));
        gridBagConstraints.gridwidth = 0;
        panel2.add((Component)this.browseButton, gridBagConstraints);
        panel.add(panel2);
        this.textPanel.add((Component)panel, "0");
        this.browseButton.addActionListener((ActionListener)((Object)this));
    }

    protected String showDirBrowser() {
        Frame frame = this.getFrame();
        int n = this.fc.showOpenDialog(frame);
        if (n == 0) {
            return this.fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public boolean skip() {
        if (super.skip()) {
            return true;
        }
        ((SetupSDKPanelBase)this).debug = this.getDebugObject();
        Vector vector = (Vector)this.getWizardState().getData("selectedComponents");
        return this.isStringInVector(wbResource.getString((String)"coreComponentName"), vector) ^ true;
    }
}

