/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DeploymentUtils;
import com.iplanet.ias.deployment.backend.EJBCompiler;
import com.iplanet.ias.deployment.backend.EjbModuleInfo;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.JarExploder;
import com.iplanet.ias.deployment.backend.ModuleDeployer;
import com.iplanet.ias.ejb.codegen.IASEJBCTimes;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.EjbModulesManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import java.util.logging.Level;

public class EjbModuleDeployer
extends ModuleDeployer {
    private EjbModulesManager manager = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$EjbModuleDeployer;

    EjbModuleDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception exception) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected boolean needsStubs() {
        return true;
    }

    protected BaseManager createConfigManager(InstanceEnvironment instanceEnvironment, ModuleEnvironment moduleEnvironment) throws IASDeploymentException, ConfigException {
        this.manager = new EjbModulesManager(instanceEnvironment);
        return this.manager;
    }

    protected void preDeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && this.stubsDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleName == null) {
            throw new AssertionError();
        }
        try {
            if (this.isRegistered()) {
                String string = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(string);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new EjbModuleInfo(this.moduleDir, this.moduleName);
            } else {
                JarExploder jarExploder = new JarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = jarExploder.explode();
            }
            this.register();
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception.toString(), exception);
        }
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        ZipItem[] zipItemArray = this.runEJBC();
        this.createClientJar(zipItemArray);
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        if (!this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(string);
        }
        if (!$assertionsDisabled && this.stubsDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.moduleName == null) {
            throw new AssertionError();
        }
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new EjbModuleInfo(this.moduleDir, this.moduleName);
        } else {
            try {
                JarExploder jarExploder = new JarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = jarExploder.explode();
            }
            catch (ZipFileException zipFileException) {
                throw new IASDeploymentException(zipFileException.toString(), zipFileException);
            }
        }
        this.redeployRegister();
    }

    protected void postRedeploy() throws IASDeploymentException, ConfigException {
        this.updateOptionalParamForRedeploy();
        this.locationChangeWasRegisteredCold = true;
        this.saveHotConfigRedeploy();
        this.backupFiles();
        if (this.oldStubsDir != null) {
            FileUtils.whack(this.oldStubsDir);
        }
    }

    protected void rollbackRedeploy() throws IASDeploymentException {
        if (this.isArchive() && FileUtils.safeIsDirectory(this.moduleDir)) {
            FileUtils.whack(this.moduleDir);
        }
        this.rollbackRedeployRegister();
        this.DeleteOrKeepFailedStubs(this.stubsDir);
        if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
            this.oldStubsDir.renameTo(this.stubsDir);
        }
    }

    protected void register() throws IASDeploymentException, ConfigException {
        super.register();
        this.setShared(this.request.isSharedModule());
    }

    protected final String whatTypeAmI() {
        return "EJB Module";
    }

    private ZipItem[] runEJBC() throws IASDeploymentException {
        ZipItem[] zipItemArray = null;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            DeploymentUtils.setParentClassLoader(classLoader, this.manager, this.request);
            IASEJBCTimes iASEJBCTimes = new IASEJBCTimes();
            EJBCompiler eJBCompiler = new EJBCompiler(this.moduleName, this.moduleDir, this.oldModuleDir, this.clientJar, this.stubsDir, this.oldStubsDir, this.manager, this.request, iASEJBCTimes);
            zipItemArray = eJBCompiler.compile();
            this.addEJBCTime(iASEJBCTimes);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "enterprise.deployment_ejbc_error", exception);
            String string = localStrings.getString("enterprise.deployment.backend.ejbc_error");
            throw new IASDeploymentException(string, exception);
        }
        return zipItemArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$EjbModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$EjbModuleDeployer = EjbModuleDeployer.class$("com.iplanet.ias.deployment.backend.EjbModuleDeployer")) : class$com$iplanet$ias$deployment$backend$EjbModuleDeployer).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$EjbModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$EjbModuleDeployer = EjbModuleDeployer.class$("com.iplanet.ias.deployment.backend.EjbModuleDeployer")) : class$com$iplanet$ias$deployment$backend$EjbModuleDeployer);
    }
}

