/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import com.sun.enterprise.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ClientJarArchivist
implements DescriptorConstants {
    private File archive = null;
    private File clientJar = null;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$ClientJarArchivist == null ? (class$com$iplanet$ias$deployment$ClientJarArchivist = ClientJarArchivist.class$("com.iplanet.ias.deployment.ClientJarArchivist")) : class$com$iplanet$ias$deployment$ClientJarArchivist);
    private static final String TMP_JAR_PREFIX = "client-archivist";
    private static final boolean debug = false;
    private static final Logger _logger = DeploymentLogger.get();
    static /* synthetic */ Class class$com$iplanet$ias$deployment$ClientJarArchivist;

    public ClientJarArchivist(File file, File file2) {
        this.archive = file;
        this.clientJar = file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createClientJar(ZipItem[] zipItemArray) throws IOException, ZipFileException {
        boolean bl;
        if (!this.clientJar.exists() && (bl = this.clientJar.getParentFile().mkdirs())) {
            String string = localStrings.getString("enterprise.deployment.error_creating_client_jar", this.clientJar.getPath());
            throw new IOException(string);
        }
        JarFile jarFile = new JarFile(this.archive);
        ZipOutputStream zipOutputStream = this.getZipOutputStream(this.clientJar);
        int n = 0;
        while (n < zipItemArray.length) {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                String string = zipItemArray[n].getName();
                File file = zipItemArray[n].getFile();
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                zipOutputStream.putNextEntry(new ZipEntry(string));
                FileUtils.copyWithoutClose(bufferedInputStream, zipOutputStream);
            }
            catch (ZipException zipException) {
            }
            finally {
                if (zipOutputStream != null) {
                    zipOutputStream.closeEntry();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            ++n;
        }
        this.makeClientJar(jarFile, zipOutputStream);
        zipOutputStream.close();
    }

    private void makeClientJar(JarFile jarFile, ZipOutputStream zipOutputStream) throws IOException, ZipFileException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (string == null || string.endsWith(".war") || string.endsWith(".rar") || zipEntry.getSize() <= 0L) continue;
            this.addJarEntry(jarFile, zipEntry, zipOutputStream);
            if (!string.endsWith(".jar")) continue;
            File file = File.createTempFile(TMP_JAR_PREFIX, ".jar", FileUtil.getTempDirectory());
            ZipFile.extractJar(string, jarFile, file);
            this.makeClientJar(new JarFile(file), zipOutputStream);
            file.delete();
        }
    }

    private void addJarEntry(JarFile jarFile, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        try {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            ZipEntry zipEntry2 = new ZipEntry(zipEntry);
            zipEntry2.setCompressedSize(-1L);
            zipOutputStream.putNextEntry(zipEntry2);
            FileUtils.copyWithoutClose(inputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (ZipException zipException) {}
    }

    private ZipOutputStream getZipOutputStream(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        return zipOutputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

