/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.connectors.deployment;

import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.Util;
import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.iplanet.ias.connectors.util.xml.TagHandlerException;
import com.iplanet.ias.connectors.util.xml.TagProcessorHandler;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IASConnectorDescriptor {
    String iASDirectory;
    String iASRaName;
    String jndiName;
    InstancePropertiesObject ipo;
    ConnectorDeploymentObject cdo;
    final String raXML = Util.fileseparator + "META-INF" + Util.fileseparator + "ra.xml";
    final String sunRaXML = Util.fileseparator + "META-INF" + Util.fileseparator + "sun-ra.xml";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$connectors$deployment$IASConnectorDescriptor == null ? (class$com$iplanet$ias$connectors$deployment$IASConnectorDescriptor = IASConnectorDescriptor.class$("com.iplanet.ias.connectors.deployment.IASConnectorDescriptor")) : class$com$iplanet$ias$connectors$deployment$IASConnectorDescriptor);
    static /* synthetic */ Class class$com$iplanet$ias$connectors$deployment$IASConnectorDescriptor;

    public IASConnectorDescriptor(String string, String string2) throws IASDeploymentException {
        String string3 = string + this.raXML;
        String string4 = string + this.sunRaXML;
        _logger.log(Level.FINE, "**** in start of IASConnectorDescriptor");
        this.iASDirectory = string;
        this.iASRaName = string2;
        this.checkFileValidation(string3);
        this.checkFileValidation(string4);
        try {
            TagProcessorHandler tagProcessorHandler = new TagProcessorHandler();
            this.cdo = tagProcessorHandler.getConnectorDeploymentObject(string3);
            this.cdo.addJarName(string);
            this.ipo = tagProcessorHandler.getInstancePropertiesObject(string4);
            this.ipo.setRaName(string2);
            this.ipo.setXmlLocation(string4);
        }
        catch (TagHandlerException tagHandlerException) {
            _logger.log(Level.WARNING, "Failed to create  TagProcessorHandler()", tagHandlerException);
            throw new IASDeploymentException(tagHandlerException.getMessage());
        }
        this.jndiName = this.ipo.getJndiName();
        this.cdo.addInstanceName(this.jndiName);
        _logger.log(Level.FINE, "in end of IASConnectorDescriptor");
    }

    public String getIASDirectory() {
        return this.iASDirectory;
    }

    public String getIASRaName() {
        return this.iASRaName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public InstancePropertiesObject getInstancePropertiesObject() {
        return this.ipo;
    }

    public ConnectorDeploymentObject getConnectorDeploymentObject() {
        return this.cdo;
    }

    public void verify() throws IASDeploymentException {
        this.cdo.verify();
        this.ipo.verify();
    }

    private void checkFileValidation(String string) throws IASDeploymentException {
        File file = new File(string);
        if (!file.exists()) {
            _logger.log(Level.FINE, "File " + string + " does not exist");
            String string2 = localStrings.getString("connectors.deployment.FILE_DOES_NOT_EXIST", string);
            throw new IASDeploymentException(string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

