/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.ssl;

import com.iplanet.ias.cis.channel.ChannelException;
import com.iplanet.ias.cis.channel.ssl.CipherUtils;
import com.iplanet.ias.cis.channel.tcp.TCPBlockingChannel;
import com.iplanet.ias.cis.connection.EndPoint;
import com.iplanet.ias.cis.connection.HandshakeNotCompletedException;
import com.iplanet.ias.cis.connection.SSLSession;

public class SSLBlockingChannel
extends TCPBlockingChannel {
    private String localCertname;
    private String peerCertname;
    private boolean clientAuth = false;
    private int sockData;
    private boolean handshakeCompleted = false;
    private SSLSession status;
    private int sslVersion = 0;
    private String[] ssl2Ciphers = null;
    private String[] ssl3Ciphers = null;
    private boolean tlsRollback = false;

    public SSLBlockingChannel(EndPoint endPoint, EndPoint endPoint2, String string, int n, String[] stringArray, String[] stringArray2, boolean bl) throws ChannelException {
        this.localCertname = string;
        this.type = endPoint2.getType();
        this.sslVersion = n;
        this.ssl2Ciphers = stringArray;
        this.ssl3Ciphers = stringArray2;
        this.tlsRollback = bl;
        if (endPoint2 != null || endPoint != null) {
            this.doConnect(endPoint, endPoint2);
        }
    }

    protected SSLBlockingChannel(String string, boolean bl, String string2, int n, String[] stringArray, String[] stringArray2, boolean bl2) throws ChannelException {
        this.localCertname = string;
        this.clientAuth = bl;
        this.type = string2;
        this.sslVersion = n;
        this.ssl2Ciphers = stringArray;
        this.ssl3Ciphers = stringArray2;
        this.tlsRollback = bl2;
    }

    public SSLSession getSSLSession() throws ChannelException, HandshakeNotCompletedException {
        if (!this.handshakeCompleted) {
            throw new HandshakeNotCompletedException();
        }
        if (this.status == null) {
            this.status = this.getSSLSessionNative();
        }
        return this.status;
    }

    public void close() throws ChannelException {
        this.doClose();
    }

    private void doConnect(EndPoint endPoint, EndPoint endPoint2) throws ChannelException {
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        string = endPoint2.getHostIP();
        n = endPoint2.getPort();
        bl = endPoint2.isIPv6();
        if (endPoint != null) {
            string2 = endPoint.getHostIP();
            n2 = endPoint.getPort();
            bl2 = endPoint.isIPv6();
        }
        this.connectNative(string2, n2, bl2, string, n, bl, this.localCertname, this.sslVersion, CipherUtils.getSsl2CipherIDs(this.ssl2Ciphers), CipherUtils.getSsl3CipherIDs(this.ssl3Ciphers), this.tlsRollback);
        if (endPoint != null && n2 == 0) {
            endPoint.updatePort(this.updatedPort);
        }
    }

    private void doClose() throws ChannelException {
        super.close();
        this.closeNative();
    }

    private static native void initNative();

    private native void connectNative(String var1, int var2, boolean var3, String var4, int var5, boolean var6, String var7, int var8, int[] var9, int[] var10, boolean var11) throws ChannelException;

    private native SSLSession getSSLSessionNative() throws ChannelException;

    private native void closeNative() throws ChannelException;

    static {
        System.loadLibrary("cis");
        SSLBlockingChannel.initNative();
    }
}

