/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.ByteChunk;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.ObjectNameHelper;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistry;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyExistsException;
import com.iplanet.ias.admin.common.exception.NoSuchInstanceException;
import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.admin.server.core.mbean.config.AdminBase;
import com.iplanet.ias.admin.server.core.mbean.config.ShutdownThread;
import com.iplanet.ias.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigBeansFactory;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.JavaConfig;
import com.iplanet.ias.config.serverbeans.JmsService;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.instance.InstanceDefinition;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.jms.IASJmsUtil;
import com.iplanet.ias.license.LicenseBase;
import com.iplanet.ias.license.LicenseManager;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.appserv.server.util.Version;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ServerController
extends AdminBase {
    private Hashtable mStreamTable = new Hashtable();
    private static final Logger sLogger;
    private static StringManager localStrings;
    static String[] mAttrs;
    static String[] mOpers;
    private Lock lock;
    private DownloadInfo downloadInfo;
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ServerController;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void createServerInstance(String string, HostAndPort hostAndPort, String string2, boolean bl) throws InstanceAlreadyExistsException, ControlException {
        if (this.isBadInstanceName(string)) {
            String string3 = localStrings.getString("admin.server.core.mbean.bad_instance_name", string);
            throw new ControlException(string3);
        }
        ObjectName objectName = ObjectNames.getServerInstanceObjectName((String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                InstanceDefinition instanceDefinition = new InstanceDefinition(string, hostAndPort.getPort());
                if (string2 != null) {
                    instanceDefinition.setUser(string2);
                }
                ServerManager.instance().createServerInstance(instanceDefinition);
                sLogger.log(Level.INFO, "mbean.created_instance", string);
            }
            catch (Exception exception) {
                sLogger.log(Level.WARNING, "mbean.create_instance_failed", exception);
                throw new ControlException(exception.getMessage());
            }
        } else {
            String string4 = localStrings.getString("admin.server.core.mbean.config.instance_already_exists", string);
            throw new InstanceAlreadyExistsException(string4);
        }
    }

    public void createServerInstance(HostAndPort hostAndPort, String string, String string2, String string3, String string4, int n, String string5, String string6, boolean bl) throws InstanceAlreadyExistsException, ControlException {
        if (this.isBadInstanceName(string)) {
            String string7 = localStrings.getString("admin.server.core.mbean.bad_instance_name");
            throw new ControlException(string7);
        }
        ArgChecker.checkValid((Object)hostAndPort, (String)"hostport");
        ArgChecker.checkValid((Object)string, (String)"instanceName", (Validator)StringValidator.getInstance());
        ObjectName objectName = ObjectNames.getServerInstanceObjectName((String)string);
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        if (!mBeanServer.isRegistered(objectName)) {
            try {
                InstanceDefinition instanceDefinition = new InstanceDefinition(hostAndPort.getHost(), hostAndPort.getPort(), string, string2, string3, string4, n, string5, string6);
                ServerManager.instance().createServerInstance(instanceDefinition);
                sLogger.log(Level.INFO, "mbean.created_instance", string);
            }
            catch (Exception exception) {
                sLogger.log(Level.WARNING, "mbean.create_instance_failed", exception);
                throw new ControlException(exception.getMessage());
            }
        } else {
            throw new InstanceAlreadyExistsException(string);
        }
    }

    public void deleteServerInstance(String string) throws NoSuchInstanceException, ControlException {
        if (string == null) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.null_name");
            throw new IllegalArgumentException(string2);
        }
        ServerManager serverManager = ServerManager.instance();
        if (!serverManager.instanceExists(string)) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.instance_does_not_exist", string);
            throw new ControlException(string3);
        }
        boolean bl = false;
        RMIClient rMIClient = AdminChannel.getRMIClient(string);
        bl = rMIClient.isAlive();
        if (bl) {
            String string4 = localStrings.getString("admin.server.core.mbean.config.delete_alive_instance", string);
            throw new ControlException(string4);
        }
        this.deleteJMSProviderInstance(string);
        try {
            MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
            ObjectName[] objectNameArray = ObjectNameHelper.getInstanceRelatedMBeans((MBeanServer)mBeanServer, (String)string);
            int n = 0;
            while (n < objectNameArray.length) {
                try {
                    mBeanServer.unregisterMBean(objectNameArray[n]);
                }
                catch (Exception exception) {
                    sLogger.log(Level.CONFIG, "delete_unregistration_failed", objectNameArray[n]);
                }
                ++n;
            }
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
            String string5 = instanceEnvironment.getBackupConfigFilePath();
            ConfigFactory.removeConfigContext(string5);
            serverManager.deleteServerInstance(string);
            sLogger.log(Level.INFO, "mbean.del_instance_ok", string);
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.del_instance_failed", exception);
            throw new ControlException(exception.getMessage());
        }
    }

    private void deleteJMSProviderInstance(String string) {
        try {
            InstanceEnvironment instanceEnvironment = new InstanceEnvironment(string);
            String string2 = instanceEnvironment.getConfigFilePath();
            ConfigContext configContext = ConfigFactory.createConfigContext(string2);
            JmsService jmsService = (JmsService)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JMS_SERVICE);
            if (jmsService != null && jmsService.isEnabled()) {
                JMSAdmin jMSAdmin = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String[] stringArray = new String[2];
                JavaConfig javaConfig = (JavaConfig)ConfigBeansFactory.getConfigBeanByXPath(configContext, ServerXPathHelper.XPATH_JAVACONFIG);
                string3 = javaConfig.getJavaHome();
                string6 = System.getProperty("com.sun.aas.imqBin");
                string4 = ServerManager.instance().getDomainName();
                jMSAdmin = IASJmsUtil.getJMSAdminFactory().getJMSAdmin();
                string5 = IASJmsUtil.getBrokerInstanceName(string4, string, jmsService);
                stringArray[0] = "-javahome";
                stringArray[1] = string3;
                jMSAdmin.deleteProviderInstance(string6, stringArray, string5);
            }
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, "mbean.del_jms_instance_failed", exception);
        }
    }

    public void shutdown() {
        sLogger.log(Level.INFO, "mbean.shutdown_started");
        String string = "admin-server";
        new Thread(new ShutdownThread(string)).start();
    }

    public void shutdownAndExit() {
    }

    public void restart() throws ControlException {
    }

    public String getVersion() throws ControlException {
        return Version.getVersion();
    }

    public String getFullVersion() throws ControlException {
        return Version.getFullVersion();
    }

    public String uploadToServer(ByteChunk byteChunk) throws ControlException {
        File file;
        if (byteChunk == null) {
            throw new IllegalArgumentException();
        }
        String string = byteChunk.getChunkedFileName();
        String string2 = AdminService.getAdminService().getTempDirPath();
        String string3 = byteChunk.getTargetDir();
        if (string3 != null) {
            file = new File(string2, string3);
            if (!file.exists()) {
                file.mkdir();
            }
            string2 = FileUtils.safeGetCanonicalPath(file);
        }
        file = new File(string2, string);
        string2 = FileUtils.safeGetCanonicalPath(file);
        if (byteChunk.isFirst()) {
            if (file.exists()) {
                sLogger.log(Level.INFO, "mbean.temp_upload_file_exists", string2);
                boolean bl = file.delete();
                if (bl) {
                    sLogger.log(Level.FINE, "mbean.delete_temp_file_ok", string2);
                } else {
                    sLogger.log(Level.INFO, "mbean.delete_temp_file_failed", string2);
                }
            }
            OutputStream outputStream = this.createOutputStream(string2);
            this.mStreamTable.put(string2, outputStream);
            sLogger.log(Level.INFO, "mbean.begin_upload", string2);
        }
        this.saveFile(string2, byteChunk);
        return string2;
    }

    private void saveFile(String string, ByteChunk byteChunk) throws ControlException {
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)this.mStreamTable.get(string);
            byte[] byArray = byteChunk.getBytes();
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            throw new ControlException(exception.getMessage());
        }
        finally {
            try {
                if (byteChunk.isLast()) {
                    outputStream.close();
                    this.mStreamTable.remove(string);
                    sLogger.log(Level.INFO, "mbean.upload_done", string);
                }
            }
            catch (Exception exception) {
                throw new ControlException(exception.getMessage());
            }
        }
    }

    private OutputStream createOutputStream(String string) throws ControlException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (Exception exception2) {
                sLogger.log(Level.WARNING, "mbean.upload_failed", string);
            }
            throw new ControlException(exception.getMessage());
        }
        return fileOutputStream;
    }

    public String[] listServerInstances() {
        ServerManager serverManager = ServerManager.instance();
        boolean bl = false;
        String[] stringArray = serverManager.getInstanceNames(bl);
        return stringArray;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return new MBeanEasyConfig(this.getClass(), mAttrs, mOpers, null).getMBeanInfo();
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.mbeaninfo_failed", exception);
            return null;
        }
    }

    public Object prepareDownload(String string) throws ControlException {
        sLogger.log(Level.CONFIG, "mbean.prep_download", string);
        File file = new File(string);
        if (!file.exists()) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.file_doesnot_exist", string);
            throw new ControlException(string2);
        }
        try {
            if (this.lock == null) {
                this.lock = new Lock();
            }
            this.lock.attempt(1000L);
        }
        catch (Exception exception) {
            String string3 = localStrings.getString("admin.server.core.mbean.config.could_not_acquire_lock", exception.toString());
            throw new ControlException(string3);
        }
        if (this.downloadInfo == null) {
            this.downloadInfo = new DownloadInfo();
        }
        this.downloadInfo.downloadFile = file;
        long l = this.downloadInfo.downloadFile.length();
        this.downloadInfo.numChunks = Math.round(l / 65536L);
        if ((long)(this.downloadInfo.numChunks * 65536) < l) {
            this.downloadInfo.numChunks += 1;
        }
        this.downloadInfo.isPrepared = true;
        return null;
    }

    public ByteChunk downloadFile(int n) throws ControlException {
        sLogger.log(Level.FINE, "mbean.begin_download");
        if (this.downloadInfo == null) {
            String string = localStrings.getString("admin.server.core.mbean.config.call_preparedownload_first");
            throw new ControlException(string);
        }
        if (!this.downloadInfo.isPrepared) {
            String string = localStrings.getString("admin.server.core.mbean.config.call_preparedownload_first");
            throw new ControlException(string);
        }
        if (n >= this.downloadInfo.numChunks || n < 0) {
            String string = localStrings.getString("admin.server.core.mbean.config.invalid_chunk_index");
            throw new ControlException(string);
        }
        RandomAccessFile randomAccessFile = null;
        ByteChunk byteChunk = null;
        try {
            boolean bl;
            randomAccessFile = new RandomAccessFile(this.downloadInfo.downloadFile, "r");
            byte[] byArray = new byte[65536];
            randomAccessFile.seek(this.downloadInfo.numBytesRead);
            int n2 = randomAccessFile.read(byArray, 0, 65536);
            if (n2 < byArray.length) {
                byte[] byArray2 = new byte[n2];
                bl = false;
                while (bl < byArray2.length) {
                    byArray2[bl] = byArray[bl];
                    bl += 1;
                }
                byArray = byArray2;
            }
            this.downloadInfo.numBytesRead += n2;
            boolean bl2 = n == 0;
            bl = n == this.downloadInfo.numChunks - 1;
            sLogger.log(Level.FINEST, "chunkIndex = " + n + " isFirstChunk = " + bl2 + " isLastChunk = " + bl);
            byteChunk = new ByteChunk(byArray, this.downloadInfo.downloadFile.getAbsolutePath(), bl2, bl);
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, "mbean.download_failed", exception);
            this.downloadInfo.reset();
            try {
                this.lock.release();
            }
            catch (Exception exception2) {
                sLogger.log(Level.FINEST, "lock could not be released");
            }
            throw new ControlException(exception.toString());
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            if (byteChunk != null && byteChunk.isLast()) {
                try {
                    this.downloadInfo.reset();
                    this.lock.release();
                }
                catch (Exception exception) {
                    sLogger.log(Level.FINEST, "lock could not be released");
                }
            }
        }
        return byteChunk;
    }

    private boolean isBadInstanceName(String string) {
        try {
            StaticTest.checkXMLName(string);
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, "Error: The instance name is not a valid xml string");
            sLogger.log(Level.FINE, exception.getMessage(), exception);
            return true;
        }
        try {
            StaticTest.checkObjectName(string);
        }
        catch (Exception exception) {
            sLogger.log(Level.FINE, "Error: The instance name is not a valid mbean object name");
            sLogger.log(Level.FINE, exception.getMessage(), exception);
            return true;
        }
        return false;
    }

    public void stopDomain(boolean bl) throws ControlException {
        String string = ServerManager.instance().getDomainName();
        if (bl) {
            sLogger.log(Level.INFO, "domain.stop_domain_admin", string);
        } else {
            sLogger.log(Level.INFO, "domain.stop_domain_noadmin", string);
        }
        this.stopAllInstances(false);
        if (bl) {
            this.shutdown();
        }
    }

    public DomainEntry[] listDomains() throws ControlException {
        DomainEntry[] domainEntryArray = null;
        try {
            DomainRegistry domainRegistry = DomainRegistry.newInstance();
            int n = domainRegistry.size();
            domainEntryArray = new DomainEntry[n];
            Iterator iterator = domainRegistry.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                domainEntryArray[n2++] = (DomainEntry)iterator.next();
            }
            if (!$assertionsDisabled && n != n2) {
                throw new AssertionError();
            }
        }
        catch (Exception exception) {
            throw new ControlException(exception.getMessage());
        }
        return domainEntryArray;
    }

    private void stopAllInstances(boolean bl) {
        String[] stringArray = this.getRunningInstanceNames();
        if (!bl) {
            int n = 0;
            while (n < stringArray.length) {
                sLogger.log(Level.INFO, "mbean.stop_instance", stringArray[n]);
                this.stopInstance(stringArray[n]);
                ++n;
            }
        } else {
            throw new UnsupportedOperationException("not impl yet");
        }
    }

    public String[] getRunningInstanceNames() {
        String[] stringArray = ServerManager.instance().getInstanceNames(false);
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.isInstanceAlive(stringArray[n2])) {
                vector.add(stringArray[n2]);
                ++n;
                sLogger.log(Level.FINE, "mbean.instance_up", stringArray[n2]);
            } else {
                sLogger.log(Level.FINE, "mbean.instance_down", stringArray[n2]);
            }
            ++n2;
        }
        if (n > 0) {
            stringArray2 = new String[n];
            stringArray2 = vector.toArray(stringArray2);
        } else {
            stringArray2 = new String[]{};
        }
        return stringArray2;
    }

    private void stopInstance(String string) {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName((String)string);
        Object[] objectArray = new Integer[]{new Integer(600)};
        String[] stringArray = new String[]{"int"};
        try {
            this.invokeMBean(objectName, "stop", objectArray, stringArray);
        }
        catch (Exception exception) {
            sLogger.log(Level.CONFIG, "failure in invoking MBean", exception);
        }
    }

    private boolean isInstanceAlive(String string) {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName((String)string);
        try {
            ServerInstanceStatus serverInstanceStatus = (ServerInstanceStatus)this.invokeMBean(objectName, "getStatus", null, null);
            return serverInstanceStatus.isRunning();
        }
        catch (Exception exception) {
            sLogger.log(Level.CONFIG, "failure in invoking MBean", exception);
            return false;
        }
    }

    private Object invokeMBean(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Exception {
        MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
        return mBeanServer.invoke(objectName, string, objectArray, stringArray);
    }

    public String getLicenseInfo() throws ControlException {
        try {
            LicenseBase licenseBase = LicenseManager.getLicense();
            String string = licenseBase.printLicenseString();
            return string;
        }
        catch (Exception exception) {
            sLogger.log(Level.WARNING, "mbean.get_license_info_failed", exception);
            throw new ControlException(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$admin$server$core$mbean$config$ServerController == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ServerController = ServerController.class$("com.iplanet.ias.admin.server.core.mbean.config.ServerController")) : class$com$iplanet$ias$admin$server$core$mbean$config$ServerController).desiredAssertionStatus();
        sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
        localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$ServerController == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ServerController = ServerController.class$("com.iplanet.ias.admin.server.core.mbean.config.ServerController")) : class$com$iplanet$ias$admin$server$core$mbean$config$ServerController);
        mAttrs = new String[0];
        mOpers = new String[]{"createServerInstance(String instanceName, com.iplanet.ias.admin.util.HostAndPort hostPort, boolean autoStart), ACTION", "deleteServerInstance(String instanceName), ACTION", "shutdown(), ACTION", "shutdownAndExit(), ACTION", "restart(), ACTION", "getVersion(), ACTION_INFO", "getFullVersion(), ACTION_INFO", "uploadToServer(com.iplanet.ias.admin.common.ByteChunk byteChunk), ACTION_INFO", "listServerInstances(), INFO"};
    }

    private static final class DownloadInfo {
        private File downloadFile;
        private int numChunks;
        private long numBytesRead;
        private boolean isPrepared;

        private DownloadInfo() {
            this.reset();
        }

        private synchronized void reset() {
            this.downloadFile = null;
            this.numChunks = 0;
            this.numBytesRead = 0L;
            this.isPrepared = false;
        }
    }

    private final class Lock {
        private boolean inUse = false;

        private Lock() {
        }

        private synchronized void acquire() throws InterruptedException, IllegalAccessException {
            while (this.inUse) {
                this.wait();
            }
            this.inUse = true;
        }

        private synchronized void release() throws IllegalAccessException {
            this.inUse = false;
            this.notify();
        }

        private synchronized void attempt(long l) throws InterruptedException, IllegalAccessException {
            if (this.inUse) {
                this.wait(l);
                if (this.inUse) {
                    String string = localStrings.getString("admin.server.core.mbean.config.another_thread_holding_lock");
                    throw new IllegalAccessException(string);
                }
            }
            this.inUse = true;
        }
    }
}

