/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.AuthRealm;
import com.iplanet.ias.config.serverbeans.SecurityService;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.iplanet.ias.config.serverbeans.ServerXPathHelper;
import com.iplanet.ias.util.i18n.StringManager;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;

public class ManagedSecurityService
extends ConfigMBeanBase
implements ConfigAttributeName.SecurityService {
    private static final String[][] MAPLIST = new String[][]{{"defaultRealm", "@" + ServerTags.DEFAULT_REALM}, {"defaultPrincipal", "@" + ServerTags.DEFAULT_PRINCIPAL}, {"defaultPrincipalPassword", "@" + ServerTags.DEFAULT_PRINCIPAL_PASSWORD}, {"anonymousRole", "@" + ServerTags.ANONYMOUS_ROLE}, {"auditEnabled", "@" + ServerTags.AUDIT_ENABLED}, {"logLevel", "@" + ServerTags.LOG_LEVEL}};
    private static final String[] ATTRIBUTES = new String[]{"defaultRealm, String,       RW", "defaultPrincipal, String,       RW", "defaultPrincipalPassword, String,       RW", "anonymousRole, String,       RW", "auditEnabled, boolean,      RW", "logLevel, String,       RW"};
    private static final String[] OPERATIONS = new String[]{"createAuthRealm(String name, String classname), ACTION", "deleteAuthRealm(String id), ACTION", "listAuthRealms(), INFO"};
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$admin$server$core$mbean$config$ManagedSecurityService == null ? (class$com$iplanet$ias$admin$server$core$mbean$config$ManagedSecurityService = ManagedSecurityService.class$("com.iplanet.ias.admin.server.core.mbean.config.ManagedSecurityService")) : class$com$iplanet$ias$admin$server$core$mbean$config$ManagedSecurityService);
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$core$mbean$config$ManagedSecurityService;

    public ManagedSecurityService() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedSecurityService(String string) throws MBeanConfigException {
        this();
        this.initialize("securityservice", new String[]{string});
    }

    public void createAuthRealm(String string, String string2) throws ConfigException {
        AuthRealm authRealm = new AuthRealm();
        if (string != null) {
            authRealm.setName(string);
        }
        if (string2 != null) {
            authRealm.setClassname(string2);
        }
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        securityService.addAuthRealm(authRealm);
        this.getConfigContext().flush();
    }

    public void deleteAuthRealm(String string) throws ConfigException, MBeanException, AttributeNotFoundException {
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        AuthRealm authRealm = securityService.getAuthRealmByName(string);
        if (((String)this.getAttribute("defaultRealm")).equals(string)) {
            String string2 = localStrings.getString("admin.server.core.mbean.config.default_realm_cannot_delete", string);
            throw new ConfigException(string2);
        }
        if (authRealm != null) {
            securityService.removeAuthRealm(authRealm);
        }
        this.getConfigContext().flush();
    }

    public String[] listAuthRealms() throws ConfigException {
        SecurityService securityService = (SecurityService)this.getConfigBeanByXPath(ServerXPathHelper.getSecurityServiceXpath());
        AuthRealm[] authRealmArray = securityService.getAuthRealm();
        String[] stringArray = new String[authRealmArray.length];
        int n = 0;
        while (n < authRealmArray.length) {
            stringArray[n] = authRealmArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

