/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.jmx.tester;

import com.iplanet.ias.admin.server.core.jmx.MBeanIntrospector;
import com.iplanet.ias.admin.util.Debug;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.constant.Constable;
import javax.management.NotCompliantMBeanException;

public class MBeanIntrospectorTester {
    public static void main(String[] stringArray) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        long l = System.currentTimeMillis();
        while ((string = bufferedReader.readLine()) != null) {
            if (MBeanIntrospectorTester.isPrimitive(string = string.trim())) {
                try {
                    MBeanIntrospectorTester.checkPrimitive(string);
                    Debug.println((Object)("Test failed : " + string));
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {}
                continue;
            }
            try {
                MBeanIntrospectorTester.checkNonPrimitive(string);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                Debug.println((Object)("Not Compliant : " + string));
            }
        }
        long l2 = System.currentTimeMillis();
        bufferedReader.close();
    }

    private static boolean isPrimitive(String string) {
        return string.equals("int") || string.equals("boolean") || string.equals("short") || string.equals("byte") || string.equals("char") || string.equals("float") || string.equals("long") || string.equals("double");
    }

    private static void checkPrimitive(String string) throws NotCompliantMBeanException {
        Class<Constable> clazz = null;
        if (string.equals("int")) {
            clazz = Integer.TYPE;
        } else if (string.equals("boolean")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("short")) {
            clazz = Short.TYPE;
        } else if (string.equals("byte")) {
            clazz = Byte.TYPE;
        } else if (string.equals("char")) {
            clazz = Character.TYPE;
        } else if (string.equals("float")) {
            clazz = Float.TYPE;
        } else if (string.equals("long")) {
            clazz = Long.TYPE;
        } else if (string.equals("double")) {
            clazz = Double.TYPE;
        }
        new MBeanIntrospector(clazz);
    }

    private static void checkNonPrimitive(String string) throws ClassNotFoundException, NotCompliantMBeanException {
        Class<?> clazz = Class.forName(string);
        MBeanIntrospector mBeanIntrospector = new MBeanIntrospector(clazz);
        String string2 = " Type = ";
        string2 = string2 + (mBeanIntrospector.isStandardMBean() ? "isStandard" : (mBeanIntrospector.isDynamicMBean() ? "isDynamic" : "Don't know"));
        Debug.println((Object)(string + string2));
        Debug.println((Object)("Management interface = " + mBeanIntrospector.getMBeanInterfaceClass().getName()));
    }
}

