/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.servlet;

import com.iplanet.ias.admin.server.gui.servlet.MultipartFile;
import com.iplanet.ias.admin.server.gui.servlet.MultipartInputStream;
import com.iplanet.ias.util.i18n.StringManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MultipartHandler {
    private static final int DEFAULT_MAX_UPLOAD_SIZE = 0x100000;
    protected Hashtable formFields = new Hashtable();
    protected Hashtable uploadFiles = new Hashtable();
    private HttpServletRequest req;
    private ServletInputStream in;
    private String boundary;
    private byte[] buf = new byte[8192];
    private File uploadDir;
    private String fieldEncoding = "ISO-8859-1";
    private static StringManager localStrings = StringManager.getManager((Class)(class$com$iplanet$ias$admin$server$gui$servlet$MultipartHandler == null ? (class$com$iplanet$ias$admin$server$gui$servlet$MultipartHandler = MultipartHandler.class$("com.iplanet.ias.admin.server.gui.servlet.MultipartHandler")) : class$com$iplanet$ias$admin$server$gui$servlet$MultipartHandler));
    static /* synthetic */ Class class$com$iplanet$ias$admin$server$gui$servlet$MultipartHandler;

    public MultipartHandler(HttpServletRequest httpServletRequest, String string) throws IOException {
        this(httpServletRequest, string, 0x100000, "ISO-8859-1");
    }

    public MultipartHandler(HttpServletRequest httpServletRequest, String string, int n) throws IOException {
        this(httpServletRequest, string, n, "ISO-8859-1");
    }

    public MultipartHandler(HttpServletRequest httpServletRequest, String string, int n, String string2) throws IOException {
        if (httpServletRequest == null) {
            String string3 = localStrings.getString("admin.server.gui.servlet.request_cannot_be_null");
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = localStrings.getString("admin.server.gui.servlet.tmpdirectory_cannot_be_null");
            throw new IllegalArgumentException(string4);
        }
        if (n <= 0) {
            String string5 = localStrings.getString("admin.server.gui.servlet.maxpostsize_must_be_positive");
            throw new IllegalArgumentException(string5);
        }
        this.uploadDir = new File(string);
        if (!this.uploadDir.isDirectory()) {
            String string6 = localStrings.getString("admin.server.gui.servlet.not_directory", (Object)string);
            throw new IllegalArgumentException(string6);
        }
        if (!this.uploadDir.canWrite()) {
            String string7 = localStrings.getString("admin.server.gui.servlet.not_writable", (Object)string);
            throw new IllegalArgumentException(string7);
        }
        int n2 = httpServletRequest.getContentLength();
        String string8 = httpServletRequest.getContentType();
        if (string8 == null || !string8.toLowerCase().startsWith("multipart/form-data")) {
            String string9 = localStrings.getString("admin.server.gui.servlet.posted_content_type_not_multipart");
            throw new IOException(string9);
        }
        this.fieldEncoding = string2;
        this.req = httpServletRequest;
    }

    public void parseMultipartUpload() throws IOException {
        this.startMultipartParse();
        HashMap hashMap = this.parsePartHeaders();
        while (hashMap != null) {
            String string = (String)hashMap.get("fieldName");
            String string2 = (String)hashMap.get("fileName");
            if (string2 != null) {
                if (string2.equals("")) {
                    string2 = null;
                }
                if (string2 != null) {
                    this.saveUploadFile(string2);
                    this.uploadFiles.put(string, new MultipartFile(this.uploadDir.toString(), string2, (String)hashMap.get("content-type")));
                } else {
                    this.uploadFiles.put(string, new MultipartFile(null, null, null));
                }
            } else {
                byte[] byArray = this.parseFormFieldBytes();
                String string3 = new String(byArray, this.fieldEncoding);
                Vector<String> vector = (Vector<String>)this.formFields.get(string);
                if (vector == null) {
                    vector = new Vector<String>();
                    this.formFields.put(string, vector);
                }
                vector.addElement(string3);
            }
            hashMap.clear();
            hashMap = this.parsePartHeaders();
        }
    }

    private void startMultipartParse() throws IOException {
        String string = this.parseBoundary(this.req.getContentType());
        if (string == null) {
            String string2 = localStrings.getString("admin.server.gui.servlet.separation_boundary_not_specified");
            throw new IOException(string2);
        }
        this.in = this.req.getInputStream();
        this.boundary = string;
        String string3 = this.readLine();
        if (string3 == null) {
            String string4 = localStrings.getString("admin.server.gui.servlet.corrupt_form_data_premature_ending");
            throw new IOException(string4);
        }
        if (!string3.startsWith(string)) {
            String string5 = localStrings.getString("admin.server.gui.servlet.corrupt_form_data_no_leading_boundary", (Object)string3, (Object)string);
            throw new IOException(string5);
        }
    }

    private HashMap parsePartHeaders() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        String string = this.readLine();
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        vector.addElement(string);
        while ((string = this.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        if (string == null) {
            return null;
        }
        hashMap.put("content-type", "text/plain");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.toLowerCase().startsWith("content-disposition:")) {
                this.parseContentDisposition(string2, hashMap);
                continue;
            }
            if (!string2.toLowerCase().startsWith("content-type:")) continue;
            this.parseContentType(string2, hashMap);
        }
        return hashMap;
    }

    private String parseBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private void parseContentDisposition(String string, HashMap hashMap) throws IOException {
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            String string3 = localStrings.getString("admin.server.gui.servlet.content_disposition_corrupt", (Object)string2);
            throw new IOException(string3);
        }
        String string4 = string.substring(n + 21, n2);
        if (!string4.equals("form-data")) {
            String string5 = localStrings.getString("admin.server.gui.servlet.invalid_content_disposition", (Object)string4);
            throw new IOException(string5);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            String string6 = localStrings.getString("admin.server.gui.servlet.content_disposition_corrupt", (Object)string2);
            throw new IOException(string6);
        }
        String string7 = string2.substring(n + 6, n2);
        String string8 = null;
        String string9 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string9 = string8 = string2.substring(n + 10, n2);
            int n3 = Math.max(string8.lastIndexOf(47), string8.lastIndexOf(92));
            if (n3 > -1) {
                string8 = string8.substring(n3 + 1);
            }
        }
        hashMap.put("disposition", string4);
        hashMap.put("fieldName", string7);
        hashMap.put("fileName", string8);
        hashMap.put("filePath", string9);
    }

    private void parseContentType(String string, HashMap hashMap) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                String string4 = localStrings.getString("admin.server.gui.servlet.corrupt_content_type", (Object)string3);
                throw new IOException(string4);
            }
            string2 = string.substring(n + 1);
            hashMap.put("content-type", string2);
        } else if (string.length() != 0) {
            String string5 = localStrings.getString("admin.server.gui.servlet.malformed_line_after_disposition", (Object)string3);
            throw new IOException(string5);
        }
    }

    private byte[] parseFormFieldBytes() throws IOException {
        int n;
        MultipartInputStream multipartInputStream = new MultipartInputStream(this.in, this.boundary);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = new byte[128];
        while ((n = multipartInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        multipartInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
        } while (n == this.buf.length);
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n2 = stringBuffer.length();
        if (stringBuffer.charAt(n2 - 2) == '\r') {
            stringBuffer.setLength(n2 - 2);
        } else {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long saveUploadFile(String string) throws IOException {
        long l = 0L;
        OutputStream outputStream = null;
        try {
            int n;
            File file = new File(this.uploadDir, string);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[8192];
            MultipartInputStream multipartInputStream = new MultipartInputStream(this.in, this.boundary);
            while ((n = multipartInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
            multipartInputStream.close();
            Object var10_8 = null;
            if (outputStream == null) return l;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (outputStream == null) throw throwable;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
        return l;
    }

    public Enumeration getParameterNames() {
        return this.formFields.keys();
    }

    public Enumeration getFileNames() {
        return this.uploadFiles.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileName(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFileName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileType(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFileType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close() throws IOException {
        this.req = null;
        this.in = null;
        this.boundary = null;
        this.buf = null;
        this.uploadDir = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

