/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.util;

import com.iplanet.ias.tools.common.util.StringUtils;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.openide.nodes.Node;

public class PropertySupportUtils {
    public static void setNames(Node.Property prop, ResourceBundle bundle, String name) {
        Reporter.assertIt(bundle);
        Reporter.assertIt(name);
        Reporter.assertIt(prop);
        String mungedName = StringUtils.UpperCaseFirstLetter(name);
        String displayName = null;
        String description = null;
        try {
            displayName = bundle.getString("TTL_" + mungedName);
            description = bundle.getString("DESC_" + mungedName);
        }
        catch (MissingResourceException e) {
            Reporter.warn("String missing from bundle: " + e.toString());
        }
        Reporter.assertIt(displayName);
        prop.setName(name);
        prop.setDisplayName(displayName);
        if (description != null && description.length() > 0) {
            prop.setShortDescription(description);
        }
    }

    static void setNames(Node.Property prop, BundleHelper bundle, String name) {
        Reporter.assertIt(bundle);
        Reporter.assertIt(name);
        Reporter.assertIt(prop);
        String mungedName = StringUtils.UpperCaseFirstLetter(name);
        String displayName = null;
        String description = null;
        try {
            displayName = bundle.getString("TTL_" + mungedName);
            description = bundle.getString("DESC_" + mungedName);
        }
        catch (MissingResourceException e) {
            Reporter.warn("String missing from bundle: " + e.toString());
        }
        Reporter.assertIt(displayName);
        prop.setName(name);
        prop.setDisplayName(displayName);
        if (description != null && description.length() > 0) {
            prop.setShortDescription(description);
        }
    }
}

