/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.execution;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ForteUIInterface;
import com.iplanet.ias.tools.forte.execution.ServerOutputImpl;
import com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings;
import com.iplanet.ias.tools.forte.server.ServerInstanceBean;
import java.io.File;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import org.netbeans.modules.j2ee.server.Progress;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.web.URLInfo;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class IASServerExecution
implements URLInfo {
    protected transient ServerInstanceBean webServerInstance = null;
    protected transient SequenceInputStream sequenceInputStream = null;
    transient boolean inExecutionMode = false;
    private static int UNKNOWN_STATE = -4;
    private transient int currentMode = UNKNOWN_STATE;
    private transient boolean modeHasChanged;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$execution$IASServerExecution;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$server$ServerInstanceBean;

    public int getDebuggingPort() {
        try {
            return this.webServerInstance.getJPDAPortNumber();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public IASServerExecution(ServerInstanceBean webServerInstance) {
        Reporter.verbose("");
        this.webServerInstance = webServerInstance;
    }

    public URLInfo getURLInfo() throws ServerException {
        Reporter.verbose("");
        return this;
    }

    public URL getURL() {
        Reporter.verbose("");
        InetAddress IP = null;
        try {
            IP = InetAddress.getByName(this.webServerInstance.getAdminHost());
            Socket s = new Socket(IP, this.webServerInstance.getAdminPort());
            s.close();
            try {
                String u = this.webServerInstance.getConnectorUrl();
                Reporter.info("URL = " + u);
                URL url = new URL(u);
                return url;
            }
            catch (MalformedURLException e) {
                TopManager.getDefault().getErrorManager().notify(16, (Throwable)e);
                return null;
            }
        }
        catch (Exception e) {
            TopManager.getDefault().setStatusText(NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution)).getString("Error_Execute"));
            Reporter.info("Unable to connect to Admin Server");
            return null;
        }
    }

    public ServerOutput[] getServerOutput() {
        Reporter.verbose("");
        if (!this.inExecutionMode) {
            return new ServerOutput[0];
        }
        this.inExecutionMode = false;
        TopManager.getDefault().setStatusText("");
        try {
            return new ServerOutput[]{new ServerOutputImpl("error", this.sequenceInputStream), new ServerOutputImpl("output", this.sequenceInputStream)};
        }
        catch (Exception e) {
            return new ServerOutput[0];
        }
    }

    public void setRestart() {
    }

    public void setMode(int param) {
        Reporter.info("Instance: " + this + "   param == " + param + "currentMode == " + this.currentMode);
        this.modeHasChanged = false;
        if (this.currentMode != param) {
            this.currentMode = param;
            this.modeHasChanged = true;
        }
    }

    public static File getIASInstallDirectory() {
        return IasGlobalOptionsSettings.getSingleton().getIASInstallDirectory();
    }

    public synchronized void synchronize(Progress p) {
        Reporter.verbose(" ");
        TopManager.getDefault().setStatusText(NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution)).getString("MSG_Preparing"));
        this.inExecutionMode = true;
        InetAddress IP = null;
        try {
            IP = InetAddress.getByName(this.webServerInstance.getAdminHost());
            Socket s = new Socket(IP, this.webServerInstance.getAdminPort());
            s.close();
            if (!this.modeHasChanged && this.webServerInstance.isRunning()) {
                return;
            }
            try {
                if (1 == this.currentMode) {
                    Reporter.info("Execute Phase");
                    if (!this.webServerInstance.isRunning()) {
                        if (p != null) {
                            p.startTask(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution), (String)"LBL_executor"), 100);
                        }
                        if (p != null) {
                            p.addMessage(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution), (String)"MSG_Preparing"));
                        }
                        if (p != null) {
                            p.recordWork(5);
                        }
                        if (p != null) {
                            p.recordWork(25);
                        }
                        if (p != null) {
                            p.addMessage(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution), (String)"MSG_Starting"));
                        }
                        this.webServerInstance.startInstance(ForteUIInterface.getUIMessenger());
                        if (p != null) {
                            p.recordWork(70);
                        }
                    }
                } else {
                    Reporter.info("Debug Phase");
                    if (p != null) {
                        p.startTask(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution), (String)"LBL_executor"), 100);
                    }
                    if (p != null) {
                        p.addMessage(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution), (String)"LBL_debugger"));
                    }
                    if (p != null) {
                        p.recordWork(5);
                    }
                    if (this.webServerInstance.isRunning() && this.getDebuggingPort() != -1) {
                        if (p != null) {
                            p.recordWork(100);
                        }
                        Reporter.info("we are already running in debug mode. We just need to attach to the JVM ");
                        return;
                    }
                    this.webServerInstance.stopInstance(ForteUIInterface.getUIMessenger());
                    int currentPort = this.webServerInstance.startInDebugMode(ForteUIInterface.getUIMessenger());
                    if (-1 == currentPort) {
                        Object[] args = new Object[]{this.webServerInstance.getName()};
                        NotifyDescriptor nd = new NotifyDescriptor((Object)MessageFormat.format(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$ServerInstanceBean == null ? (class$com$iplanet$ias$tools$forte$server$ServerInstanceBean = IASServerExecution.class$("com.iplanet.ias.tools.forte.server.ServerInstanceBean")) : class$com$iplanet$ias$tools$forte$server$ServerInstanceBean), (String)"ERR_NEED_TO_CONFIGURE_FOR_DEBUG"), args), NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$ServerInstanceBean == null ? (class$com$iplanet$ias$tools$forte$server$ServerInstanceBean = IASServerExecution.class$("com.iplanet.ias.tools.forte.server.ServerInstanceBean")) : class$com$iplanet$ias$tools$forte$server$ServerInstanceBean), (String)"TTL_START_DEBUG_FAIL"), -1, 0, null, null);
                        TopManager.getDefault().notify(nd);
                        try {
                            if (!this.webServerInstance.isRunning()) {
                                this.webServerInstance.startInstance(ForteUIInterface.getUIMessenger());
                            }
                        }
                        catch (Exception ex) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 0));
                        }
                    }
                }
                if (p != null) {
                    p.recordWork(100);
                }
                Reporter.info("After seeting the progress to null");
            }
            catch (Exception e) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 0));
            }
        }
        catch (Exception e) {
            TopManager.getDefault().setStatusText(NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$execution$IASServerExecution == null ? (class$com$iplanet$ias$tools$forte$execution$IASServerExecution = IASServerExecution.class$("com.iplanet.ias.tools.forte.execution.IASServerExecution")) : class$com$iplanet$ias$tools$forte$execution$IASServerExecution)).getString("Error_Execute"));
            Reporter.info("Unable to connect to Admin Server");
            return;
        }
    }

    public synchronized void stopExecution() {
        Reporter.verbose("");
        this.setRestart();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

