/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import java.io.Serializable;

public class ByteChunk
implements Serializable {
    public static final long serialVersionUID = 9100504074948693275L;
    public static final int kChunkMaxSize = 65536;
    public static final int kChunkMinSize = 0;
    private int mSize;
    private boolean mIsLast;
    private boolean mIsFirst;
    private byte[] mBytes;
    private String mChunkedFileName;
    private String mTargetDir;

    public ByteChunk(byte[] byteArray, String forFileName, boolean isFirst, boolean isLast) {
        int size = byteArray.length;
        if (0 > size || size > 65536) {
            throw new IllegalArgumentException(size + "");
        }
        this.mSize = size;
        this.mIsFirst = isFirst;
        this.mIsLast = isLast;
        this.mBytes = byteArray;
        this.mChunkedFileName = forFileName;
    }

    public boolean isLast() {
        return this.mIsLast;
    }

    public boolean isFirst() {
        return this.mIsFirst;
    }

    public int getSize() {
        return this.mSize;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public String getChunkedFileName() {
        return this.mChunkedFileName;
    }

    public String getTargetDir() {
        return this.mTargetDir;
    }

    public void setTargetDir(String targetDir) {
        this.mTargetDir = targetDir;
    }
}

