/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.iplanet.ias.util.ExecException;
import com.iplanet.ias.util.FlusherThread;
import com.iplanet.ias.util.OS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ProcessExecutor {
    public static final long kDefaultTimeoutMillis = 600000L;
    public static final long kSleepTime = 2000L;
    private static final String STDERR = "Sun_ONE_Application_Server_stderr";
    private static final String STDOUT = "Sun_ONE_Application_Server_stdout";
    private static final long DEFAULT_TIMEOUT_SEC = 600L;
    private long mTimeoutMilliseconds = 0L;
    private String[] mCmdStrings = null;
    private File mOutFile = null;
    private File mErrFile = null;
    private String[] mInputLines = null;
    private int mExitValue = -1;

    public ProcessExecutor(String[] stringArray) {
        this(stringArray, 600L, null);
    }

    public ProcessExecutor(String[] stringArray, String[] stringArray2) {
        this(stringArray, 600L, stringArray2);
    }

    public ProcessExecutor(String[] stringArray, long l) {
        this(stringArray, l, null);
    }

    public ProcessExecutor(String[] stringArray, long l, String[] stringArray2) {
        this.mCmdStrings = stringArray;
        this.mInputLines = stringArray2;
        char c = '/';
        char c2 = '\\';
        int n = 0;
        while (n < this.mCmdStrings.length) {
            this.mCmdStrings[n] = OS.isUnix() ? this.mCmdStrings[n].replace(c2, c) : this.mCmdStrings[n].replace(c, c2);
            ++n;
        }
        this.mTimeoutMilliseconds = l * 1000L;
    }

    private void init() throws ExecException {
        try {
            this.mOutFile = File.createTempFile("stdout", null);
            this.mOutFile.deleteOnExit();
            this.mErrFile = File.createTempFile("stderr", null);
            this.mErrFile.deleteOnExit();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.deleteTempFiles();
            throw new ExecException("Internal error (util.ProcessExecutor.init()): " + illegalArgumentException.getMessage());
        }
        catch (IOException iOException) {
            this.deleteTempFiles();
            throw new ExecException(ProcessExecutor.cannotCreateTempFiles());
        }
    }

    private static final String cannotCreateTempFiles() {
        return "Could not create temporary files - check " + System.getProperty("java.io.tmpdir") + " to see if its writeable and not-full";
    }

    private void deleteTempFiles() {
        if (this.mOutFile != null) {
            this.mOutFile.delete();
        }
        if (this.mErrFile != null) {
            this.mErrFile.delete();
        }
    }

    public void execute() throws ExecException {
        this.execute(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] execute(boolean bl) throws ExecException {
        String[] stringArray;
        block16: {
            this.init();
            try {
                String[] stringArray2;
                block15: {
                    try {
                        Process process = Runtime.getRuntime().exec(this.mCmdStrings);
                        InputStream inputStream = null;
                        if (this.mInputLines != null) {
                            this.addInputLinesToProcessInput(process);
                        }
                        if (!bl) {
                            this.redirectProcessOutput(process);
                        } else {
                            inputStream = process.getInputStream();
                        }
                        this.redirectProcessError(process);
                        long l = System.currentTimeMillis();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        while (true) {
                            if (bl4) {
                                if (bl3) break;
                                process.destroy();
                                this.mExitValue = -255;
                                throw new ExecException("Subprocess timed out after " + this.mTimeoutMilliseconds + "mS");
                            }
                            this.sleep(2000L);
                            long l2 = System.currentTimeMillis();
                            bl2 = l2 - l >= this.mTimeoutMilliseconds;
                            try {
                                this.mExitValue = process.exitValue();
                                bl3 = true;
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                bl3 = false;
                            }
                            bl4 = bl2 || bl3;
                        }
                        this.mExitValue = process.exitValue();
                        if (this.mExitValue != 0) {
                            throw new ExecException("abnormal subprocess termination");
                        }
                        if (bl) {
                            stringArray2 = this.getInputStrings(inputStream);
                            Object var13_13 = null;
                            break block15;
                        }
                        stringArray = null;
                        break block16;
                    }
                    catch (SecurityException securityException) {
                        throw new ExecException(securityException.getMessage());
                    }
                    catch (IOException iOException) {
                        throw new ExecException(iOException.getMessage());
                    }
                }
                this.deleteTempFiles();
                return stringArray2;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                this.deleteTempFiles();
                throw throwable;
            }
        }
        Object var13_14 = null;
        this.deleteTempFiles();
        return stringArray;
    }

    public int getProcessExitValue() {
        return this.mExitValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addInputLinesToProcessInput(Process process) throws ExecException {
        if (this.mInputLines == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(process.getOutputStream())));
                int n = 0;
                while (true) {
                    if (n >= this.mInputLines.length) {
                        printWriter.flush();
                        break;
                    }
                    printWriter.println(this.mInputLines[n]);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new ExecException(exception.getMessage());
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        printWriter.close();
        return;
    }

    /*
     * Loose catch block
     */
    private String[] getInputStrings(InputStream inputStream) throws ExecException {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader;
        block11: {
            String string;
            if (inputStream == null) {
                return null;
            }
            bufferedReader = null;
            arrayList = new ArrayList<String>();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            if (arrayList.size() >= 1) break block11;
            String[] stringArray = null;
            Object var8_7 = null;
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return stringArray;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Object var8_8 = null;
        try {
            bufferedReader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
        catch (Exception exception) {
            try {
                throw new ExecException(exception.getMessage());
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
    }

    private void redirectProcessOutput(Process process) throws ExecException {
        try {
            InputStream inputStream = process.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(this.mOutFile);
            new FlusherThread(inputStream, fileOutputStream).start();
        }
        catch (Exception exception) {
            throw new ExecException(exception.getMessage());
        }
    }

    private void redirectProcessError(Process process) throws ExecException {
        try {
            InputStream inputStream = process.getErrorStream();
            FileOutputStream fileOutputStream = new FileOutputStream(this.mErrFile);
            new FlusherThread(inputStream, fileOutputStream).start();
        }
        catch (Exception exception) {
            throw new ExecException(exception.getMessage());
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void main(String[] stringArray) throws Exception {
        ProcessExecutor processExecutor = new ProcessExecutor(new String[]{"dir"});
        processExecutor.execute();
    }
}

