/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.util.OS;

public class RestartInstanceCommand
extends BaseLifeCycleCommand {
    public RestartInstanceCommand() {
    }

    public RestartInstanceCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided"));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.isLocal()) {
            if (OS.isWindows()) {
                throw new CommandException(this.getLocalizedString("RestartNotSupportedOnWin2K"));
            }
            try {
                this.unsetLicenseLogger();
                IASLicense.checkCurrent((boolean)false);
                String string = this.getDomain();
                this.restartServerInstance(string, this.getInstanceOperand(0));
                this.printMessage(this.getLocalizedString("InstanceRestarted", new Object[]{this.getInstanceOperand(0)}));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Locally restarting instance, Exception caught ");
                this.printMessage(this.getLocalizedString("CannotRestartInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = this.getInstanceOperand(0);
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(string);
            appServerInstance.restart();
            this.printMessage(this.getLocalizedString("InstanceRestarted", new Object[]{string}));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(this.getLocalizedString("CannotRestartInstance"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

