/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.JMSResource;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseResourceCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class ListJMSResourcesCommand
extends BaseResourceCommand {
    private static final String RESOURCE_TYPE = "resourcetype";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            ServerModelIterator serverModelIterator = appServerInstance.getJMSResources();
            String string = this.getResourceType();
            if (serverModelIterator.hasNext()) {
                while (serverModelIterator.hasNext()) {
                    JMSResource jMSResource = (JMSResource)serverModelIterator.next();
                    String string2 = (String)jMSResource.getAttribute("resType");
                    if (string != null) {
                        if (!string2.equals(string)) continue;
                        this.printMessage(jMSResource);
                        continue;
                    }
                    this.printMessage(jMSResource);
                }
            } else {
                this.printMessage(this.getLocalizedString("NoJMSResources"));
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListJMSResources"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getResourceType() {
        Option option = this.findOption(RESOURCE_TYPE);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }
}

