/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateHttpQOSCommand
extends BaseOtherCommand {
    private static final String VS_CLASS_ID = "defaultclass";
    private static final String BW_LIMIT = "bwlimit";
    private static final String ENFORCE_BW_LIMIT = "enforcebwlimit";
    private static final String CONN_LIMIT = "connlimit";
    private static final String ENFORCE_CONN_LIMIT = "enforceconnlimit";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        String string = null;
        AttributeList attributeList = null;
        HttpServiceComponentBean httpServiceComponentBean = null;
        VirtualServer virtualServer = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            object = this.getServerInstanceManager();
            AppServerInstance appServerInstance = ((ServerInstanceManager)object).getServerInstance(this.getInstanceOperand(0));
            httpServiceComponentBean = appServerInstance.getHttpService();
            attributeList = this.getAttributeList();
            string = this.getVirtualServerOption();
            if (string == null) {
                httpServiceComponentBean.createHttpQos();
            } else {
                VirtualServerClass virtualServerClass = httpServiceComponentBean.getVirtualServerClass(VS_CLASS_ID);
                virtualServer = virtualServerClass.getVirtualServer(string);
                virtualServer.createHttpQos();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateQOS"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedQOS"));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                object = string == null ? httpServiceComponentBean.setAttributes(attributeList) : virtualServer.setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Attribute attribute;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(BW_LIMIT) != null) {
            attribute = new Attribute("bandwidthLimit", this.getIntegerOptionValue(BW_LIMIT));
            attributeList.add(attribute);
        }
        if (this.findOption(ENFORCE_BW_LIMIT) != null) {
            attribute = new Attribute("enforceBandwidthLimit", this.getBooleanOptionValue(ENFORCE_BW_LIMIT));
            attributeList.add(attribute);
        }
        if (this.findOption(CONN_LIMIT) != null) {
            attribute = new Attribute("connectionLimit", this.getIntegerOptionValue(CONN_LIMIT));
            attributeList.add(attribute);
        }
        if (this.findOption(ENFORCE_CONN_LIMIT) != null) {
            attribute = new Attribute("enforceConnectionLimit", this.getBooleanOptionValue(ENFORCE_CONN_LIMIT));
            attributeList.add(attribute);
        }
        return attributeList;
    }

    private String getVirtualServerOption() {
        Option option = this.findOption("virtualserver");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }
}

