/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.JMSDestinationInfo;
import com.iplanet.ias.admin.common.JMSObjectInfo;
import com.iplanet.ias.admin.common.JMSStatus;
import com.iplanet.ias.admin.common.exception.JMSAdminException;
import com.iplanet.ias.admin.servermodel.beans.JMSComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.HostAndPort;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMSComponentController
implements Controller {
    private static final String CREATE_JMS_OBJECT = "createJMSObject";
    private static final String LIST_JMS_OBJECTS = "listJMSObjects";
    private static final String DELETE_JMS_OBJECT = "deleteJMSObject";
    private static final String CREATE_JMS_DESTINATION = "createJMSDestination";
    private static final String DELETE_JMS_DESTINATION = "deleteJMSDestination";
    private static final String LIST_JMS_DESTINATIONS = "listJMSDestinations";
    private static final String PING_JMS_SERVICE = "JMSPing";
    private JMSComponentBean controllable;

    public JMSComponentController(JMSComponentBean jMSComponentBean) {
        this.controllable = jMSComponentBean;
    }

    public HostAndPort getBrokerHostAndPort() throws JMSAdminException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void startBroker() throws JMSAdminException {
    }

    public void stopBroker() throws JMSAdminException {
    }

    public void restartBroker() throws JMSAdminException {
    }

    public void createDestination(String string, String string2, Properties properties) throws JMSAdminException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        Object[] objectArray = new Object[]{string, string2, properties};
        this.invoke(CREATE_JMS_DESTINATION, objectArray, stringArray);
    }

    public void purgeDestination(String string, String string2) throws JMSAdminException {
    }

    public void destroyDestination(String string, String string2) throws JMSAdminException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(DELETE_JMS_DESTINATION, objectArray, stringArray);
    }

    public JMSDestinationInfo[] getAllDestinations(String string) throws JMSAdminException {
        JMSDestinationInfo[] jMSDestinationInfoArray = (JMSDestinationInfo[])this.invoke(LIST_JMS_DESTINATIONS, new Object[]{string}, new String[]{"java.lang.String"});
        return jMSDestinationInfoArray;
    }

    public Properties getBrokerProperties() throws JMSAdminException {
        return new Properties();
    }

    public Properties getDestinationProperties(String string, String string2) throws JMSAdminException {
        return new Properties();
    }

    public void createAdministeredObject(String string, String string2, Properties properties) throws JMSAdminException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        Object[] objectArray = new Object[]{string, string2, properties};
        this.invoke(CREATE_JMS_OBJECT, objectArray, stringArray);
    }

    public void deleteAdministeredObject(String string) throws JMSAdminException {
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_JMS_OBJECT, objectArray, stringArray);
    }

    public String getStatus() throws JMSAdminException {
        JMSStatus jMSStatus = (JMSStatus)this.invoke(PING_JMS_SERVICE, null, null);
        Assert.assertit(jMSStatus != null, "null value returned");
        return jMSStatus.getStatusString();
    }

    public String getStatus(String string, String string2, int n) throws JMSAdminException {
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "int"};
        Object[] objectArray = new Object[]{string, string2, new Integer(n)};
        JMSStatus jMSStatus = (JMSStatus)this.invoke(PING_JMS_SERVICE, objectArray, stringArray);
        Assert.assertit(jMSStatus != null, "null value returned");
        return jMSStatus.getStatusString();
    }

    public void updateAdministeredObject(String string, Properties properties) throws JMSAdminException {
    }

    public Properties getAdministeredObjectProperties(String string) throws JMSAdminException {
        return new Properties();
    }

    public JMSObjectInfo[] getAdministeredObjects(String string) throws JMSAdminException {
        JMSObjectInfo[] jMSObjectInfoArray = (JMSObjectInfo[])this.invoke(LIST_JMS_OBJECTS, new Object[]{string}, new String[]{"java.lang.String"});
        return jMSObjectInfoArray;
    }

    public void addUser(String string) throws JMSAdminException {
    }

    public void addUserToGroup(String string, String string2) throws JMSAdminException {
    }

    public void deleteUser(String string) throws JMSAdminException {
    }

    public void deleteUserFromGroup(String string, String string2) throws JMSAdminException {
    }

    public String[] getAllUsers() throws JMSAdminException {
        return null;
    }

    public String[] getAllUsersInGroup(String string) throws JMSAdminException {
        return null;
    }

    public String[] getAllGroups() throws JMSAdminException {
        return null;
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws JMSAdminException {
        Object object = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(this.controllable.getIdentifier());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new JMSAdminException(malformedObjectNameException.getLocalizedMessage());
        }
        Assert.assertit(objectName != null, "null value returned");
        try {
            ContextHolder contextHolder = this.controllable.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            if (exception instanceof JMSAdminException) {
                throw (JMSAdminException)exception;
            }
            throw new JMSAdminException(exception.getLocalizedMessage());
        }
        return object;
    }
}

