/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.Constraint;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintConstant;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintForeignField;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintParamIndex;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintSubquery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputParamValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ArrayList;
import java.util.ResourceBundle;

public abstract class Statement
implements Cloneable {
    private static Logger logger = LogHelperSQLStore.getLogger();
    private static final Integer ONE = new Integer(1);
    protected static final int OP_BINOP_MASK = 1058;
    protected static final int OP_FUNC_MASK = 553;
    protected static final int OP_INFIX_MASK = 2;
    protected static final int OP_IRREGULAR_MASK = 64;
    protected static final int OP_NONSQL_MASK = 128;
    protected static final int OP_ORDERBY_MASK = 16;
    protected static final int OP_OTHER_MASK = 256;
    protected static final int OP_PARAM_MASK = 512;
    protected static final int OP_PAREN_MASK = 8;
    protected static final int OP_PCOUNT_MASK = 1536;
    protected static final int OP_POSTFIX_MASK = 4;
    protected static final int OP_PREFIX_MASK = 1;
    protected static final int OP_UNOP_MASK = 512;
    protected static final int OP_WHERE_MASK = 32;
    public StringBuffer statementText;
    protected String quoteCharStart = "";
    protected String quoteCharEnd = "";
    public ArrayList columns;
    public Constraint constraint;
    public InputDesc inputDesc = new InputDesc();
    public int action;
    public QueryPlan plan;
    public ArrayList tableList;
    public int minAffectedRows;
    protected DBVendorType vendorType;
    protected ArrayList secondaryTableStatements;
    protected ArrayList subtableStatements;
    protected int properties;
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$Statement == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$Statement = Statement.class$("com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement")) : class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$Statement).getClassLoader());
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$sql$generator$Statement;
    static /* synthetic */ Class class$java$lang$String;

    public Statement(DBVendorType dBVendorType, QueryPlan queryPlan) {
        this.columns = new ArrayList();
        this.constraint = new Constraint();
        this.tableList = new ArrayList();
        this.vendorType = dBVendorType;
        this.plan = queryPlan;
        if (!dBVendorType.getQuoteSpecialOnly()) {
            this.quoteCharStart = dBVendorType.getQuoteCharStart();
            this.quoteCharEnd = dBVendorType.getQuoteCharEnd();
        }
        this.minAffectedRows = 1;
    }

    public void setProperty(int n) {
        this.properties |= n;
    }

    public boolean getProperty(int n) {
        return (this.properties & n) > 0;
    }

    public void addQueryTable(QueryTable queryTable) {
        if (this.tableList.indexOf(queryTable) == -1) {
            this.tableList.add(queryTable);
        }
    }

    protected ColumnRef getColumnRef(ColumnElement columnElement) {
        int n = this.columns.size();
        int n2 = 0;
        while (n2 < n) {
            ColumnRef columnRef = (ColumnRef)this.columns.get(n2);
            if (columnRef.getColumnElement() == columnElement) {
                return columnRef;
            }
            ++n2;
        }
        return null;
    }

    protected void addColumnRef(ColumnRef columnRef) {
        columnRef.setIndex(this.columns.size() + 1);
        this.columns.add(columnRef);
    }

    public void addConstraint(LocalFieldDesc localFieldDesc, Object object) {
        if (object == null) {
            this.constraint.addField(localFieldDesc);
            this.constraint.addOperation(28);
        } else if (localFieldDesc.isPrimitiveMappedToNullableColumn() || this.vendorType.mapEmptyStringToNull() && localFieldDesc.getType() == (class$java$lang$String == null ? (class$java$lang$String = Statement.class$("java.lang.String")) : class$java$lang$String)) {
            this.constraint.addValue(object);
            this.constraint.addField(localFieldDesc);
            this.constraint.addOperation(54);
        } else {
            this.constraint.addValue(object);
            this.constraint.addField(localFieldDesc);
            this.constraint.addOperation(9);
        }
    }

    public DBVendorType getVendorType() {
        return this.vendorType;
    }

    public QueryPlan getQueryPlan() {
        return this.plan;
    }

    public void clear(boolean bl) {
        this.statementText = null;
        int n = 0;
        while (n < this.tableList.size()) {
            QueryTable queryTable = (QueryTable)this.tableList.get(n);
            queryTable.nextTable = null;
            queryTable.prevTable = null;
            ++n;
        }
        this.inputDesc.values.clear();
        if (bl) {
            this.columns.clear();
        }
    }

    public void getTableText(QueryTable queryTable, StringBuffer stringBuffer) {
        stringBuffer.append(this.quoteCharStart);
        stringBuffer.append(queryTable.getTableDesc().getName());
        stringBuffer.append(this.quoteCharEnd);
        stringBuffer.append(" t");
        stringBuffer.append(queryTable.getTableIndex());
    }

    public abstract String getText();

    public abstract String processConstraints();

    protected String getWhereText(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        Statement statement = this;
        if (arrayList.size() == 0) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
        }
        ConstraintNode constraintNode = (ConstraintNode)arrayList.get(arrayList.size() - 1);
        arrayList.remove(arrayList.size() - 1);
        if (constraintNode instanceof ConstraintParamIndex) {
            this.processConstraintParamIndex((ConstraintParamIndex)constraintNode, stringBuffer);
        } else if (constraintNode instanceof ConstraintValue) {
            this.processConstraintValue((ConstraintValue)constraintNode, stringBuffer);
        } else if (constraintNode instanceof ConstraintForeignField) {
            stringBuffer.append("?");
            statement.inputDesc.values.add(new InputValue(((ConstraintForeignField)constraintNode).foreignField, null));
        } else if (constraintNode instanceof ConstraintField) {
            this.processConstraintField(constraintNode, stringBuffer);
        } else if (constraintNode instanceof ConstraintConstant) {
            stringBuffer.append(((ConstraintConstant)constraintNode).value.toString());
        } else if (constraintNode instanceof ConstraintOperation) {
            this.processConstraintOperation(constraintNode, stringBuffer, arrayList);
        } else {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalnode", constraintNode.getClass().getName()));
        }
        return stringBuffer.toString();
    }

    protected void processConstraintParamIndex(ConstraintParamIndex constraintParamIndex, StringBuffer stringBuffer) {
        stringBuffer.append(this.vendorType.getParameterMarker(constraintParamIndex.getType()));
        Object object = constraintParamIndex.value;
        this.inputDesc.values.add(new InputParamValue(object));
    }

    protected void processConstraintValue(ConstraintValue constraintValue, StringBuffer stringBuffer) {
        Object object;
        boolean bl = false;
        String string = "?";
        if ("DB2".equals(this.vendorType.getName()) && (object = constraintValue.value) != null && object instanceof Number) {
            bl = true;
            string = object.toString();
        }
        stringBuffer.append(string);
        if (!bl) {
            this.inputDesc.values.add(new InputValue(null, constraintValue.value));
        }
    }

    private void processConstraintField(ConstraintNode constraintNode, StringBuffer stringBuffer) {
        int n;
        Object object;
        LocalFieldDesc localFieldDesc;
        block15: {
            QueryPlan queryPlan = this.plan;
            if (((ConstraintField)constraintNode).originalPlan != null) {
                queryPlan = ((ConstraintField)constraintNode).originalPlan;
            }
            ArrayList arrayList = null;
            arrayList = this.action == 4 ? queryPlan.tables : this.tableList;
            localFieldDesc = null;
            if (constraintNode instanceof ConstraintFieldDesc) {
                localFieldDesc = ((ConstraintFieldDesc)constraintNode).desc;
            } else if (constraintNode instanceof ConstraintFieldName) {
                object = (ConstraintFieldName)constraintNode;
                FieldDesc fieldDesc = queryPlan.config.getField(((ConstraintFieldName)object).name);
                if (fieldDesc == null) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.unknownfield", ((ConstraintFieldName)object).name, queryPlan.config.getPersistenceCapableClass().getName()));
                }
                if (!(fieldDesc instanceof LocalFieldDesc)) {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", fieldDesc.getClass().getName(), "SqlLocalFieldDesc"));
                }
                localFieldDesc = (LocalFieldDesc)fieldDesc;
            } else {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintFieldDesc/ConstraintFieldName"));
            }
            object = null;
            n = -1;
            try {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    QueryTable queryTable = (QueryTable)arrayList.get(n2);
                    int n3 = 0;
                    while (n3 < localFieldDesc.columnDescs.size()) {
                        if (((ColumnElement)localFieldDesc.columnDescs.get(n3)).getDeclaringTable() == queryTable.getTableDesc().getTableElement()) {
                            n = n3;
                            object = queryTable;
                            break block15;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                logger.log(900, "sqlstore.exception.log", throwable);
            }
        }
        if (n == -1) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.fieldnotable", localFieldDesc.getName()));
        }
        if (this.action == 4) {
            stringBuffer.append("t").append(((QueryTable)object).getTableIndex()).append(".").append(this.quoteCharStart).append(((ColumnElement)localFieldDesc.columnDescs.get(n)).getName().getName()).append(this.quoteCharEnd);
        } else {
            stringBuffer.append(this.quoteCharStart).append(((ColumnElement)localFieldDesc.columnDescs.get(n)).getName().getName()).append(this.quoteCharEnd);
        }
    }

    private void processConstraintOperation(ConstraintNode constraintNode, StringBuffer stringBuffer, ArrayList arrayList) {
        int n = ((ConstraintOperation)constraintNode).operation;
        int n2 = this.operationFormat(n);
        if ((n2 & 0x40) == 0) {
            if ((n2 & 1) > 0) {
                stringBuffer.append(this.prefixOperator(n));
            }
            if ((n2 & 0x600) > 0) {
                if ((n2 & 8) > 0) {
                    stringBuffer.append("(");
                }
                stringBuffer.append(this.getWhereText(arrayList));
                int n3 = 0;
                while (n3 < (n2 & 0x600) / 512 - 1) {
                    if ((n2 & 2) > 0) {
                        stringBuffer.append(this.infixOperator(n, n3 - 1));
                    } else {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.getWhereText(arrayList));
                    ++n3;
                }
                if ((n2 & 8) > 0) {
                    stringBuffer.append(")");
                }
            }
            if ((n2 & 4) > 0) {
                stringBuffer.append(this.postfixOperator(n));
            }
        } else {
            switch (n) {
                case 27: 
                case 28: {
                    this.processNullOperation(n, arrayList, stringBuffer);
                    break;
                }
                case 6: {
                    if (arrayList.size() < 3) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    if (!(arrayList.get(arrayList.size() - 1) instanceof ConstraintField)) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
                    }
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(" between ");
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(" and ");
                    stringBuffer.append(this.getWhereText(arrayList));
                    break;
                }
                case 10: 
                case 16: 
                case 33: {
                    this.processJoinOperation(constraintNode, stringBuffer, n, n2);
                    break;
                }
                case 14: 
                case 55: {
                    this.processInOperation(n, arrayList, stringBuffer);
                    break;
                }
                case 37: {
                    if (arrayList.size() < 2) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    stringBuffer.append(this.vendorType.getSubstring());
                    stringBuffer.append("(");
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(this.vendorType.getSubstringFrom());
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(")");
                    break;
                }
                case 45: 
                case 46: {
                    if (!(constraintNode instanceof ConstraintSubquery)) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintJoin"));
                    }
                    ConstraintSubquery constraintSubquery = (ConstraintSubquery)constraintNode;
                    stringBuffer.append(this.prefixOperator(n));
                    stringBuffer.append("(");
                    Statement statement = (Statement)constraintSubquery.plan.statements.get(0);
                    stringBuffer.append(statement.getText());
                    stringBuffer.append(")");
                    break;
                }
                case 48: {
                    if (arrayList.size() < 3) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    if (this.vendorType.supportsLikeEscape()) {
                        if (!(arrayList.get(arrayList.size() - 1) instanceof ConstraintField)) {
                            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
                        }
                        stringBuffer.append(this.getWhereText(arrayList));
                        stringBuffer.append(" LIKE ");
                        stringBuffer.append(this.getWhereText(arrayList));
                        stringBuffer.append(this.vendorType.getLeftLikeEscape());
                        stringBuffer.append(" ESCAPE ");
                        stringBuffer.append(this.getWhereText(arrayList));
                        stringBuffer.append(this.vendorType.getRightLikeEscape());
                        break;
                    }
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.sql.generator.statement.likeescapenotsupported"));
                }
                case 49: {
                    if (arrayList.size() < 3) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    stringBuffer.append(this.vendorType.getSubstring());
                    stringBuffer.append("(");
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(this.vendorType.getSubstringFrom());
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(this.vendorType.getSubstringFor());
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(")");
                    break;
                }
                case 50: {
                    if (arrayList.size() < 2) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    stringBuffer.append(this.vendorType.getPosition());
                    stringBuffer.append("(");
                    boolean bl = this.vendorType.isPositionSearchSource();
                    if (bl) {
                        ConstraintNode constraintNode2 = (ConstraintNode)arrayList.remove(arrayList.size() - 1);
                        ConstraintNode constraintNode3 = (ConstraintNode)arrayList.remove(arrayList.size() - 1);
                        arrayList.add(constraintNode2);
                        arrayList.add(constraintNode3);
                    }
                    stringBuffer.append(this.getWhereText(arrayList));
                    stringBuffer.append(this.vendorType.getPositionSep());
                    stringBuffer.append(" ").append(this.getWhereText(arrayList));
                    stringBuffer.append(")");
                    break;
                }
                case 51: {
                    if (arrayList.size() < 3) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
                    }
                    String string = this.vendorType.getName();
                    boolean bl = this.vendorType.isPositionSearchSource();
                    boolean bl2 = this.vendorType.isPositionThreeArgs();
                    if (bl2) {
                        if (bl) {
                            ConstraintNode constraintNode4 = (ConstraintNode)arrayList.remove(arrayList.size() - 1);
                            ConstraintNode constraintNode5 = (ConstraintNode)arrayList.remove(arrayList.size() - 1);
                            arrayList.add(constraintNode4);
                            arrayList.add(constraintNode5);
                        }
                        stringBuffer.append(this.vendorType.getPosition());
                        stringBuffer.append("(");
                        stringBuffer.append(this.getWhereText(arrayList));
                        stringBuffer.append(this.vendorType.getPositionSep());
                        stringBuffer.append(" ").append(this.getWhereText(arrayList));
                        stringBuffer.append(this.vendorType.getPositionSep());
                        stringBuffer.append(" ").append(this.getWhereText(arrayList));
                        stringBuffer.append(")");
                        break;
                    }
                    ConstraintValue constraintValue = (ConstraintValue)arrayList.remove(arrayList.size() - 3);
                    if (constraintValue != null && ONE.equals(constraintValue.value)) {
                        arrayList.add(new ConstraintOperation(50));
                        stringBuffer.append(this.getWhereText(arrayList));
                        break;
                    }
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "sqlstore.sql.generator.statement.positionthreeargsnotsupported"));
                }
                case 54: {
                    this.processMaybeNullOperation(arrayList, stringBuffer);
                    break;
                }
                default: {
                    throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "" + n));
                }
            }
        }
    }

    private void processJoinOperation(ConstraintNode constraintNode, StringBuffer stringBuffer, int n, int n2) {
        if (!(constraintNode instanceof ConstraintJoin) || this.action != 4) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintJoin"));
        }
        ConstraintJoin constraintJoin = (ConstraintJoin)constraintNode;
        boolean bl = n != 10 && !"ORACLE".equals(this.vendorType.getName()) && !"SYBASE".equals(this.vendorType.getName());
        String string = null;
        string = bl ? new String(" = ") : this.infixOperator(n, 1);
        this.plan.options = n == 10 ? (this.plan.options |= 4) : (this.plan.options |= 8);
        QueryPlan queryPlan = ((ConstraintJoin)constraintNode).fromPlan;
        QueryPlan queryPlan2 = ((ConstraintJoin)constraintNode).toPlan;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < constraintJoin.fromColumns.size()) {
            QueryTable queryTable;
            QueryTable queryTable2 = queryPlan.findQueryTable(((ColumnElement)constraintJoin.fromColumns.get(n3)).getDeclaringTable());
            if (queryTable2 == null) {
                // empty if block
            }
            if ((queryTable = queryPlan2.findQueryTable(((ColumnElement)constraintJoin.toColumns.get(n3)).getDeclaringTable())) == null) {
                // empty if block
            }
            if (!bl) {
                this.addQueryTable(queryTable2);
                this.addQueryTable(queryTable);
                queryTable.prevTable = null;
            } else {
                if (queryTable.prevTable != null) {
                    // empty if block
                }
                if (queryTable2.nextTable == null) {
                    queryTable2.nextTable = new ArrayList();
                    queryTable2.nextTable.add(queryTable);
                    queryTable.prevTable = queryTable2;
                } else if ((this.plan.options & 0x200) == 0 && !queryTable2.nextTable.contains(queryTable)) {
                    queryTable2.nextTable.add(queryTable);
                    queryTable.prevTable = queryTable2;
                }
                if (queryTable.prevTable != null) {
                    stringBuffer.append("t").append(queryTable2.getTableIndex()).append(".").append(this.quoteCharStart).append(((ColumnElement)constraintJoin.fromColumns.get(n3)).getName().getName()).append(this.quoteCharEnd).append(" = t").append(queryTable.getTableIndex()).append(".").append(this.quoteCharStart).append(((ColumnElement)constraintJoin.toColumns.get(n3)).getName().getName()).append(this.quoteCharEnd);
                }
                if (!"INFORMIX".equals(this.vendorType.getName())) {
                    if (queryTable.onClause == null) {
                        queryTable.onClause = new StringBuffer().append(stringBuffer.toString());
                    } else {
                        queryTable.onClause.append(" and ");
                        queryTable.onClause.append(stringBuffer);
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
            if (bl) {
                queryTable2.joinOp = n;
            }
            if (!bl || "INFORMIX".equals(this.vendorType.getName())) {
                if (bl2) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("t").append(queryTable2.getTableIndex()).append(".").append(this.quoteCharStart).append(((ColumnElement)constraintJoin.fromColumns.get(n3)).getName().getName()).append(this.quoteCharEnd).append(" ").append(string).append(" t").append(queryTable.getTableIndex()).append(".").append(this.quoteCharStart).append(((ColumnElement)constraintJoin.toColumns.get(n3)).getName().getName()).append(this.quoteCharEnd);
                if ((n2 & 4) > 0) {
                    stringBuffer.append(this.postfixOperator(n));
                }
                bl2 = true;
            }
            ++n3;
        }
    }

    private void processMaybeNullOperation(ArrayList arrayList, StringBuffer stringBuffer) {
        ConstraintValue constraintValue = null;
        ConstraintField constraintField = null;
        if (arrayList.size() < 2) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
        }
        if (!(arrayList.get(arrayList.size() - 1) instanceof ConstraintField)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
        }
        constraintField = (ConstraintField)arrayList.get(arrayList.size() - 1);
        arrayList.remove(arrayList.size() - 1);
        if (!(arrayList.get(arrayList.size() - 1) instanceof ConstraintValue)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needvalnode"));
        }
        constraintValue = (ConstraintValue)arrayList.get(arrayList.size() - 1);
        arrayList.remove(arrayList.size() - 1);
        if (constraintValue.value instanceof String) {
            String string = (String)constraintValue.value;
            if (string.length() == 0) {
                arrayList.add(constraintField);
                arrayList.add(new ConstraintOperation(28));
            } else {
                arrayList.add(constraintValue);
                arrayList.add(constraintField);
                arrayList.add(new ConstraintOperation(9));
            }
        } else {
            arrayList.add(constraintValue);
            arrayList.add(constraintField);
            arrayList.add(new ConstraintOperation(9));
            boolean bl = false;
            if (constraintValue.value instanceof Number && ((Number)constraintValue.value).doubleValue() == 0.0) {
                bl = true;
            } else if (constraintValue.value instanceof Boolean && !((Boolean)constraintValue.value).booleanValue()) {
                bl = true;
            } else if (constraintValue.value instanceof Character && ((Character)constraintValue.value).charValue() == '\u0000') {
                bl = true;
            }
            if (bl) {
                arrayList.add(constraintField);
                arrayList.add(new ConstraintOperation(28));
                arrayList.add(new ConstraintOperation(29));
            }
        }
        if (arrayList.size() > 0) {
            stringBuffer.append(this.getWhereText(arrayList));
        }
    }

    private void processNullOperation(int n, ArrayList arrayList, StringBuffer stringBuffer) {
        Object object;
        String string = this.vendorType.getNullComparisonFunctionName();
        if (string.length() != 0) {
            object = arrayList.get(arrayList.size() - 1);
            if (object != null) {
                if (object instanceof ConstraintFieldName) {
                    FieldDesc fieldDesc;
                    ConstraintFieldName constraintFieldName = (ConstraintFieldName)object;
                    QueryPlan queryPlan = this.plan;
                    if (constraintFieldName.originalPlan != null) {
                        queryPlan = constraintFieldName.originalPlan;
                    }
                    if ((fieldDesc = queryPlan.config.getField(constraintFieldName.name)).isByteArrayType()) {
                        arrayList.add(new ConstraintOperation(56));
                    }
                }
            } else {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
            }
        }
        stringBuffer.append(this.getWhereText(arrayList));
        object = n == 28 ? this.vendorType.getIsNull() : this.vendorType.getIsNotNull();
        stringBuffer.append((String)object);
    }

    private void processInOperation(int n, ArrayList arrayList, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (arrayList.size() < 2) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.stackempty"));
        }
        stringBuffer.append("(");
        if (!(arrayList.get(arrayList.size() - 1) instanceof ConstraintField)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.needfieldnode"));
        }
        stringBuffer2.append(this.getWhereText(arrayList));
        while (arrayList.size() > 1 && arrayList.get(arrayList.size() - 1) instanceof ConstraintField) {
            stringBuffer2.replace(0, 0, ", ");
            stringBuffer2.replace(0, 0, this.getWhereText(arrayList));
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(") ");
        if (n == 55) {
            stringBuffer.append("not ");
        }
        stringBuffer.append("in (");
        ConstraintNode constraintNode = (ConstraintNode)arrayList.remove(arrayList.size() - 1);
        if (!(constraintNode instanceof ConstraintSubquery)) {
            throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintSubquery"));
        }
        ConstraintSubquery constraintSubquery = (ConstraintSubquery)constraintNode;
        Statement statement = (Statement)constraintSubquery.plan.statements.get(0);
        stringBuffer.append(statement.getText());
        stringBuffer.append(")");
        this.inputDesc.values.addAll(statement.inputDesc.values);
    }

    protected String infixOperator(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 2: {
                stringBuffer.append(" + ");
                break;
            }
            case 3: {
                stringBuffer.append(" and ");
                break;
            }
            case 8: {
                stringBuffer.append(" / ");
                break;
            }
            case 9: {
                stringBuffer.append(" = ");
                break;
            }
            case 10: {
                stringBuffer.append(" = ");
                break;
            }
            case 12: {
                stringBuffer.append(" >= ");
                break;
            }
            case 13: {
                stringBuffer.append(" > ");
                break;
            }
            case 15: {
                stringBuffer.append(" <= ");
                break;
            }
            case 21: {
                stringBuffer.append(" < ");
                break;
            }
            case 25: {
                stringBuffer.append(" != ");
                break;
            }
            case 29: {
                stringBuffer.append(" or ");
                break;
            }
            case 19: {
                stringBuffer.append(" like ");
                break;
            }
            case 24: {
                stringBuffer.append(" * ");
                break;
            }
            case 36: {
                stringBuffer.append(" - ");
                break;
            }
            case 6: {
                if (n2 == 1) {
                    stringBuffer.append(" between ");
                    break;
                }
                stringBuffer.append(" and ");
                break;
            }
            case 44: {
                stringBuffer.append(this.vendorType.getStringConcat());
                break;
            }
            case 16: {
                stringBuffer.append(this.vendorType.getLeftJoin());
                break;
            }
            case 33: {
                stringBuffer.append(this.vendorType.getRightJoin());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "" + n));
            }
        }
        return stringBuffer.toString();
    }

    protected int operationFormat(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 553;
                break;
            }
            case 2: {
                n2 = 1066;
                break;
            }
            case 4: {
                n2 = 96;
                break;
            }
            case 3: {
                n2 = 1058;
                break;
            }
            case 6: {
                n2 = 96;
                break;
            }
            case 48: {
                n2 = 96;
                break;
            }
            case 7: {
                n2 = 256;
                break;
            }
            case 8: {
                n2 = 1066;
                break;
            }
            case 9: {
                n2 = 1058;
                break;
            }
            case 41: {
                n2 = 128;
                break;
            }
            case 10: {
                n2 = 96;
                break;
            }
            case 11: {
                n2 = 256;
                break;
            }
            case 12: {
                n2 = 1058;
                break;
            }
            case 13: {
                n2 = 1058;
                break;
            }
            case 14: 
            case 55: {
                n2 = 96;
                break;
            }
            case 15: {
                n2 = 1058;
                break;
            }
            case 17: {
                n2 = 553;
                break;
            }
            case 18: {
                n2 = 553;
                break;
            }
            case 19: {
                n2 = 1058;
                break;
            }
            case 20: {
                n2 = 553;
                break;
            }
            case 21: {
                n2 = 1058;
                break;
            }
            case 22: {
                n2 = 553;
                break;
            }
            case 23: {
                n2 = 128;
                break;
            }
            case 24: {
                n2 = 1058;
                break;
            }
            case 25: {
                n2 = 1058;
                break;
            }
            case 26: {
                n2 = 553;
                break;
            }
            case 27: 
            case 28: {
                n2 = 608;
                break;
            }
            case 29: {
                n2 = 1066;
                break;
            }
            case 30: {
                n2 = 16;
                break;
            }
            case 31: {
                n2 = 16;
                break;
            }
            case 47: {
                n2 = 553;
                break;
            }
            case 35: {
                n2 = 553;
                break;
            }
            case 36: {
                n2 = 1066;
                break;
            }
            case 37: {
                n2 = 64;
                break;
            }
            case 49: {
                n2 = 64;
                break;
            }
            case 38: {
                n2 = 1065;
                break;
            }
            case 50: {
                n2 = 64;
                break;
            }
            case 51: {
                n2 = 64;
                break;
            }
            case 54: {
                n2 = 96;
                break;
            }
            case 44: {
                n2 = 1066;
                break;
            }
            case 39: {
                n2 = 553;
                break;
            }
            case 16: {
                n2 = 98;
                n2 |= 4;
                break;
            }
            case 33: {
                n2 = 98;
                n2 |= 1;
                break;
            }
            case 34: {
                n2 = 553;
                String string = this.vendorType.getName();
                if (!"INFORMIX".equals(string) && !"RDB".equals(string) && !"POINTBASE".equals(string) && !"SQL92".equals(string)) break;
                n2 = 549;
                break;
            }
            case 43: {
                n2 = 0;
                n2 = this.operationFormat(34);
                break;
            }
            case 45: 
            case 46: {
                n2 = 97;
                break;
            }
            case 56: {
                n2 = 553;
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "" + n));
            }
        }
        return n2;
    }

    protected String postfixOperator(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 34: {
                stringBuffer.append(this.vendorType.getRtrimPost());
                break;
            }
            case 43: {
                stringBuffer.append(this.postfixOperator(34));
                break;
            }
            case 16: {
                stringBuffer.append(this.vendorType.getLeftJoinPost());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "" + n));
            }
        }
        return stringBuffer.toString();
    }

    protected String prefixOperator(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                stringBuffer.append(this.vendorType.getAbs());
                break;
            }
            case 17: {
                stringBuffer.append(this.vendorType.getCharLength());
                break;
            }
            case 34: {
                stringBuffer.append(this.vendorType.getRtrim());
                break;
            }
            case 43: {
                stringBuffer.append(this.prefixOperator(34));
                break;
            }
            case 26: {
                stringBuffer.append("not ");
                break;
            }
            case 33: {
                stringBuffer.append(this.vendorType.getRightJoinPre());
                break;
            }
            case 47: {
                stringBuffer.append(this.vendorType.getSqrt());
                break;
            }
            case 45: {
                stringBuffer.append("not exists ");
                break;
            }
            case 46: {
                stringBuffer.append("exists ");
                break;
            }
            case 56: {
                stringBuffer.append(this.vendorType.getNullComparisonFunctionName());
                break;
            }
            default: {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.constraint.illegalop", "" + n));
            }
        }
        return stringBuffer.toString();
    }

    public void setText(String string) {
        this.statementText = new StringBuffer().append(string);
    }

    public void addSecondaryTableStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        if (this.secondaryTableStatements == null) {
            this.secondaryTableStatements = new ArrayList();
        }
        this.secondaryTableStatements.add(statement);
    }

    public ArrayList getSecondaryTableStatements() {
        return this.secondaryTableStatements;
    }

    public void addSubtableStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        if (this.subtableStatements == null) {
            this.subtableStatements = new ArrayList();
        }
        this.subtableStatements.add(statement);
    }

    public ArrayList getSubtableStatements() {
        return this.subtableStatements;
    }

    public ArrayList getQueryTables() {
        return this.tableList;
    }

    public ArrayList getColumnRefs() {
        return this.columns;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public int getAction() {
        return this.action;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

