/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldInfo {
    protected String name;
    protected ClassType classType;
    protected Field field;
    protected PersistenceFieldElement pfe;

    public FieldInfo(Field field, ClassType classType) {
        this.name = field.getName();
        this.classType = classType;
        this.field = field;
        this.pfe = classType.pce != null ? classType.pce.getField(this.name) : null;
    }

    public boolean isPersistent() {
        if (this.pfe != null) {
            return this.pfe.getPersistenceType() == 0;
        }
        return false;
    }

    public boolean isPublic() {
        return this.field != null && Modifier.isPublic(this.field.getModifiers());
    }

    public boolean isStatic() {
        return this.field != null && Modifier.isStatic(this.field.getModifiers());
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        if (this.field == null) {
            TypeTable cfr_ignored_0 = this.classType.typetab;
            return TypeTable.errorType;
        }
        Type type = this.classType.typetab.checkType(this.field.getType());
        if (type == null) {
            TypeTable cfr_ignored_1 = this.classType.typetab;
            type = TypeTable.errorType;
        }
        return type;
    }

    public int getFieldNumber() {
        if (this.pfe != null) {
            int n = this.pfe.getFieldNumber();
            if (n < 0) {
                throw new JDOFatalInternalException("FieldInfo.getFieldNumber: invalid field number " + n + " for field '" + this.name + "'");
            }
            return n;
        }
        throw new JDOFatalInternalException("FieldInfo.getFieldNumber: missing PersistenceFieldElement for field '" + this.name + "'");
    }

    public boolean isRelationship() {
        return this.pfe != null && this.pfe instanceof RelationshipElement;
    }

    public Type getAssociatedClass() {
        Type type = null;
        if (this.pfe != null && this.pfe instanceof RelationshipElement) {
            String string = ((RelationshipElement)this.pfe).getElementClass();
            type = this.classType.typetab.checkType(string);
        }
        return type;
    }
}

