/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.connection;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.CallableStatementImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionManager;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.PreparedStatementImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.StatementImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.Linkable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class ConnectionImpl
implements Connection,
Linkable {
    private Connection connection;
    private String url;
    private String userName;
    Linkable previous;
    Linkable next;
    private boolean pooled;
    private Transaction transaction;
    boolean freePending;
    ConnectionManager connectionManager;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public ConnectionImpl(Connection connection, String string, String string2, ConnectionManager connectionManager) {
        this.connection = connection;
        this.url = string;
        this.userName = string2;
        this.previous = null;
        this.next = null;
        this.pooled = false;
        this.transaction = null;
        this.freePending = false;
        this.connectionManager = connectionManager;
    }

    public synchronized Statement createStatement() throws SQLException {
        this.checkXact();
        StatementImpl statementImpl = new StatementImpl(this, this.connection.createStatement());
        return statementImpl;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return null;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkXact();
        PreparedStatementImpl preparedStatementImpl = new PreparedStatementImpl(this, this.connection.prepareStatement(string));
        return preparedStatementImpl;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkXact();
        CallableStatementImpl callableStatementImpl = new CallableStatementImpl(this, this.connection.prepareCall(string));
        return callableStatementImpl;
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        return this.connection.nativeSQL(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.connection.setAutoCommit(bl);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public synchronized void commit() throws SQLException {
        this.connection.commit();
        if (this.freePending) {
            if (this.connectionManager.shutDownPending) {
                try {
                    this.connection.close();
                    logger.finest("sqlstore.connectionimpl.commit");
                }
                catch (SQLException sQLException) {}
            } else {
                this.freePending = false;
                this.connectionManager.freeList.insertAtTail(this);
            }
        }
        if (EJBHelper.isManaged()) {
            this.closeInternal();
        }
    }

    public synchronized void rollback() throws SQLException {
        logger.finest("sqlstore.connectionimpl.rollback");
        this.connection.rollback();
        if (this.freePending) {
            if (this.connectionManager.shutDownPending) {
                this.connection.close();
                logger.finest("sqlstore.connectionimpl.rollback.close");
            } else {
                this.freePending = false;
                this.connectionManager.freeList.insertAtTail(this);
            }
        }
        if (EJBHelper.isManaged()) {
            this.closeInternal();
        }
    }

    public synchronized void close() throws SQLException {
        if (EJBHelper.isManaged()) {
            logger.finest("sqlstore.connectionimpl.close");
            return;
        }
        this.closeInternal();
    }

    private synchronized void closeInternal() throws SQLException {
        boolean bl = logger.isLoggable(300);
        ConnectionImpl connectionImpl = this;
        if (bl) {
            logger.finest("sqlstore.connectionimpl.close_arg", connectionImpl);
        }
        connectionImpl.connectionManager.busyList.removeFromList(connectionImpl);
        if (connectionImpl.xactPending()) {
            connectionImpl.setFreePending(true);
            if (bl) {
                logger.finest("sqlstore.connectionimpl.close.freepending");
            }
        } else if (connectionImpl.getPooled() && !connectionImpl.connectionManager.shutDownPending) {
            connectionImpl.connectionManager.freeList.insertAtTail(connectionImpl);
            if (bl) {
                logger.finest("sqlstore.connectionimpl.close.putfreelist");
            }
        } else if (EJBHelper.isManaged()) {
            this.connection.close();
            if (bl) {
                logger.finest("sqlstore.connectionimpl.close.exit");
            }
        } else {
            this.connectionManager.replaceFreeConnection(this);
            if (bl) {
                logger.finest("sqlstore.connectionimpl.close.replaced");
            }
        }
    }

    protected void release() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        logger.finest("sqlstore.connectionimpl.close.connrelease");
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.connection.setReadOnly(bl);
    }

    public synchronized boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.connection.setCatalog(string);
    }

    public synchronized String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.connection.setTransactionIsolation(n);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public synchronized void setHoldability(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    synchronized void checkXact() throws SQLException {
    }

    synchronized void setFreePending(boolean bl) {
        this.freePending = bl;
    }

    synchronized boolean getFreePending() {
        return this.freePending;
    }

    synchronized boolean xactPending() {
        return this.transaction != null;
    }

    public Linkable getPrevious() {
        return this.previous;
    }

    public void setPrevious(Linkable linkable) {
        this.previous = linkable;
    }

    public Linkable getNext() {
        return this.next;
    }

    public void setNext(Linkable linkable) {
        this.next = linkable;
    }

    synchronized boolean getPooled() {
        return this.pooled;
    }

    synchronized void setPooled(boolean bl) {
        this.pooled = bl;
    }

    synchronized String getURL() {
        return this.url;
    }

    synchronized String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalCommit() {
        logger.finest("sqlstore.connectionimpl.internalcommit");
        try {
            try {
                this.connection.commit();
            }
            catch (Exception exception) {
                try {
                    try {
                        this.connection.rollback();
                    }
                    catch (Exception exception2) {
                        Object var4_5 = null;
                        this.clearXact();
                    }
                    Object var4_4 = null;
                    this.clearXact();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.clearXact();
                    throw throwable;
                }
                throw new JDODataStoreException(null, exception);
            }
            Object var6_1 = null;
            this.clearXact();
        }
        catch (Throwable throwable) {
            Object var6_2 = null;
            this.clearXact();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalRollback() {
        logger.finest("sqlstore.connectionimpl.internalrollback");
        try {
            try {
                this.connection.rollback();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.clearXact();
            }
            Object var3_1 = null;
            this.clearXact();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearXact();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearXact() {
        logger.finest("sqlstore.connectionimpl.clearxact");
        try {
            try {
                if (this.freePending) {
                    this.freePending = false;
                    if (this.pooled) {
                        this.connectionManager.disassociateXact(this.transaction, this, true);
                        logger.finest("sqlstore.connectionimpl.pendingdisassocxact");
                    } else {
                        this.connectionManager.disassociateXact(this.transaction, this, false);
                        this.connection.close();
                        logger.finest("sqlstore.connectionimpl.clearxact.close");
                    }
                } else {
                    this.connectionManager.disassociateXact(this.transaction, this, false);
                    logger.finest("sqlstore.connectionimpl.clearxact.disassocxact");
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                Object var3_2 = null;
                this.transaction = null;
            }
            Object var3_1 = null;
            this.transaction = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.transaction = null;
            throw throwable;
        }
    }

    public synchronized String toString() {
        int n = 0;
        String string = "Connect@";
        String string2 = this.transaction == null ? "  NULL" : this.transaction.toString();
        int n2 = this.hashCode();
        try {
            n = this.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            n = -1;
        }
        string = string + n2 + "\n" + "  pooled = " + this.pooled + "\n" + "  freePending = " + this.freePending + "\n" + "  xactIsolation = " + n + "\n" + "  Tran = " + string2 + "\n";
        return string;
    }

    protected void finalize() {
        try {
            this.connection.close();
            logger.finest("sqlstore.connectionimpl.finalize");
        }
        catch (SQLException sQLException) {}
    }
}

