/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.cmp;

import com.sun.jdo.api.persistence.support.PersistenceManager;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.JDOEJB20Helper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import javax.ejb.EJBLocalObject;

public class EJBHashSet
extends HashSet {
    private PersistenceManager pm = null;
    private Transaction tx = null;
    private HashSet pcSet = null;
    private JDOEJB20Helper helper = null;
    private boolean valid = false;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public EJBHashSet(PersistenceManager persistenceManager, JDOEJB20Helper jDOEJB20Helper, Collection collection) {
        this.pm = persistenceManager;
        this.tx = persistenceManager.currentTransaction();
        this.helper = jDOEJB20Helper;
        if (logger.isLoggable(300)) {
            logger.finest("---EJBHashSet.new--- " + (collection == null ? -1 : collection.size()));
        }
        this.setSCOHashSet(collection);
        this.valid = true;
    }

    public boolean add(Object object) {
        logger.finest("---EJBHashSet.add---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertType(object);
        Object object2 = this.helper.convertEJBLocalObjectToPC((EJBLocalObject)object, this.pm, true);
        return this.pcSet.add(object2);
    }

    public boolean addAll(Collection collection) {
        logger.finest("---EJBHashSet.addAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertTypes(collection);
        return this.pcSet.addAll(this.helper.convertCollectionEJBLocalObjectToPC(collection, this.pm, true));
    }

    public boolean remove(Object object) {
        logger.finest("---EJBHashSet.remove---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertType(object);
        EJBLocalObject eJBLocalObject = (EJBLocalObject)object;
        return this.pcSet.remove(this.helper.convertEJBLocalObjectToPC(eJBLocalObject, this.pm, true));
    }

    public boolean removeAll(Collection collection) {
        logger.finest("---EJBHashSet.removeAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertTypes(collection);
        return this.pcSet.removeAll(this.helper.convertCollectionEJBLocalObjectToPC(collection, this.pm, true));
    }

    public boolean retainAll(Collection collection) {
        logger.finest("---EJBHashSet.retainAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertTypes(collection);
        return this.pcSet.retainAll(this.helper.convertCollectionEJBLocalObjectToPC(collection, this.pm, true));
    }

    public void clear() {
        logger.finest("---EJBHashSet.clear---");
        this.assertIsValid();
        this.assertInTransaction();
        this.pcSet.clear();
    }

    public int size() {
        logger.finest("---EJBHashSet.size---");
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet.size();
    }

    public boolean isEmpty() {
        logger.finest("---EJBHashSet.isEmpty---");
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet.isEmpty();
    }

    public boolean contains(Object object) {
        logger.finest("---EJBHashSet.contains---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertType(object);
        EJBLocalObject eJBLocalObject = (EJBLocalObject)object;
        return this.pcSet.contains(this.helper.convertEJBLocalObjectToPC(eJBLocalObject, this.pm, true));
    }

    public boolean containsAll(Collection collection) {
        logger.finest("---EJBHashSet.containsAll---");
        this.assertIsValid();
        this.assertInTransaction();
        this.assertTypes(collection);
        return this.pcSet.containsAll(this.helper.convertCollectionEJBLocalObjectToPC(collection, this.pm, true));
    }

    public Object clone() {
        logger.finest("---EJBHashSet.clone---");
        EJBHashSet eJBHashSet = (EJBHashSet)super.clone();
        eJBHashSet.pcSet = (HashSet)this.pcSet.clone();
        return eJBHashSet;
    }

    public HashSet getSCOHashSet() {
        this.assertIsValid();
        this.assertInTransaction();
        return this.pcSet != null ? (HashSet)this.pcSet.clone() : null;
    }

    public void setSCOHashSet(Collection collection) {
        this.pcSet = collection instanceof HashSet ? (HashSet)collection : new HashSet(collection);
    }

    public Iterator iterator() {
        this.assertIsValid();
        this.assertInTransaction();
        return new EJBHashIterator();
    }

    private void assertIsValid() {
        if (!this.valid) {
            throw new IllegalStateException();
        }
    }

    private void assertInTransaction() {
        if (this.pm.isClosed() || !this.tx.isActive()) {
            this.invalidate();
            throw new IllegalStateException();
        }
    }

    private void assertType(Object object) {
        if (!this.helper.isLocalObjectType(object)) {
            throw new IllegalArgumentException();
        }
    }

    private void assertTypes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.assertType(iterator.next());
        }
    }

    private void invalidate() {
        this.valid = false;
        this.pm = null;
        this.tx = null;
        this.helper = null;
        this.pcSet = null;
    }

    private class EJBHashIterator
    implements Iterator {
        Iterator _iterator = null;
        Object lastReturned = null;

        EJBHashIterator() {
            this._iterator = EJBHashSet.this.pcSet.iterator();
        }

        public boolean hasNext() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            return this._iterator.hasNext();
        }

        public Object next() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            try {
                this.lastReturned = this._iterator.next();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                throw new IllegalStateException();
            }
            return EJBHashSet.this.helper.convertPCToEJBLocalObject(this.lastReturned, EJBHashSet.this.pm);
        }

        public void remove() {
            EJBHashSet.this.assertIsValid();
            EJBHashSet.this.assertInTransaction();
            try {
                this._iterator.remove();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                throw new IllegalStateException();
            }
        }
    }
}

