/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.ANTLRException;
import antlr.TokenStreamException;
import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Option;
import antlr.preprocessor.Preprocessor;
import antlr.preprocessor.PreprocessorLexer;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Hierarchy {
    protected static Grammar LexerRoot = new Grammar("Lexer", null, null);
    protected static Grammar ParserRoot = new Grammar("Parser", null, null);
    protected static Grammar TreeParserRoot = new Grammar("TreeParser", null, null);
    protected Hashtable symbols = new Hashtable(10);
    protected Hashtable files = new Hashtable(10);

    public void addGrammar(Grammar grammar) {
        grammar.setHierarchy(this);
        this.symbols.put(grammar.getName(), grammar);
        GrammarFile grammarFile = this.getFile(grammar.getFileName());
        grammarFile.addGrammar(grammar);
    }

    public void addGrammarFile(GrammarFile grammarFile) {
        this.files.put(grammarFile.getName(), grammarFile);
    }

    public void expandGrammarsInFile(String string) {
        GrammarFile grammarFile = this.getFile(string);
        Enumeration enumeration = grammarFile.getGrammars().elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar = (Grammar)enumeration.nextElement();
            grammar.expandInPlace();
        }
    }

    public Grammar findRoot(Grammar grammar) {
        if (grammar.getSuperGrammarName() == null) {
            return grammar;
        }
        Grammar grammar2 = grammar.getSuperGrammar();
        if (grammar2 == null) {
            return grammar;
        }
        return this.findRoot(grammar2);
    }

    public GrammarFile getFile(String string) {
        return (GrammarFile)this.files.get(string);
    }

    public Grammar getGrammar(String string) {
        return (Grammar)this.symbols.get(string);
    }

    public static String optionsToString(IndexedVector indexedVector) {
        String string = "options {" + System.getProperty("line.separator");
        Enumeration enumeration = indexedVector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (Option)enumeration.nextElement() + System.getProperty("line.separator");
        }
        string = string + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readGrammarFile(String string) throws FileNotFoundException {
        FileReader fileReader = new FileReader(string);
        this.addGrammarFile(new GrammarFile(string));
        PreprocessorLexer preprocessorLexer = new PreprocessorLexer(fileReader);
        preprocessorLexer.setFilename(string);
        Preprocessor preprocessor = new Preprocessor(preprocessorLexer);
        preprocessor.setFilename(string);
        try {
            preprocessor.grammarFile(this, string);
            return;
        }
        catch (TokenStreamException tokenStreamException) {
            Tool.toolError("Token stream error reading grammar(s):" + tokenStreamException);
            return;
        }
        catch (ANTLRException aNTLRException) {
            Tool.toolError("error reading grammar(s):" + aNTLRException);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        Grammar grammar;
        boolean bl = true;
        Enumeration enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar2;
            grammar = (Grammar)enumeration.nextElement();
            if (grammar.getSuperGrammarName() == null || (grammar2 = grammar.getSuperGrammar()) != null) continue;
            Tool.toolError("grammar " + grammar.getSuperGrammarName() + " not defined");
            bl = false;
            this.symbols.remove(grammar.getName());
        }
        if (!bl) {
            return false;
        }
        enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            grammar = (Grammar)enumeration.nextElement();
            if (grammar.getSuperGrammarName() == null) continue;
            grammar.setType(this.findRoot(grammar).getName());
        }
        return true;
    }

    public Hierarchy() {
        LexerRoot.setPredefined(true);
        ParserRoot.setPredefined(true);
        TreeParserRoot.setPredefined(true);
        this.symbols.put(LexerRoot.getName(), LexerRoot);
        this.symbols.put(ParserRoot.getName(), ParserRoot);
        this.symbols.put(TreeParserRoot.getName(), TreeParserRoot);
    }
}

