/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class DBStatement {
    public static final String BATCH_THRESHOLD_PROPERTY = "com.sun.jdo.spi.persistence.support.sqlstore.BATCH_THRESHOLD";
    private static final int BATCH_THRESHOLD = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.BATCH_THRESHOLD", 100);
    private PreparedStatement preparedStmt;
    private int batchCounter = 0;
    private String statementText;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public DBStatement(Connection connection, String string, int n) throws SQLException {
        this.statementText = string;
        this.preparedStmt = connection.prepareStatement(string);
        this.preparedStmt.setQueryTimeout(n);
    }

    public String getStatementText() {
        return this.statementText;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean exceedsBatchThreshold() {
        return this.batchCounter >= BATCH_THRESHOLD;
    }

    public void addBatch() throws SQLException {
        ++this.batchCounter;
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sql.generator.dbstatement.addbatch", new Integer(this.batchCounter));
        }
        this.preparedStmt.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        if (logger.isLoggable(400)) {
            logger.finer("sqlstore.sql.generator.dbstatement.executebatch", new Integer(this.batchCounter));
        }
        this.batchCounter = 0;
        return this.preparedStmt.executeBatch();
    }

    public int executeUpdate() throws SQLException {
        return this.preparedStmt.executeUpdate();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.preparedStmt.executeQuery();
    }

    public void close() throws SQLException {
        if (this.preparedStmt != null) {
            this.preparedStmt.close();
        }
    }

    public void bindInputColumn(int n, Object object, int n2, DBVendorType dBVendorType) throws SQLException {
        Object object2;
        if (logger.isLoggable(400)) {
            object2 = new Object[]{new Integer(n), object, new Integer(n2)};
            logger.finer("sqlstore.sql.generator.dbstatement.bindinputcolumn", (Object[])object2);
        }
        if (object == null) {
            try {
                this.preparedStmt.setNull(n, n2);
            }
            catch (SQLException sQLException) {
                if ("ORACLE".equals(dBVendorType.getName())) {
                    if (n2 == 91) {
                        this.preparedStmt.setNull(n, 12);
                    }
                    throw sQLException;
                }
                throw sQLException;
            }
        } else if (object instanceof Number) {
            object2 = (Number)object;
            if (object2 instanceof Integer) {
                this.preparedStmt.setInt(n, ((Number)object2).intValue());
            } else if (object2 instanceof Long) {
                try {
                    this.preparedStmt.setLong(n, ((Number)object2).longValue());
                }
                catch (SQLException sQLException) {
                    if ("ORACLE".equals(dBVendorType.getName()) || "MSSQL".equals(dBVendorType.getName())) {
                        try {
                            this.preparedStmt.setDouble(n, ((Number)object2).doubleValue());
                        }
                        catch (Exception exception) {
                            this.preparedStmt.setFloat(n, ((Number)object2).floatValue());
                        }
                    }
                    throw sQLException;
                }
            } else if (object2 instanceof Short) {
                this.preparedStmt.setShort(n, ((Number)object2).shortValue());
            } else if (object2 instanceof Byte) {
                this.preparedStmt.setByte(n, ((Number)object2).byteValue());
            } else if (object2 instanceof Double) {
                this.preparedStmt.setDouble(n, ((Number)object2).doubleValue());
            } else if (object2 instanceof Float) {
                this.preparedStmt.setFloat(n, ((Number)object2).floatValue());
            } else if (object2 instanceof BigDecimal) {
                this.preparedStmt.setBigDecimal(n, (BigDecimal)object2);
            } else if (object2 instanceof BigInteger) {
                this.preparedStmt.setBigDecimal(n, new BigDecimal((BigInteger)object2));
            }
        } else if (object instanceof String) {
            this.preparedStmt.setString(n, (String)object);
        } else if (object instanceof Boolean) {
            this.preparedStmt.setBoolean(n, (Boolean)object);
        } else if (object instanceof java.util.Date) {
            object2 = (java.util.Date)object;
            try {
                if (object2 instanceof Date) {
                    this.preparedStmt.setDate(n, (Date)object2);
                }
                if (object2 instanceof Time) {
                    this.preparedStmt.setTime(n, (Time)object2);
                }
                if (object2 instanceof Timestamp) {
                    this.preparedStmt.setTimestamp(n, (Timestamp)object2);
                }
                this.preparedStmt.setTimestamp(n, new Timestamp(((java.util.Date)object2).getTime()));
            }
            catch (SQLException sQLException) {
                if ("ORACLE".equals(dBVendorType.getName())) {
                    this.preparedStmt.setTimestamp(n, new Timestamp(((java.util.Date)object2).getTime()));
                }
                throw sQLException;
            }
        } else if (object instanceof Character) {
            this.preparedStmt.setString(n, ((Character)object).toString());
        } else if (object instanceof byte[]) {
            object2 = (byte[])object;
            this.preparedStmt.setBinaryStream(n, (InputStream)new ByteArrayInputStream((byte[])object2), ((Object)object2).length);
        } else if (object instanceof Blob) {
            this.preparedStmt.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            this.preparedStmt.setClob(n, (Clob)object);
        } else {
            this.preparedStmt.setObject(n, object);
        }
    }
}

