/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.SCOCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;

public class ArrayList
extends java.util.ArrayList
implements SCOCollection {
    private transient PersistenceCapable owner;
    private transient String fieldName;
    private transient Class elementType;
    private transient boolean allowNulls;
    private transient Vector added = new Vector();
    private transient Vector removed = new Vector();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.impl.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList = ArrayList.class$("com.sun.jdo.spi.persistence.support.sqlstore.sco.ArrayList")) : class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList).getClassLoader());
    private static final ResourceBundle messages1 = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList = ArrayList.class$("com.sun.jdo.spi.persistence.support.sqlstore.sco.ArrayList")) : class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList).getClassLoader());
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$sco$ArrayList;

    public ArrayList(Object object, String string, Class clazz, boolean bl) {
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    public ArrayList(Object object, String string, Class clazz, boolean bl, int n) {
        super(n);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
        this.elementType = clazz;
        this.allowNulls = bl;
    }

    public Object set(int n, Object object) {
        this.throwUnsupportedOption();
        if (object == null) {
            if (!this.allowNulls) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
            }
            return this.remove(n);
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            StateManager stateManager = this.makeDirty();
            Object object2 = super.set(n, object);
            if (!this.added.remove(object2)) {
                this.removed.add(object2);
            }
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
            this.applyUpdates(stateManager, true);
            return object2;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
    }

    public boolean add(Object object) {
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            StateManager stateManager = this.makeDirty();
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
            boolean bl = super.add(object);
            this.applyUpdates(stateManager, bl);
            return bl;
        }
        throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
    }

    public boolean remove(Object object) {
        StateManager stateManager = this.makeDirty();
        int n = super.indexOf(object);
        Object e = null;
        if (n > -1) {
            e = super.remove(n);
            if (!this.added.remove(e)) {
                this.removed.add(e);
            }
            this.applyUpdates(stateManager, true);
            return true;
        }
        return false;
    }

    public void add(int n, Object object) {
        StateManager stateManager;
        if (!this.allowNulls && object == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        if (this.elementType == null || this.elementType.isAssignableFrom(object.getClass())) {
            stateManager = this.makeDirty();
            super.add(n, object);
            if (!this.removed.remove(object)) {
                this.added.add(object);
            }
        } else {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), new Object[]{object});
        }
        this.applyUpdates(stateManager, true);
    }

    public Object remove(int n) {
        this.throwUnsupportedOption();
        StateManager stateManager = this.makeDirty();
        Object e = super.remove(n);
        if (!this.added.remove(e)) {
            this.removed.add(e);
        }
        this.applyUpdates(stateManager, true);
        return e;
    }

    public void clear() {
        StateManager stateManager = this.makeDirty();
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.added.remove(e)) continue;
            this.removed.add(e);
        }
        this.added.clear();
        super.clear();
        this.applyUpdates(stateManager, true);
    }

    public boolean addAll(Collection collection) {
        Object object;
        if (!this.allowNulls && collection.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        Vector vector = new Vector();
        if (this.elementType != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.elementType.isAssignableFrom(e.getClass())) continue;
                vector.add(e);
            }
        }
        if (vector != null && vector.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), vector.toArray());
        }
        object = this.makeDirty();
        this.removed.removeAll(collection);
        this.added.addAll(collection);
        boolean bl = super.addAll(collection);
        this.applyUpdates((StateManager)object, bl);
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        StateManager stateManager = this.makeDirty();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!super.contains(e)) continue;
            this.removeInternal(e);
            if (!this.added.remove(e)) {
                this.removed.add(e);
            }
            bl = true;
        }
        this.applyUpdates(stateManager, bl);
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        Object object;
        if (!this.allowNulls && collection.contains(null)) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.nulls_not_allowed"));
        }
        Vector vector = new Vector();
        if (this.elementType != null) {
            object = collection.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (this.elementType.isAssignableFrom(e.getClass())) continue;
                vector.add(e);
            }
        }
        if (vector != null && vector.size() > 0) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "sco.classcastexception", this.elementType.getName()), new ClassCastException(), vector.toArray());
        }
        object = this.makeDirty();
        this.removed.removeAll(collection);
        this.added.addAll(collection);
        boolean bl = super.addAll(n, collection);
        this.applyUpdates((StateManager)object, bl);
        return bl;
    }

    public boolean retainAll(Collection collection) {
        Iterator iterator;
        boolean bl = false;
        Vector vector = new Vector();
        StateManager stateManager = this.makeDirty();
        Iterator iterator2 = super.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            if (collection.contains(iterator)) continue;
            vector.add(iterator);
            if (!this.added.remove(iterator)) {
                this.removed.add(iterator);
            }
            bl = true;
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.removeInternal(iterator.next());
        }
        this.applyUpdates(stateManager, bl);
        return bl;
    }

    public Object clone() {
        ArrayList arrayList = (ArrayList)super.clone();
        arrayList.unsetOwner();
        return arrayList;
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void reset() {
        this.added.clear();
        this.removed.clear();
    }

    public void markDeferred() {
    }

    public boolean isDeferred() {
        return false;
    }

    public void applyDeferredUpdates(Collection collection) {
        super.addAll(collection);
    }

    public void addInternal(Object object) {
        super.add(object);
    }

    public void addAllInternal(Collection collection) {
        super.addAll(collection);
    }

    public void removeAllInternal(Collection collection) {
        super.removeAll(collection);
    }

    public Collection getAdded() {
        return this.added;
    }

    public Collection getRemoved() {
        return this.removed;
    }

    public void clearInternal() {
        super.clear();
        this.reset();
    }

    public void removeInternal(Object object) {
        int n = super.indexOf(object);
        super.remove(n);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
        this.elementType = null;
        this.added.clear();
        this.removed.clear();
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public StateManager makeDirty() {
        if (this.owner != null) {
            StateManager stateManager = this.owner.jdoGetStateManager();
            if (stateManager != null) {
                stateManager.makeDirty(this.fieldName);
            }
            return stateManager;
        }
        return null;
    }

    public void applyUpdates(StateManager stateManager, boolean bl) {
        if (bl && stateManager != null) {
            stateManager.applyUpdates(this.fieldName, this);
        }
    }

    private void throwUnsupportedOption() {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "sco.not_supported"));
    }

    public void setOwner(Object object, String string, Class clazz) {
        if (this.owner != null) {
            throw new JDOUserException(I18NHelper.getMessage(messages1, "core.statemanager.anotherowner"), new Object[]{this.owner, this.fieldName});
        }
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
            this.elementType = clazz;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

